/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.MethodInvocationAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MethodInvocationAccessorTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        MethodInvocationAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setText(String text, boolean html) {", "  }", "}"));
        MethodInvocationAccessorTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodInvocationAccessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setText'>", "      <parameter type='java.lang.String' name='text' defaultSource='null'/>", "      <parameter type='boolean' name='html'/>", "    </method>", "  </methods>", "  <method-property title='text' method='setText(java.lang.String,boolean)'/>", "</component>"));
        MethodInvocationAccessorTest.waitForAutoBuild();
    }

    @Test
    public void test_access() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("text");
        MethodInvocationAccessor accessor = (MethodInvocationAccessor)MethodInvocationAccessorTest.getGenericPropertyAccessors(property).get(0);
        MethodInvocationAccessorTest.assertNull((Object)accessor.getAdapter(null));
        MethodInvocationAccessorTest.assertNotNull((Object)accessor.getAdapter(IAccessibleExpressionAccessor.class));
        MethodInvocationAccessorTest.assertNotNull((Object)accessor.getAdapter(PropertyTooltipProvider.class));
    }

    @Test
    public void test_getExpression_noInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("text");
        MethodInvocationAccessor accessor = (MethodInvocationAccessor)MethodInvocationAccessorTest.getGenericPropertyAccessors(property).get(0);
        MethodInvocationAccessorTest.assertNull((Object)accessor.getExpression((JavaInfo)panel));
    }

    @Test
    public void test_getExpression_hasInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setText('text', false);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("text");
        MethodInvocationAccessor accessor = (MethodInvocationAccessor)MethodInvocationAccessorTest.getGenericPropertyAccessors(property).get(0);
        MethodInvocation invocation = (MethodInvocation)accessor.getExpression((JavaInfo)panel);
        MethodInvocationAccessorTest.assertEquals((Object)"setText(\"text\", false)", (Object)this.m_lastEditor.getSource((ASTNode)invocation));
    }

    @Test
    public void test_setExpression_addNew() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("text");
        MethodInvocationAccessor accessor = (MethodInvocationAccessor)MethodInvocationAccessorTest.getGenericPropertyAccessors(property).get(0);
        accessor.setExpression((JavaInfo)panel, "\"new text\", true");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setText('new text', true);", "  }", "}");
    }

    @Test
    public void test_setExpression_removeExisting() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setText('text', false);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("text");
        MethodInvocationAccessor accessor = (MethodInvocationAccessor)MethodInvocationAccessorTest.getGenericPropertyAccessors(property).get(0);
        accessor.setExpression((JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setExpression_replaceExisting() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setText('text', false);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("text");
        MethodInvocationAccessor accessor = (MethodInvocationAccessor)MethodInvocationAccessorTest.getGenericPropertyAccessors(property).get(0);
        accessor.setExpression((JavaInfo)panel, "\"new text\", true");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setText('new text', true);", "  }", "}");
    }
}

