/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property;

import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.BooleanArrayConverter;
import org.eclipse.wb.internal.core.model.property.converter.BooleanConverter;
import org.eclipse.wb.internal.core.model.property.converter.BooleanObjectConverter;
import org.eclipse.wb.internal.core.model.property.converter.ByteConverter;
import org.eclipse.wb.internal.core.model.property.converter.ByteObjectConverter;
import org.eclipse.wb.internal.core.model.property.converter.CharacterConverter;
import org.eclipse.wb.internal.core.model.property.converter.DoubleConverter;
import org.eclipse.wb.internal.core.model.property.converter.DoubleObjectConverter;
import org.eclipse.wb.internal.core.model.property.converter.FloatConverter;
import org.eclipse.wb.internal.core.model.property.converter.IntegerArrayConverter;
import org.eclipse.wb.internal.core.model.property.converter.IntegerConverter;
import org.eclipse.wb.internal.core.model.property.converter.IntegerObjectConverter;
import org.eclipse.wb.internal.core.model.property.converter.LocaleConverter;
import org.eclipse.wb.internal.core.model.property.converter.LongConverter;
import org.eclipse.wb.internal.core.model.property.converter.LongObjectConverter;
import org.eclipse.wb.internal.core.model.property.converter.ShortConverter;
import org.eclipse.wb.internal.core.model.property.converter.ShortObjectConverter;
import org.eclipse.wb.internal.core.model.property.converter.StringArrayConverter;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class StandardConvertersTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_property_boolean() throws Exception {
        this.check_converter("boolean", Boolean.TRUE, "true");
    }

    @Test
    public void test_property_short() throws Exception {
        this.check_converter("short", (short)123, "(short) 123");
    }

    @Test
    public void test_property_int() throws Exception {
        this.check_converter("int", 123, "123");
    }

    @Test
    public void test_property_float() throws Exception {
        this.check_converter("float", Float.valueOf(123.4f), "123.4f");
    }

    @Test
    public void test_property_double() throws Exception {
        this.check_converter("double", 123.4, "123.4");
    }

    @Test
    public void test_property_String() throws Exception {
        this.check_converter("String", "abc", "\"abc\"");
    }

    private void check_converter(String typeName, Object value, String expectedSource) throws Exception {
        StandardConvertersTest.setFileContentSrc("test/Base.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Base extends JPanel {", "  public void setValue(" + typeName + " value) {", "  }", "}"));
        StandardConvertersTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends Base {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("value");
        property.setValue(value);
        this.assertEditor("// filler filler filler", "public final class Test extends Base {", "  public Test() {", "    setValue(" + expectedSource + ");", "  }", "}");
    }

    @Test
    public void test_BooleanConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Boolean.TYPE);
        BooleanConverter converter = BooleanConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"false", (Object)converter.toJavaSource(null, (Object)Boolean.FALSE));
        StandardConvertersTest.assertEquals((Object)"true", (Object)converter.toJavaSource(null, (Object)Boolean.TRUE));
    }

    @Test
    public void test_CharacterConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Character.TYPE);
        CharacterConverter converter = CharacterConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"'0'", (Object)converter.toJavaSource(null, (Object)Character.valueOf('0')));
    }

    @Test
    public void test_ByteConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Byte.TYPE);
        ByteConverter converter = ByteConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(byte) 1", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"(byte) -1", (Object)converter.toJavaSource(null, (Object)-1));
    }

    @Test
    public void test_ShortConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Short.TYPE);
        ShortConverter converter = ShortConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(short) 1", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"(short) -1", (Object)converter.toJavaSource(null, (Object)-1));
    }

    @Test
    public void test_IntegerConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Integer.TYPE);
        IntegerConverter converter = IntegerConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"1", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"-1", (Object)converter.toJavaSource(null, (Object)-1));
    }

    @Test
    public void test_LongConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Long.TYPE);
        LongConverter converter = LongConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"1L", (Object)converter.toJavaSource(null, (Object)1L));
        StandardConvertersTest.assertEquals((Object)"-1L", (Object)converter.toJavaSource(null, (Object)-1L));
    }

    @Test
    public void test_FloatConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Float.TYPE);
        FloatConverter converter = FloatConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"0.0f", (Object)converter.toJavaSource(null, (Object)Float.valueOf(0.0f)));
        StandardConvertersTest.assertEquals((Object)"1.0f", (Object)converter.toJavaSource(null, (Object)Float.valueOf(1.0f)));
        StandardConvertersTest.assertEquals((Object)"1.2f", (Object)converter.toJavaSource(null, (Object)Float.valueOf(1.2f)));
        StandardConvertersTest.assertEquals((Object)"-1.2f", (Object)converter.toJavaSource(null, (Object)Float.valueOf(-1.2f)));
    }

    @Test
    public void test_DoubleConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Double.TYPE);
        DoubleConverter converter = DoubleConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"0.0", (Object)converter.toJavaSource(null, (Object)0.0));
        StandardConvertersTest.assertEquals((Object)"1.0", (Object)converter.toJavaSource(null, (Object)1.0));
        StandardConvertersTest.assertEquals((Object)"1.2", (Object)converter.toJavaSource(null, (Object)1.2));
        StandardConvertersTest.assertEquals((Object)"-1.2", (Object)converter.toJavaSource(null, (Object)-1.2));
        StandardConvertersTest.assertEquals((Object)"1.0", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"1.0", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"1.0", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"1.0", (Object)converter.toJavaSource(null, (Object)Float.valueOf(1.0f)));
    }

    @Test
    public void test_StringArrayConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(String[].class);
        StringArrayConverter converter = StringArrayConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(String[]) null", (Object)converter.toJavaSource(null, null));
        StandardConvertersTest.assertEquals((Object)"new String[] {}", (Object)converter.toJavaSource(null, (Object)new String[0]));
        StandardConvertersTest.assertEquals((Object)"new String[] {\"a\"}", (Object)converter.toJavaSource(null, (Object)new String[]{"a"}));
        StandardConvertersTest.assertEquals((Object)"new String[] {\"a\", \"b\"}", (Object)converter.toJavaSource(null, (Object)new String[]{"a", "b"}));
    }

    @Test
    public void test_BooleanArrayConverter() throws Exception {
        StandardConvertersTest.assertNotNull((Object)DescriptionPropertiesHelper.getConverterForType(boolean[].class));
        BooleanArrayConverter converter = BooleanArrayConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(boolean[]) null", (Object)converter.toJavaSource(null, null));
        StandardConvertersTest.assertEquals((Object)"new boolean[] {}", (Object)converter.toJavaSource(null, (Object)new boolean[0]));
        StandardConvertersTest.assertEquals((Object)"new boolean[] {true}", (Object)converter.toJavaSource(null, (Object)new boolean[]{true}));
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        StandardConvertersTest.assertEquals((Object)"new boolean[] {false, true}", (Object)converter.toJavaSource(null, (Object)blArray));
    }

    @Test
    public void test_IntegerArrayConverter() throws Exception {
        StandardConvertersTest.assertNotNull((Object)DescriptionPropertiesHelper.getConverterForType(int[].class));
        IntegerArrayConverter converter = IntegerArrayConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(int[]) null", (Object)converter.toJavaSource(null, null));
        StandardConvertersTest.assertEquals((Object)"new int[] {}", (Object)converter.toJavaSource(null, (Object)new int[0]));
        StandardConvertersTest.assertEquals((Object)"new int[] {1}", (Object)converter.toJavaSource(null, (Object)new int[]{1}));
        StandardConvertersTest.assertEquals((Object)"new int[] {1, 2, 3}", (Object)converter.toJavaSource(null, (Object)new int[]{1, 2, 3}));
    }

    @Test
    public void test_LocaleConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(Locale.class);
        LocaleConverter converter = LocaleConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(java.util.Locale) null", (Object)converter.toJavaSource(null, null));
        StandardConvertersTest.assertEquals((Object)"java.util.Locale.ENGLISH", (Object)converter.toJavaSource(null, (Object)Locale.ENGLISH));
        StandardConvertersTest.assertEquals((Object)"java.util.Locale.CANADA_FRENCH", (Object)converter.toJavaSource(null, (Object)Locale.of("fr", "CA")));
        StandardConvertersTest.assertEquals((Object)"java.util.Locale.US", (Object)converter.toJavaSource(null, (Object)Locale.US));
        StandardConvertersTest.assertEquals((Object)"new java.util.Locale(\"ru\")", (Object)converter.toJavaSource(null, (Object)Locale.of("ru")));
        StandardConvertersTest.assertEquals((Object)"new java.util.Locale(\"ru\", \"RU\")", (Object)converter.toJavaSource(null, (Object)Locale.of("ru", "RU")));
        StandardConvertersTest.assertEquals((Object)"new java.util.Locale(\"no\\tlocale\")", (Object)converter.toJavaSource(null, (Object)Locale.of("no\tlocale")));
    }

    @Test
    public void test_BooleanObjectConverter_noJava() throws Exception {
        StandardConvertersTest.assertConverterEditor(Boolean.class);
        BooleanObjectConverter converter = BooleanObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Boolean.FALSE", (Object)converter.toJavaSource(null, (Object)false));
        StandardConvertersTest.assertEquals((Object)"Boolean.TRUE", (Object)converter.toJavaSource(null, (Object)true));
    }

    @Test
    public void test_BooleanObjectConverter_null() throws Exception {
        BooleanObjectConverter converter = BooleanObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(Boolean) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_BooleanObjectConverter_forJava5() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        BooleanObjectConverter converter = BooleanObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(Boolean) null", (Object)converter.toJavaSource((JavaInfo)panel, null));
        StandardConvertersTest.assertEquals((Object)"false", (Object)converter.toJavaSource((JavaInfo)panel, (Object)false));
        StandardConvertersTest.assertEquals((Object)"true", (Object)converter.toJavaSource((JavaInfo)panel, (Object)true));
    }

    @Test
    public void test_ByteObjectConverter_noJava() throws Exception {
        StandardConvertersTest.assertConverterEditor(Byte.class);
        ByteObjectConverter converter = ByteObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Byte.valueOf((byte) 1)", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"Byte.valueOf((byte) -1)", (Object)converter.toJavaSource(null, (Object)-1));
    }

    @Test
    public void test_ByteObjectConverter_null() throws Exception {
        ByteObjectConverter converter = ByteObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(Byte) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_ByteObjectConverter_forJava5() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ByteObjectConverter converter = ByteObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(byte) 1", (Object)converter.toJavaSource((JavaInfo)panel, (Object)1));
        StandardConvertersTest.assertEquals((Object)"(byte) -1", (Object)converter.toJavaSource((JavaInfo)panel, (Object)-1));
    }

    @DisposeProjectAfter
    @Test
    public void test_ByteObjectConverter_forJava5_disableBoxing() throws Exception {
        m_javaProject.setOption("org.eclipse.jdt.core.compiler.problem.autoboxing", "error");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ByteObjectConverter converter = ByteObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Byte.valueOf((byte) 1)", (Object)converter.toJavaSource((JavaInfo)panel, (Object)1));
        StandardConvertersTest.assertEquals((Object)"Byte.valueOf((byte) -1)", (Object)converter.toJavaSource((JavaInfo)panel, (Object)-1));
    }

    @Test
    public void test_ShortObjectConverter_null() throws Exception {
        ShortObjectConverter converter = ShortObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(Short) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_ShortObjectConverter_forJava5() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ShortObjectConverter converter = ShortObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(short) 1", (Object)converter.toJavaSource((JavaInfo)panel, (Object)1));
        StandardConvertersTest.assertEquals((Object)"(short) -1", (Object)converter.toJavaSource((JavaInfo)panel, (Object)-1));
    }

    @Test
    public void test_IntegerObjectConverter_noJava() throws Exception {
        StandardConvertersTest.assertConverterEditor(Integer.class);
        IntegerObjectConverter converter = IntegerObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Integer.valueOf(1)", (Object)converter.toJavaSource(null, (Object)1));
        StandardConvertersTest.assertEquals((Object)"Integer.valueOf(-1)", (Object)converter.toJavaSource(null, (Object)-1));
    }

    @Test
    public void test_IntegerObjectConverter_null() throws Exception {
        IntegerObjectConverter converter = IntegerObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(Integer) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_IntegerObjectConverter_forJava5() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IntegerObjectConverter converter = IntegerObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"1", (Object)converter.toJavaSource((JavaInfo)panel, (Object)1));
        StandardConvertersTest.assertEquals((Object)"-1", (Object)converter.toJavaSource((JavaInfo)panel, (Object)-1));
    }

    @Test
    public void test_LongObjectConverter_noJava() throws Exception {
        StandardConvertersTest.assertConverterEditor(Long.class);
        LongObjectConverter converter = LongObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Long.valueOf(1L)", (Object)converter.toJavaSource(null, (Object)1L));
        StandardConvertersTest.assertEquals((Object)"Long.valueOf(-1L)", (Object)converter.toJavaSource(null, (Object)-1L));
    }

    @Test
    public void test_LongObjectConverter_null() throws Exception {
        LongObjectConverter converter = LongObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(Long) null", (Object)converter.toJavaSource(null, null));
    }

    @DisposeProjectAfter
    @Test
    public void test_LongObjectConverter_forJava5_disableBoxing() throws Exception {
        m_javaProject.setOption("org.eclipse.jdt.core.compiler.problem.autoboxing", "error");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LongObjectConverter converter = LongObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Long.valueOf(1L)", (Object)converter.toJavaSource((JavaInfo)panel, (Object)1L));
        StandardConvertersTest.assertEquals((Object)"Long.valueOf(-1L)", (Object)converter.toJavaSource((JavaInfo)panel, (Object)-1L));
    }

    @Test
    public void test_DoubleObjectConverter_noJava() throws Exception {
        StandardConvertersTest.assertConverterEditor(Double.class);
        DoubleObjectConverter converter = DoubleObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Double.valueOf(1.0)", (Object)converter.toJavaSource(null, (Object)1.0));
        StandardConvertersTest.assertEquals((Object)"Double.valueOf(-1.0)", (Object)converter.toJavaSource(null, (Object)-1.0));
        StandardConvertersTest.assertEquals((Object)"Double.valueOf(1.2)", (Object)converter.toJavaSource(null, (Object)1.2));
        StandardConvertersTest.assertEquals((Object)"Double.valueOf(-2.3)", (Object)converter.toJavaSource(null, (Object)-2.3));
    }

    @Test
    public void test_DoubleObjectConverter_null() throws Exception {
        DoubleObjectConverter converter = DoubleObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(Double) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_DoubleObjectConverter_forJava5() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DoubleObjectConverter converter = DoubleObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"1.2", (Object)converter.toJavaSource((JavaInfo)panel, (Object)1.2));
        StandardConvertersTest.assertEquals((Object)"-1.2", (Object)converter.toJavaSource((JavaInfo)panel, (Object)-1.2));
    }

    @DisposeProjectAfter
    @Test
    public void test_DoubleObjectConverter_forJava5_disableBoxing() throws Exception {
        m_javaProject.setOption("org.eclipse.jdt.core.compiler.problem.autoboxing", "error");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        DoubleObjectConverter converter = DoubleObjectConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"Double.valueOf(1.2)", (Object)converter.toJavaSource((JavaInfo)panel, (Object)1.2));
        StandardConvertersTest.assertEquals((Object)"Double.valueOf(-1.2)", (Object)converter.toJavaSource((JavaInfo)panel, (Object)-1.2));
    }

    @Test
    public void test_StringConverter() throws Exception {
        StandardConvertersTest.assertConverterEditor(String.class);
        StringConverter converter = StringConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"(String) null", (Object)converter.toJavaSource(null, null));
        StandardConvertersTest.assertEquals((Object)"\"\"", (Object)converter.toJavaSource(null, (Object)""));
        StandardConvertersTest.assertEquals((Object)"\"abc\"", (Object)converter.toJavaSource(null, (Object)"abc"));
        StandardConvertersTest.check_StringConverter_specialCharacters(null);
    }

    @Test
    public void test_StringConverter_hasFile_withCharset() throws Exception {
        StringConverter converter = StringConverter.INSTANCE;
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IFile file = (IFile)panel.getEditor().getModelUnit().getUnderlyingResource();
        String value = "\u0410\u0411\u0412";
        file.setCharset("ISO-8859-1", null);
        String source = converter.toJavaSource((JavaInfo)panel, (Object)value);
        StandardConvertersTest.assertEquals((Object)"\"\\u0410\\u0411\\u0412\"", (Object)source);
        file.setCharset("UTF-8", null);
        source = converter.toJavaSource((JavaInfo)panel, (Object)value);
        StandardConvertersTest.assertEquals((Object)"\"\u0410\u0411\u0412\"", (Object)source);
        StandardConvertersTest.check_StringConverter_specialCharacters((JavaInfo)panel);
        file.setCharset("UTF-16", null);
        source = converter.toJavaSource((JavaInfo)panel, (Object)value);
        StandardConvertersTest.assertEquals((Object)"\"\u0410\u0411\u0412\"", (Object)source);
        StandardConvertersTest.check_StringConverter_specialCharacters((JavaInfo)panel);
    }

    private static void check_StringConverter_specialCharacters(JavaInfo javaInfo) throws Exception {
        StringConverter converter = StringConverter.INSTANCE;
        StandardConvertersTest.assertEquals((Object)"\"\\\\\"", (Object)converter.toJavaSource(javaInfo, (Object)"\\"));
        StandardConvertersTest.assertEquals((Object)"\"/\"", (Object)converter.toJavaSource(javaInfo, (Object)"/"));
        StandardConvertersTest.assertEquals((Object)"\"\\r\\n\\t\"", (Object)converter.toJavaSource(javaInfo, (Object)"\r\n\t"));
    }

    private static void assertConverterEditor(Class<?> type) throws Exception {
        StandardConvertersTest.assertNotNull((Object)DescriptionPropertiesHelper.getConverterForType(type));
        StandardConvertersTest.assertNotNull((Object)DescriptionPropertiesHelper.getEditorForType(type));
    }
}

