/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.primities;

import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DoubleTest
extends AbstractEngineTest {
    @BeforeAll
    public static void setUpClass() throws Exception {
        DoubleTest.do_projectCreate();
    }

    @Test
    public void test_double_value1() throws Exception {
        this.check_double("1D", 1.0);
    }

    @Test
    public void test_double_value2() throws Exception {
        this.check_double("2d", 2.0);
    }

    @Test
    public void test_double_positive_value() throws Exception {
        this.check_double("+3d", 3.0);
    }

    @Test
    public void test_double_negative_value() throws Exception {
        this.check_double("-3d", -3.0);
    }

    @Test
    public void test_double_plus() throws Exception {
        this.check_double("1D + 2D", 3.0);
    }

    @Test
    public void test_double_plus3() throws Exception {
        this.check_double("1D + 2D + 3D", 6.0);
    }

    @Test
    public void test_double_minus() throws Exception {
        this.check_double("5D - 1D", 4.0);
    }

    @Test
    public void test_double_mul() throws Exception {
        this.check_double("2D * 3D", 6.0);
    }

    @Test
    public void test_double_div() throws Exception {
        this.check_double("6D / 2D", 3.0);
    }

    @Test
    public void test_double_div2() throws Exception {
        this.check_double("5D / 2D", 2.5);
    }

    @Test
    public void test_double_mod() throws Exception {
        this.check_double("5D % 2D", 1.0);
    }

    @Test
    public void test_double_mod2() throws Exception {
        this.check_double("-5D % 3D", -2.0);
    }

    @Test
    public void test_double_mix_int() throws Exception {
        this.check_double("1D + 2", 3.0);
    }

    @Test
    public void test_double_mix_char() throws Exception {
        this.check_double("1D + '0'", 49.0);
    }

    @Test
    public void test_double_cast_to() throws Exception {
        this.check_double("((double)1) + 2", 3.0);
    }

    private void check_double(String expression, double expected) throws Exception {
        DoubleTest.assertEquals((Object)expected, (Object)this.evaluateExpression(expression, "double"));
    }
}

