/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.util.Lists;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.gef.EmptyEditPartViewer;
import org.eclipse.wb.tests.gef.GefTestCase;
import org.eclipse.wb.tests.gef.RequestsLogger;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.jupiter.api.Test;

public class EditPartTest
extends GefTestCase {
    @Test
    public void test_init() throws Exception {
        TestEditPart templatePart = new TestEditPart();
        IFigure templateFigure = templatePart.getFigure();
        IEditPartViewer templateViewer = templatePart.getViewer();
        EditPartTest.assertNull((Object)templatePart.getParent());
        EditPartTest.assertTrue((boolean)templatePart.getChildren().isEmpty());
        EditPartTest.assertNotNull((Object)templatePart.getFigure());
        EditPartTest.assertNull(templateViewer.getVisualPartMap().get(templateFigure));
        EditPartTest.assertNull((Object)templatePart.getFigure().getParent());
        EditPartTest.assertEquals((Object)templatePart.getFigure(), (Object)templatePart.getContentPane());
        EditPartTest.assertEquals((int)0, (int)templatePart.getSelected());
    }

    @Test
    public void test_Model() throws Exception {
        TestEditPart testEditPart = new TestEditPart();
        EditPartTest.assertNull((Object)testEditPart.getModel());
        EditPartTest.assertNotNull(testEditPart.test_access_getModelChildren());
        EditPartTest.assertTrue((boolean)testEditPart.test_access_getModelChildren().isEmpty());
        Object model = 9;
        testEditPart.setModel(model);
        EditPartTest.assertSame((Object)model, (Object)testEditPart.getModel());
        EditPartTest.assertTrue((boolean)testEditPart.test_access_getModelChildren().isEmpty());
        model = "___ZZZZZZZ_";
        testEditPart.setModel(model);
        EditPartTest.assertSame((Object)model, (Object)testEditPart.getModel());
        EditPartTest.assertTrue((boolean)testEditPart.test_access_getModelChildren().isEmpty());
    }

    @Test
    public void test_Figure() throws Exception {
        final Figure figure = new Figure();
        GraphicalEditPart testEditPart = new GraphicalEditPart(){

            protected Figure createFigure() {
                return figure;
            }
        };
        EditPartTest.assertSame((Object)figure, (Object)testEditPart.getFigure());
        EditPartTest.assertSame((Object)figure, (Object)testEditPart.getContentPane());
    }

    @Test
    public void test_addChild() throws Exception {
        TestEditPart templatePart = new TestEditPart();
        IEditPartViewer templateViewer = templatePart.getViewer();
        EditPartTest.assertTrue((boolean)templatePart.getChildren().isEmpty());
        try {
            templatePart.test_access_addChild(null, 0);
            EditPartTest.fail();
        }
        catch (RuntimeException e) {
            EditPartTest.assertEquals((Object)"null argument:", (Object)e.getMessage());
        }
        TestEditPart testPart1 = new TestEditPart(templateViewer);
        EditPartTest.assertNull((Object)testPart1.getParent());
        try {
            templatePart.test_access_addChild((EditPart)testPart1, 1);
            EditPartTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            EditPartTest.assertTrue((boolean)"Index: 1, Size: 0".equals(e.getMessage()));
        }
        EditPartTest.assertTrue((boolean)templatePart.getChildren().isEmpty());
        EditPartTest.assertNull((Object)testPart1.getParent());
        try {
            templatePart.test_access_addChild((EditPart)testPart1, -2);
            EditPartTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            EditPartTest.assertTrue((boolean)"Index: -2, Size: 0".equals(e.getMessage()));
        }
        EditPartTest.assertTrue((boolean)templatePart.getChildren().isEmpty());
        EditPartTest.assertNull((Object)testPart1.getParent());
        templatePart.test_access_addChild((EditPart)testPart1, 0);
        EditPartTest.assertSame((Object)((Object)templatePart), (Object)testPart1.getParent());
        EditPartTest.assertEquals((int)1, (int)templatePart.getChildren().size());
        EditPartTest.assertEquals(templatePart.getChildren().get(0), (Object)((Object)testPart1));
        EditPartTest.assertEquals((Object)templatePart.getFigure(), (Object)testPart1.getFigure().getParent());
        EditPartTest.assertEquals((Object)((Object)testPart1), templateViewer.getVisualPartMap().get(testPart1.getFigure()));
        EditPartTest.assertFalse((boolean)templatePart.isActive());
        EditPartTest.assertFalse((boolean)testPart1.isActive());
        templatePart.activate();
        TestEditPart testPart2 = new TestEditPart(templateViewer);
        EditPartTest.assertNull((Object)testPart2.getParent());
        templatePart.test_access_addChild((EditPart)testPart2, -1);
        EditPartTest.assertSame((Object)((Object)templatePart), (Object)testPart2.getParent());
        EditPartTest.assertEquals((int)2, (int)templatePart.getChildren().size());
        EditPartTest.assertEquals(templatePart.getChildren().get(1), (Object)((Object)testPart2));
        EditPartTest.assertEquals((Object)templatePart.getFigure(), (Object)testPart2.getFigure().getParent());
        EditPartTest.assertEquals((Object)((Object)testPart2), templateViewer.getVisualPartMap().get(testPart2.getFigure()));
        EditPartTest.assertTrue((boolean)templatePart.isActive());
        EditPartTest.assertTrue((boolean)testPart1.isActive());
    }

    @Test
    public void test_removeChild() throws Exception {
        TestEditPart templatePart = new TestEditPart();
        IEditPartViewer templateViewer = templatePart.getViewer();
        TestEditPart testPart1 = new TestEditPart();
        testPart1.activate();
        templatePart.test_access_addChild((EditPart)testPart1, -1);
        templatePart.test_access_removeChild((EditPart)testPart1);
        EditPartTest.assertTrue((boolean)templatePart.getChildren().isEmpty());
        EditPartTest.assertTrue((boolean)testPart1.isActive());
        EditPartTest.assertNull((Object)testPart1.getParent());
        EditPartTest.assertNull((Object)testPart1.getFigure().getParent());
        EditPartTest.assertNull(templateViewer.getVisualPartMap().get(testPart1.getFigure()));
        templatePart.activate();
        templatePart.test_access_addChild((EditPart)testPart1, -1);
        templatePart.test_access_removeChild((EditPart)testPart1);
        EditPartTest.assertTrue((boolean)templatePart.getChildren().isEmpty());
        EditPartTest.assertFalse((boolean)testPart1.isActive());
        EditPartTest.assertNull((Object)testPart1.getParent());
        EditPartTest.assertNull((Object)testPart1.getFigure().getParent());
        EditPartTest.assertNull(templateViewer.getVisualPartMap().get(testPart1.getFigure()));
    }

    @Test
    public void test_installEditPolicy() throws Exception {
        TestEditPart testEditPart = new TestEditPart();
        EditPartTest.assertNotNull((Object)testEditPart.getEditPolicies());
        EditPartTest.assertTrue((boolean)testEditPart.getEditPolicies().isEmpty());
        try {
            testEditPart.installEditPolicy(null, (EditPolicy)new TestEditPolicy());
            EditPartTest.fail();
        }
        catch (Throwable t) {
            EditPartTest.assertEquals((Object)"null argument:Edit Policies must be installed with keys", (Object)t.getMessage());
        }
        TestEditPolicy policy1 = new TestEditPolicy();
        EditPartTest.assertNull((Object)policy1.getHost());
        EditPartTest.assertFalse((boolean)policy1.isActive());
        testEditPart.installEditPolicy("_Policy1_", (EditPolicy)policy1);
        EditPartTest.assertEquals((int)1, (int)testEditPart.getEditPolicies().size());
        EditPartTest.assertEquals((Object)((Object)policy1), testEditPart.getEditPolicies().get(0));
        EditPartTest.assertEquals((Object)((Object)policy1), (Object)testEditPart.getEditPolicy("_Policy1_"));
        EditPartTest.assertFalse((boolean)policy1.isActive());
        EditPartTest.assertSame((Object)((Object)testEditPart), (Object)policy1.getHost());
        TestEditPolicy policy2 = new TestEditPolicy();
        EditPartTest.assertNull((Object)policy2.getHost());
        EditPartTest.assertFalse((boolean)policy2.isActive());
        testEditPart.activate();
        testEditPart.installEditPolicy("_Policy2_", (EditPolicy)policy2);
        EditPartTest.assertEquals((int)2, (int)testEditPart.getEditPolicies().size());
        EditPartTest.assertEquals((Object)((Object)policy1), testEditPart.getEditPolicies().get(0));
        EditPartTest.assertEquals((Object)((Object)policy2), testEditPart.getEditPolicies().get(1));
        EditPartTest.assertEquals((Object)((Object)policy2), (Object)testEditPart.getEditPolicy("_Policy2_"));
        EditPartTest.assertSame((Object)((Object)testEditPart), (Object)policy2.getHost());
        EditPartTest.assertTrue((boolean)policy2.isActive());
        TestEditPolicy policy2_new = new TestEditPolicy();
        EditPartTest.assertNull((Object)policy2_new.getHost());
        EditPartTest.assertFalse((boolean)policy2_new.isActive());
        testEditPart.installEditPolicy("_Policy2_", (EditPolicy)policy2_new);
        EditPartTest.assertEquals((int)2, (int)testEditPart.getEditPolicies().size());
        EditPartTest.assertEquals((Object)((Object)policy1), testEditPart.getEditPolicies().get(0));
        EditPartTest.assertEquals((Object)((Object)policy2_new), testEditPart.getEditPolicies().get(1));
        EditPartTest.assertEquals((Object)((Object)policy2_new), (Object)testEditPart.getEditPolicy("_Policy2_"));
        EditPartTest.assertSame((Object)((Object)testEditPart), (Object)policy2_new.getHost());
        EditPartTest.assertTrue((boolean)policy2_new.isActive());
        EditPartTest.assertFalse((boolean)policy2.isActive());
    }

    @Test
    public void test_RouteRequests() throws Exception {
        TestEditPart testEditPart = new TestEditPart();
        final Command dummy = new Command(){};
        final RequestsLogger actualLogger = new RequestsLogger();
        TestEditPolicy editPolicy = new TestEditPolicy(){

            public Command getCommand(Request request) {
                actualLogger.log(this.getHost(), "getCommand", request);
                return dummy;
            }

            public EditPart getTargetEditPart(Request request) {
                actualLogger.log(this.getHost(), "getTargetEditPart", request);
                return this.getHost();
            }

            public boolean understandsRequest(Request request) {
                actualLogger.log(this.getHost(), "understandsRequest", request);
                return true;
            }

            public void showSourceFeedback(Request request) {
                actualLogger.log(this.getHost(), "showSourceFeedback", request);
            }

            public void eraseSourceFeedback(Request request) {
                actualLogger.log(this.getHost(), "eraseSourceFeedback", request);
            }

            public void showTargetFeedback(Request request) {
                actualLogger.log(this.getHost(), "showTargetFeedback", request);
            }

            public void eraseTargetFeedback(Request request) {
                actualLogger.log(this.getHost(), "eraseTargetFeedback", request);
            }
        };
        Request request = new Request((Object)"move");
        EditPartTest.assertNull((Object)testEditPart.getCommand(request));
        EditPartTest.assertNull((Object)testEditPart.getTargetEditPart(request));
        testEditPart.installEditPolicy("", (EditPolicy)editPolicy);
        EditPartTest.assertSame((Object)dummy, (Object)testEditPart.getCommand(request));
        EditPartTest.assertSame((Object)((Object)testEditPart), (Object)testEditPart.getTargetEditPart(request));
        testEditPart.showSourceFeedback(request);
        testEditPart.eraseSourceFeedback(request);
        testEditPart.showTargetFeedback(request);
        testEditPart.eraseTargetFeedback(request);
        RequestsLogger expectedLogger = new RequestsLogger();
        expectedLogger.log((EditPart)testEditPart, new String[]{"understandsRequest", "getCommand", "understandsRequest", "getTargetEditPart"}, request);
        actualLogger.assertEquals(expectedLogger);
        actualLogger.clear();
        expectedLogger.clear();
        testEditPart.activate();
        EditPartTest.assertSame((Object)dummy, (Object)testEditPart.getCommand(request));
        EditPartTest.assertSame((Object)((Object)testEditPart), (Object)testEditPart.getTargetEditPart(request));
        testEditPart.showSourceFeedback(request);
        testEditPart.eraseSourceFeedback(request);
        testEditPart.showTargetFeedback(request);
        testEditPart.eraseTargetFeedback(request);
        expectedLogger.log((EditPart)testEditPart, new String[]{"understandsRequest", "getCommand", "understandsRequest", "getTargetEditPart", "understandsRequest", "showSourceFeedback", "understandsRequest", "eraseSourceFeedback", "understandsRequest", "showTargetFeedback", "understandsRequest", "eraseTargetFeedback"}, request);
        actualLogger.assertEquals(expectedLogger);
        actualLogger.clear();
        expectedLogger.clear();
    }

    @Test
    public void test_commonAdd() throws Exception {
        TestEditPart parent = new TestEditPart();
        TestEditPart child = new TestEditPart(){

            protected void createEditPolicies() {
                this.installEditPolicy("", (EditPolicy)new TestEditPolicy());
            }
        };
        EditPartTest.assertFalse((boolean)parent.isActive());
        EditPartTest.assertFalse((boolean)child.isActive());
        EditPartTest.assertNull((Object)child.getEditPolicy(""));
        parent.test_access_addChild((EditPart)child, -1);
        EditPartTest.assertFalse((boolean)child.isActive());
        EditPartTest.assertNotNull((Object)child.getEditPolicy(""));
        EditPartTest.assertFalse((boolean)((TestEditPolicy)child.getEditPolicy("")).isActive());
        EditPartTest.assertSame((Object)((Object)child), (Object)child.getEditPolicy("").getHost());
        parent.activate();
        EditPartTest.assertTrue((boolean)parent.isActive());
        EditPartTest.assertTrue((boolean)child.isActive());
        EditPartTest.assertTrue((boolean)((TestEditPolicy)child.getEditPolicy("")).isActive());
    }

    @Test
    public void test_commonAdd_activate() throws Exception {
        TestEditPart parent = new TestEditPart();
        parent.activate();
        TestEditPart child = new TestEditPart(){

            protected void createEditPolicies() {
                this.installEditPolicy("", (EditPolicy)new TestEditPolicy());
            }
        };
        EditPartTest.assertTrue((boolean)parent.isActive());
        EditPartTest.assertFalse((boolean)child.isActive());
        EditPartTest.assertNull((Object)child.getEditPolicy(""));
        parent.test_access_addChild((EditPart)child, -1);
        EditPartTest.assertTrue((boolean)child.isActive());
        EditPartTest.assertNotNull((Object)child.getEditPolicy(""));
        EditPartTest.assertTrue((boolean)((TestEditPolicy)child.getEditPolicy("")).isActive());
        EditPartTest.assertSame((Object)((Object)child), (Object)child.getEditPolicy("").getHost());
    }

    @Test
    public void test_commonRemove() throws Exception {
        TestEditPart parent = new TestEditPart();
        parent.activate();
        TestEditPart child = new TestEditPart(){

            protected void createEditPolicies() {
                this.installEditPolicy("", (EditPolicy)new TestEditPolicy());
            }
        };
        EditPartTest.assertTrue((boolean)parent.isActive());
        EditPartTest.assertFalse((boolean)child.isActive());
        EditPartTest.assertNull((Object)child.getEditPolicy(""));
        parent.test_access_addChild((EditPart)child, -1);
        EditPartTest.assertTrue((boolean)child.isActive());
        EditPartTest.assertNotNull((Object)child.getEditPolicy(""));
        EditPartTest.assertTrue((boolean)((TestEditPolicy)child.getEditPolicy("")).isActive());
        EditPartTest.assertSame((Object)((Object)child), (Object)child.getEditPolicy("").getHost());
        parent.test_access_removeChild((EditPart)child);
        EditPartTest.assertFalse((boolean)child.isActive());
        EditPartTest.assertFalse((boolean)((TestEditPolicy)child.getEditPolicy("")).isActive());
        EditPartTest.assertSame((Object)((Object)child), (Object)child.getEditPolicy("").getHost());
    }

    @Test
    public void test_refreshChildren_1() throws Exception {
        TestEditPart child1 = new TestEditPart();
        child1.setModel("_child1_Model");
        TestEditPart child2 = new TestEditPart();
        child2.setModel("_child2_Model");
        TestEditPart parent = new TestEditPart(){

            protected EditPart createChild(Object model) {
                TestEditPart child = new TestEditPart();
                child.setModel(model);
                return child;
            }

            protected List<Object> getModelChildren() {
                ArrayList<Object> modelList = new ArrayList<Object>();
                modelList.add("_child3_Model");
                modelList.add("_child1_Model");
                modelList.add("_child5_Model");
                return modelList;
            }
        };
        parent.activate();
        parent.test_access_addChild((EditPart)child1, -1);
        parent.test_access_addChild((EditPart)child2, -1);
        List children = parent.getChildren();
        EditPartTest.assertNotNull((Object)children);
        EditPartTest.assertEquals((int)2, (int)children.size());
        EditPartTest.assertSame((Object)((Object)child1), children.get(0));
        EditPartTest.assertSame((Object)((Object)child2), children.get(1));
        EditPartTest.assertSame((Object)((Object)parent), (Object)child1.getParent());
        EditPartTest.assertSame((Object)((Object)parent), (Object)child2.getParent());
        parent.refresh();
        EditPartTest.assertEquals((int)3, (int)children.size());
        EditPartTest.assertEquals((Object)"_child3_Model", (Object)((EditPart)children.get(0)).getModel());
        EditPartTest.assertSame((Object)((Object)child1), children.get(1));
        EditPartTest.assertEquals((Object)"_child5_Model", (Object)((EditPart)children.get(2)).getModel());
        EditPartTest.assertNull((Object)child2.getParent());
        EditPartTest.assertFalse((boolean)child2.isActive());
    }

    @Test
    public void test_refreshChildren_2() throws Exception {
        TestEditPart parent = new TestEditPart(){

            protected EditPart createChild(Object model) {
                if ("_child3_Model".equals(model)) {
                    return null;
                }
                TestEditPart child = new TestEditPart();
                child.setModel(model);
                return child;
            }

            protected List<?> getModelChildren() {
                ArrayList<String> modelList = new ArrayList<String>();
                modelList.add("_child2_Model");
                modelList.add("_child3_Model");
                modelList.add("_child5_Model");
                modelList.add("_child1_Model");
                modelList.add("_child7_Model");
                return modelList;
            }
        };
        parent.activate();
        parent.refresh();
        List children = parent.getChildren();
        EditPartTest.assertEquals((int)4, (int)children.size());
        EditPartTest.assertEquals((Object)"_child2_Model", (Object)((EditPart)children.get(0)).getModel());
        EditPartTest.assertEquals((Object)"_child5_Model", (Object)((EditPart)children.get(1)).getModel());
        EditPartTest.assertEquals((Object)"_child1_Model", (Object)((EditPart)children.get(2)).getModel());
        EditPartTest.assertEquals((Object)"_child7_Model", (Object)((EditPart)children.get(3)).getModel());
    }

    @Test
    public void test_refreshChildren_3() throws Exception {
        TestEditPart child1 = new TestEditPart();
        child1.setModel("_child1_Model");
        TestEditPart child2 = new TestEditPart();
        child2.setModel("_child2_Model");
        TestEditPart child4 = new TestEditPart();
        child4.setModel("_child4_Model");
        TestEditPart parent = new TestEditPart(){

            protected EditPart createChild(Object model) {
                if ("_child3_Model".equals(model)) {
                    return null;
                }
                TestEditPart child = new TestEditPart();
                child.setModel(model);
                return child;
            }

            protected List<?> getModelChildren() {
                ArrayList<String> modelList = new ArrayList<String>();
                modelList.add("_child2_Model");
                modelList.add("_child3_Model");
                modelList.add("_child5_Model");
                modelList.add("_child1_Model");
                modelList.add("_child7_Model");
                return modelList;
            }
        };
        parent.activate();
        parent.test_access_addChild((EditPart)child1, -1);
        parent.test_access_addChild((EditPart)child2, -1);
        parent.test_access_addChild((EditPart)child4, -1);
        List children = parent.getChildren();
        EditPartTest.assertNotNull((Object)children);
        EditPartTest.assertEquals((int)3, (int)children.size());
        EditPartTest.assertSame((Object)((Object)child1), children.get(0));
        EditPartTest.assertSame((Object)((Object)child2), children.get(1));
        EditPartTest.assertSame((Object)((Object)child4), children.get(2));
        EditPartTest.assertSame((Object)((Object)parent), (Object)child1.getParent());
        EditPartTest.assertSame((Object)((Object)parent), (Object)child2.getParent());
        EditPartTest.assertSame((Object)((Object)parent), (Object)child4.getParent());
        parent.refresh();
        EditPartTest.assertEquals((int)4, (int)children.size());
        EditPartTest.assertSame((Object)((Object)child2), children.get(0));
        EditPartTest.assertEquals((Object)"_child5_Model", (Object)((EditPart)children.get(1)).getModel());
        EditPartTest.assertSame((Object)((Object)child1), children.get(2));
        EditPartTest.assertEquals((Object)"_child7_Model", (Object)((EditPart)children.get(3)).getModel());
    }

    @Test
    public void test_Add_Remove_SelectionListener() throws Exception {
        TestEditPart testEditPart = new TestEditPart();
        EventListenerList eventListeners = (EventListenerList)ReflectionUtils.getFieldObject((Object)((Object)testEditPart), (String)"eventListeners");
        EditPartTest.assertFalse((boolean)eventListeners.getListeners(EditPartListener.class).hasNext());
        EditPartListener.Stub listener1 = new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart editPart) {
            }
        };
        testEditPart.addEditPartListener((EditPartListener)listener1);
        ArrayList list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)1, (int)list.size());
        EditPartTest.assertSame((Object)listener1, list.get(0));
        EditPartListener.Stub listener2 = new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart editPart) {
            }
        };
        testEditPart.addEditPartListener((EditPartListener)listener2);
        list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)2, (int)list.size());
        EditPartTest.assertSame((Object)listener1, list.get(0));
        EditPartTest.assertSame((Object)listener2, list.get(1));
        testEditPart.removeEditPartListener((EditPartListener)listener1);
        list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)1, (int)list.size());
        EditPartTest.assertSame((Object)listener2, list.get(0));
        testEditPart.removeEditPartListener((EditPartListener)listener2);
        list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void test_Selection() throws Exception {
        final TestLogger actualLogger = new TestLogger();
        EditPartListener.Stub listener = new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart editPart) {
                actualLogger.log("selectionChanged(" + String.valueOf(editPart) + ")");
            }
        };
        TestEditPart testEditPart = new TestEditPart();
        testEditPart.addEditPartListener((EditPartListener)listener);
        EditPartTest.assertTrue((boolean)testEditPart.isSelectable());
        EditPartTest.assertEquals((int)0, (int)testEditPart.getSelected());
        actualLogger.assertEmpty();
        testEditPart.setSelected(0);
        EditPartTest.assertTrue((boolean)testEditPart.isSelectable());
        EditPartTest.assertEquals((int)0, (int)testEditPart.getSelected());
        actualLogger.assertEmpty();
        testEditPart.setSelected(1);
        EditPartTest.assertTrue((boolean)testEditPart.isSelectable());
        EditPartTest.assertEquals((int)1, (int)testEditPart.getSelected());
        TestLogger expectedLogger = new TestLogger();
        expectedLogger.log("selectionChanged(" + String.valueOf((Object)testEditPart) + ")");
        actualLogger.assertEquals(expectedLogger);
        testEditPart.setSelected(2);
        EditPartTest.assertTrue((boolean)testEditPart.isSelectable());
        EditPartTest.assertEquals((int)2, (int)testEditPart.getSelected());
        expectedLogger.log("selectionChanged(" + String.valueOf((Object)testEditPart) + ")");
        actualLogger.assertEquals(expectedLogger);
        testEditPart.setSelected(2);
        EditPartTest.assertTrue((boolean)testEditPart.isSelectable());
        EditPartTest.assertEquals((int)2, (int)testEditPart.getSelected());
        actualLogger.assertEmpty();
    }

    @Test
    public void test_Add_Remove_EditPartListener() throws Exception {
        TestEditPart testEditPart = new TestEditPart();
        EventListenerList eventListeners = (EventListenerList)ReflectionUtils.getFieldObject((Object)((Object)testEditPart), (String)"eventListeners");
        EditPartTest.assertFalse((boolean)eventListeners.getListeners(EditPartListener.class).hasNext());
        EditPartListener.Stub listener1 = new EditPartListener.Stub(){

            public void removingChild(EditPart child, int index) {
            }

            public void childAdded(EditPart child, int index) {
            }
        };
        testEditPart.addEditPartListener((EditPartListener)listener1);
        ArrayList list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)1, (int)list.size());
        EditPartTest.assertSame((Object)listener1, list.get(0));
        EditPartListener.Stub listener2 = new EditPartListener.Stub(){

            public void removingChild(EditPart child, int index) {
            }

            public void childAdded(EditPart child, int index) {
            }
        };
        testEditPart.addEditPartListener((EditPartListener)listener2);
        list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)2, (int)list.size());
        EditPartTest.assertSame((Object)listener1, list.get(0));
        EditPartTest.assertSame((Object)listener2, list.get(1));
        testEditPart.removeEditPartListener((EditPartListener)listener1);
        list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)1, (int)list.size());
        EditPartTest.assertSame((Object)listener2, list.get(0));
        testEditPart.removeEditPartListener((EditPartListener)listener2);
        list = Lists.newArrayList((Iterator)eventListeners.getListeners(EditPartListener.class));
        EditPartTest.assertNotNull((Object)list);
        EditPartTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void test_Invoke_EditPartListener() throws Exception {
        final TestLogger actualLogger = new TestLogger();
        EditPartListener.Stub listener = new EditPartListener.Stub(){

            public void childAdded(EditPart child, int index) {
                actualLogger.log("childAdded(" + String.valueOf(child) + ", " + index + ")");
            }

            public void removingChild(EditPart child, int index) {
                actualLogger.log("removingChild(" + String.valueOf(child) + ", " + index + ")");
            }
        };
        TestEditPart parent = new TestEditPart();
        parent.addEditPartListener((EditPartListener)listener);
        actualLogger.assertEmpty();
        TestEditPart child = new TestEditPart();
        parent.test_access_addChild((EditPart)child, -1);
        TestLogger expectedLogger = new TestLogger();
        expectedLogger.log("childAdded(" + String.valueOf((Object)child) + ", 0)");
        actualLogger.assertEquals(expectedLogger);
        TestEditPart child2 = new TestEditPart();
        parent.test_access_addChild((EditPart)child2, -1);
        expectedLogger.log("childAdded(" + String.valueOf((Object)child2) + ", 1)");
        actualLogger.assertEquals(expectedLogger);
        parent.test_access_removeChild((EditPart)child2);
        expectedLogger.log("removingChild(" + String.valueOf((Object)child2) + ", 1)");
        actualLogger.assertEquals(expectedLogger);
        parent.test_access_removeChild((EditPart)child);
        expectedLogger.log("removingChild(" + String.valueOf((Object)child) + ", 0)");
        actualLogger.assertEquals(expectedLogger);
    }

    private static class TestEditPart
    extends GraphicalEditPart {
        private final IEditPartViewer m_viewer;

        private TestEditPart() {
            this(new EmptyEditPartViewer());
        }

        private TestEditPart(IEditPartViewer viewer) {
            this.m_viewer = viewer;
        }

        @Test
        public void test_access_addChild(EditPart childPart, int index) {
            this.addChild(childPart, index);
        }

        @Test
        public void test_access_removeChild(EditPart childPart) {
            this.removeChild(childPart);
        }

        public List<?> test_access_getModelChildren() {
            return super.getModelChildren();
        }

        protected Figure createFigure() {
            return new Figure();
        }

        public IEditPartViewer getViewer() {
            return this.m_viewer;
        }
    }

    private static class TestEditPolicy
    extends org.eclipse.wb.gef.core.policies.EditPolicy {
        private boolean m_isActive;

        private TestEditPolicy() {
        }

        public void activate() {
            super.activate();
            this.m_isActive = true;
        }

        public void deactivate() {
            this.m_isActive = false;
            super.deactivate();
        }

        public boolean isActive() {
            return this.m_isActive;
        }
    }
}

