/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.property.TabOrderProperty;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;

public class TabOrderPropertyTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject != null) {
            ProjectUtils.ensureResourceType((IJavaProject)m_testProject.getJavaProject(), (Bundle)Activator.getDefault().getBundle(), (String)"org.eclipse.wb.swing.FocusTraversalOnArray");
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_common() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        TabOrderProperty property = (TabOrderProperty)panel.getPropertyByTitle("tab order");
        TabOrderPropertyTest.assertNotNull((Object)property);
        TabOrderPropertyTest.assertFalse((boolean)property.isModified());
        TabOrderPropertyTest.assertNull((Object)property.getAdapter(Object.class));
        PropertyTooltipProvider tooltipProvider = (PropertyTooltipProvider)property.getAdapter(PropertyTooltipProvider.class);
        TabOrderPropertyTest.assertInstanceOf(PropertyTooltipTextProvider.class, (Object)tooltipProvider);
        TabOrderPropertyTest.assertNotNull((Object)ReflectionUtils.invokeMethod((Object)tooltipProvider, (String)"getText(org.eclipse.wb.internal.core.model.property.Property)", (Object[])new Object[]{property}));
    }

    @Test
    public void test_getValue_noValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('Button');", "    add(button);", "    JPanel panel = new JPanel();", "    add(panel);", "    JLabel label = new JLabel('Label');", "    panel.add(label);", "  }", "}");
        panel.refresh();
        TabOrderProperty property = (TabOrderProperty)panel.getPropertyByTitle("tab order");
        TabOrderInfo info = (TabOrderInfo)property.getValue();
        List components = panel.getChildrenComponents();
        ComponentInfo button = (ComponentInfo)components.get(0);
        ContainerInfo subPanel = (ContainerInfo)components.get(1);
        ComponentInfo label = (ComponentInfo)subPanel.getChildrenComponents().get(0);
        TabOrderPropertyTest.assertEquals((int)3, (int)info.getInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)subPanel, info.getInfos().get(1));
        TabOrderPropertyTest.assertSame((Object)label, info.getInfos().get(2));
        TabOrderPropertyTest.assertEquals((int)3, (int)info.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getOrderedInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)subPanel, info.getOrderedInfos().get(1));
        TabOrderPropertyTest.assertSame((Object)label, info.getOrderedInfos().get(2));
    }

    @Test
    public void test_getValue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "    setFocusTraversalPolicy(new org.eclipse.wb.swing.FocusTraversalOnArray(new Component[]{button}));", "  }", "}");
        panel.refresh();
        TabOrderProperty property = (TabOrderProperty)panel.getPropertyByTitle("tab order");
        TabOrderPropertyTest.assertTrue((boolean)property.isModified());
        TabOrderInfo info = (TabOrderInfo)property.getValue();
        List components = panel.getChildrenComponents();
        ComponentInfo button = (ComponentInfo)components.get(0);
        ComponentInfo combo = (ComponentInfo)components.get(1);
        TabOrderPropertyTest.assertEquals((int)2, (int)info.getInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getInfos().get(1));
        TabOrderPropertyTest.assertEquals((int)1, (int)info.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getOrderedInfos().get(0));
    }

    @Test
    public void test_setValue_UNKNOWN_VALUE() throws Exception {
        this.test_setValue(new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "    setFocusTraversalPolicy(new org.eclipse.wb.swing.FocusTraversalOnArray(new Component[]{button}));", "  }", "}"}, Property.UNKNOWN_VALUE, new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "  }", "}"});
    }

    @Test
    public void test_setValue_noValue() throws Exception {
        this.test_setValue(new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "    setFocusTraversalPolicy(new org.eclipse.wb.swing.FocusTraversalOnArray(new Component[]{button}));", "  }", "}"}, new TabOrderInfo(), new String[]{"public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('Button');", "    add(button);", "    JComboBox combo = new JComboBox();", "    add(combo);", "  }", "}"});
    }

    private void test_setValue(String[] startSource, Object value, String[] newSource) throws Exception {
        ContainerInfo container = this.parseContainer(startSource);
        container.refresh();
        TabOrderProperty property = (TabOrderProperty)container.getPropertyByTitle("tab order");
        property.setValue(value);
        this.assertEditor(newSource);
    }

    @Test
    public void test_setValue_noExisting() throws Exception {
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    {", "      button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        container.refresh();
        ComponentInfo button_1 = (ComponentInfo)TabOrderPropertyTest.getJavaInfoByName("button_1");
        TabOrderProperty property = (TabOrderProperty)container.getPropertyByTitle("tab order");
        TabOrderInfo newValue = new TabOrderInfo();
        newValue.addOrderedInfo((AbstractComponentInfo)button_1);
        property.setValue((Object)newValue);
        this.assertEditor("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    {", "      button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      add(button_2);", "    }", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button_1}));", "  }", "}");
    }

    @Test
    public void test_setValue_hasExisting() throws Exception {
        ContainerInfo container = this.parseContainer("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    {", "      button_1 = new JButton();", "      add(button_1);", "    }", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button_1}));", "    {", "      button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        container.refresh();
        ComponentInfo button_1 = (ComponentInfo)TabOrderPropertyTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)TabOrderPropertyTest.getJavaInfoByName("button_2");
        TabOrderProperty property = (TabOrderProperty)container.getPropertyByTitle("tab order");
        TabOrderInfo newValue = new TabOrderInfo();
        newValue.addOrderedInfo((AbstractComponentInfo)button_1);
        newValue.addOrderedInfo((AbstractComponentInfo)button_2);
        property.setValue((Object)newValue);
        this.assertEditor("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    {", "      button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      add(button_2);", "    }", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button_1, button_2}));", "  }", "}");
    }

    @Test
    public void test_noValue_addNewComponent() throws Exception {
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
        container.refresh();
        ComponentInfo newButton = TabOrderPropertyTest.createJButton();
        ((FlowLayoutInfo)container.getLayout()).add(newButton, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_hasValue_addNewComponent() throws Exception {
        ContainerInfo container = this.parseContainer("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    {", "      button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      add(button_2);", "    }", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button_1}));", "  }", "}");
        container.refresh();
        ComponentInfo newButton = TabOrderPropertyTest.createJButton();
        ((FlowLayoutInfo)container.getLayout()).add(newButton, null);
        this.assertEditor("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  private JButton button;", "  public Test() {", "    {", "      button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      button = new JButton();", "      add(button);", "    }", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button_1, button}));", "  }", "}");
    }

    @Test
    public void test_delete_JPanel() throws Exception {
        ContainerInfo panel = this.parseContainer("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button;", "  private JComboBox combo;", "  public Test() {", "    setLayout(new FlowLayout());", "    button = new JButton('Button');", "    add(button);", "    combo = new JComboBox();", "    add(combo);", "    JTextField text = new JTextField();", "    add(text);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button, combo}));", "  }", "}");
        panel.refresh();
        this.test_delete(panel, new String[]{"import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button;", "  private JComboBox combo;", "  public Test() {", "    setLayout(new FlowLayout());", "    button = new JButton('Button');", "    add(button);", "    combo = new JComboBox();", "    add(combo);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button, combo}));", "  }", "}"}, new String[]{"import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    setLayout(new FlowLayout());", "    button = new JButton('Button');", "    add(button);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button}));", "  }", "}"}, new String[]{"import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new FlowLayout());", "  }", "}"}, panel.getChildrenComponents());
    }

    @Test
    public void test_delete_JFrame() throws Exception {
        ContainerInfo frame = this.parseContainer("import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JFrame {", "  private JPanel m_contentPane;", "  private JButton button;", "  private JComboBox combo;", "  public Test() {", "    m_contentPane = new JPanel();", "    m_contentPane.setLayout(new FlowLayout());", "    setContentPane(m_contentPane);", "    button = new JButton('Button');", "    m_contentPane.add(button);", "    combo = new JComboBox();", "    m_contentPane.add(combo);", "    JTextField text = new JTextField();", "    m_contentPane.add(text);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button, combo}));", "  }", "}");
        frame.refresh();
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        this.test_delete(frame, new String[]{"import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JFrame {", "  private JPanel m_contentPane;", "  private JButton button;", "  private JComboBox combo;", "  public Test() {", "    m_contentPane = new JPanel();", "    m_contentPane.setLayout(new FlowLayout());", "    setContentPane(m_contentPane);", "    button = new JButton('Button');", "    m_contentPane.add(button);", "    combo = new JComboBox();", "    m_contentPane.add(combo);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button, combo}));", "  }", "}"}, new String[]{"import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JFrame {", "  private JPanel m_contentPane;", "  private JButton button;", "  public Test() {", "    m_contentPane = new JPanel();", "    m_contentPane.setLayout(new FlowLayout());", "    setContentPane(m_contentPane);", "    button = new JButton('Button');", "    m_contentPane.add(button);", "    setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{button}));", "  }", "}"}, new String[]{"import org.eclipse.wb.swing.FocusTraversalOnArray;", "public class Test extends JFrame {", "  private JPanel m_contentPane;", "  public Test() {", "    m_contentPane = new JPanel();", "    m_contentPane.setLayout(new FlowLayout());", "    setContentPane(m_contentPane);", "  }", "}"}, contentPane.getChildrenComponents());
    }

    private void test_delete(ContainerInfo container, String[] start, String[] middle, String[] end, List<ComponentInfo> components) throws Exception {
        TabOrderProperty property = (TabOrderProperty)container.getPropertyByTitle("tab order");
        TabOrderInfo info = (TabOrderInfo)property.getValue();
        ComponentInfo button = components.get(0);
        ComponentInfo combo = components.get(1);
        ComponentInfo text = components.get(2);
        TabOrderPropertyTest.assertEquals((int)2, (int)info.getOrderedInfos().size());
        TabOrderPropertyTest.assertSame((Object)button, info.getOrderedInfos().get(0));
        TabOrderPropertyTest.assertSame((Object)combo, info.getOrderedInfos().get(1));
        text.delete();
        this.assertEditor(start);
        combo.delete();
        this.assertEditor(middle);
        button.delete();
        this.assertEditor(end);
    }
}

