/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.wb.internal.rcp.model.widgets.CoolBarInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.jupiter.api.Test;

public class CoolBarGefTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_CREATE_item() throws Exception {
        CoolBarInfo coolBar = (CoolBarInfo)this.openJavaInfo("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.CoolItem");
        this.canvas.moveTo((Object)coolBar, 5, 5);
        this.canvas.click();
        this.assertEditor("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem coolItem = new CoolItem(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_control_good() throws Exception {
        this.openJavaInfo("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem item = new CoolItem(this, SWT.NONE);", "    }", "  }", "}");
        Object item = CoolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.canvas.moveTo(item, 5, 5);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(item));
        this.canvas.assertCommandNotNull();
        this.canvas.click();
        this.assertEditor("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem item = new CoolItem(this, SWT.NONE);", "      {", "        Button button = new Button(this, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_CREATE_control_alreadyHasControl() throws Exception {
        this.openJavaInfo("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem item = new CoolItem(this, SWT.NONE);", "      {", "        Button existing = new Button(this, SWT.NONE);", "        item.setControl(existing);", "      }", "    }", "  }", "}");
        Object item = CoolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.canvas.moveTo(item, 5, 5);
        this.canvas.assertFeedbacks(this.canvas.getTargetPredicate(item));
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_tree_CREATE_item() throws Exception {
        CoolBarInfo coolBar = (CoolBarInfo)this.openJavaInfo("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadCreationTool("org.eclipse.swt.widgets.CoolItem");
        this.tree.moveOn(coolBar);
        this.tree.click();
        this.assertEditor("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem coolItem = new CoolItem(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE_control_good() throws Exception {
        this.openJavaInfo("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem item = new CoolItem(this, SWT.NONE);", "    }", "  }", "}");
        Object item = CoolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.tree.moveOn(item);
        this.tree.assertFeedback_on(item);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem item = new CoolItem(this, SWT.NONE);", "      {", "        Button button = new Button(this, SWT.NONE);", "        item.setControl(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE_control_alreadyHasControl() throws Exception {
        this.openJavaInfo("public class Test extends CoolBar {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      CoolItem item = new CoolItem(this, SWT.NONE);", "      {", "        Button existing = new Button(this, SWT.NONE);", "        item.setControl(existing);", "      }", "    }", "  }", "}");
        Object item = CoolBarGefTest.getJavaInfoByName("item");
        this.loadButton();
        this.tree.moveOn(item);
        this.tree.assertFeedback_on(item);
        this.tree.assertCommandNull();
    }
}

