/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.reflect;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class ReflectionUtilsTest
extends DesignerTestCase {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getClassLoader() throws Exception {
        Class<Object> clazz = ((Object)((Object)this)).getClass();
        ReflectionUtilsTest.assertSame((Object)clazz.getClassLoader(), (Object)ReflectionUtils.getClassLoader(clazz));
        clazz = String.class;
        ReflectionUtilsTest.assertNull((Object)clazz.getClassLoader());
        ReflectionUtilsTest.assertSame((Object)ClassLoader.getSystemClassLoader(), (Object)ReflectionUtils.getClassLoader(clazz));
    }

    @Test
    public void test_getFullyQualifiedName_primitive_void() throws Exception {
        this.check_getFullyQualifiedName("void", "void", Void.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_boolean() throws Exception {
        this.check_getFullyQualifiedName("boolean", "boolean", Boolean.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_byte() throws Exception {
        this.check_getFullyQualifiedName("byte", "byte", Byte.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_char() throws Exception {
        this.check_getFullyQualifiedName("char", "char", Character.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_short() throws Exception {
        this.check_getFullyQualifiedName("short", "short", Short.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_int() throws Exception {
        this.check_getFullyQualifiedName("int", "int", Integer.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_long() throws Exception {
        this.check_getFullyQualifiedName("long", "long", Long.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_float() throws Exception {
        this.check_getFullyQualifiedName("float", "float", Float.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_primitive_double() throws Exception {
        this.check_getFullyQualifiedName("double", "double", Double.TYPE);
    }

    @Test
    public void test_getFullyQualifiedName_String() throws Exception {
        this.check_getFullyQualifiedName("java.lang.String", "java.lang.String", (Type)((Object)String.class));
    }

    @Test
    public void test_getFullyQualifiedName_inner() throws Exception {
        this.check_getFullyQualifiedName("java.util.Map.Entry", "java.util.Map$Entry", (Type)((Object)Map.Entry.class));
    }

    @Test
    public void test_getFullyQualifiedName_array_primitive() throws Exception {
        this.check_getFullyQualifiedName("int[]", "int[]", (Type)((Object)int[].class));
    }

    @Test
    public void test_getFullyQualifiedName_array_primitive2() throws Exception {
        this.check_getFullyQualifiedName("int[][]", "int[][]", (Type)((Object)int[][].class));
    }

    @Test
    public void test_getFullyQualifiedName_array_String() throws Exception {
        this.check_getFullyQualifiedName("java.lang.String[]", "java.lang.String[]", (Type)((Object)String[].class));
    }

    @Test
    public void test_getFullyQualifiedName_array_String2() throws Exception {
        this.check_getFullyQualifiedName("java.lang.String[][]", "java.lang.String[][]", (Type)((Object)String[][].class));
    }

    @Test
    public void test_getFullyQualifiedName_TypeVariable() throws Exception {
        class Foo {
            Foo() {
            }

            <T> void foo(T values) {
            }
        }
        Method method = Foo.class.getDeclaredMethods()[0];
        String expected = "T";
        this.check_getFullyQualifiedName(expected, expected, method.getGenericParameterTypes()[0]);
    }

    @Test
    public void test_getFullyQualifiedName_GenericArrayType() throws Exception {
        class Foo {
            Foo() {
            }

            <T> void foo(T[] values) {
            }
        }
        Method method = Foo.class.getDeclaredMethods()[0];
        String expected = "T[]";
        this.check_getFullyQualifiedName(expected, expected, method.getGenericParameterTypes()[0]);
    }

    @Test
    public void test_getFullyQualifiedName_ParameterizedType() throws Exception {
        class Foo {
            Foo() {
            }

            <K, V> void foo(Map<K, V> values) {
            }
        }
        Method method = Foo.class.getDeclaredMethods()[0];
        String expected = "java.util.Map<K,V>";
        this.check_getFullyQualifiedName(expected, expected, method.getGenericParameterTypes()[0]);
    }

    @Test
    public void test_getFullyQualifiedName_WildcardType() throws Exception {
        class Foo {
            Foo() {
            }

            <T> void foo(List<? extends T> values) {
            }
        }
        Method method = Foo.class.getDeclaredMethods()[0];
        String expected = "java.util.List<? extends T>";
        this.check_getFullyQualifiedName(expected, expected, method.getGenericParameterTypes()[0]);
    }

    private void check_getFullyQualifiedName(String expectedSource, String expectedRuntime, Type clazz) throws Exception {
        ReflectionUtilsTest.assertEquals((Object)expectedSource, (Object)ReflectionUtils.getFullyQualifiedName((Type)clazz, (boolean)false));
        ReflectionUtilsTest.assertEquals((Object)expectedRuntime, (Object)ReflectionUtils.getFullyQualifiedName((Type)clazz, (boolean)true));
    }

    @Test
    public void test_getCanonicalName() throws Exception {
        ReflectionUtilsTest.assertEquals((Object)"java.lang.String", (Object)ReflectionUtils.getCanonicalName(String.class));
        ReflectionUtilsTest.assertEquals((Object)"java.util.Map.Entry", (Object)ReflectionUtils.getCanonicalName(Map.Entry.class));
        ReflectionUtilsTest.assertEquals((Object)"java.lang.String[]", (Object)ReflectionUtils.getCanonicalName(String[].class));
    }

    @Test
    public void test_getShortName() throws Exception {
        ReflectionUtilsTest.assertEquals((Object)"int", (Object)ReflectionUtils.getShortName(Integer.TYPE));
        ReflectionUtilsTest.assertEquals((Object)"String", (Object)ReflectionUtils.getShortName(String.class));
        ReflectionUtilsTest.assertEquals((Object)"String[]", (Object)ReflectionUtils.getShortName(String[].class));
        ReflectionUtilsTest.assertEquals((Object)"Map.Entry", (Object)ReflectionUtils.getShortName(Map.Entry.class));
    }

    @Test
    public void test_isX_Constructor() throws Exception {
        Constructor<?> constructor;
        class Foo {
            public Foo() {
            }

            protected Foo(int v) {
            }

            private Foo(boolean v) {
            }

            Foo(long v) {
            }
        }
        Constructor<?>[] declaredConstructors = Foo.class.getDeclaredConstructors();
        boolean seenPublic = false;
        Constructor<?>[] constructorArray = declaredConstructors;
        int n = declaredConstructors.length;
        int n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            if (ReflectionUtils.isPublic(constructor)) {
                seenPublic = true;
                ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPublic(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate(constructor));
            }
            ++n2;
        }
        ReflectionUtilsTest.assertTrue((boolean)seenPublic);
        boolean seenProtected = false;
        constructorArray = declaredConstructors;
        n = declaredConstructors.length;
        n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            if (ReflectionUtils.isProtected(constructor)) {
                seenProtected = true;
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic(constructor));
                ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isProtected(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate(constructor));
            }
            ++n2;
        }
        ReflectionUtilsTest.assertTrue((boolean)seenProtected);
        boolean seenPrivate = false;
        constructorArray = declaredConstructors;
        n = declaredConstructors.length;
        n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            if (ReflectionUtils.isPrivate(constructor)) {
                seenPrivate = true;
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected(constructor));
                ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPrivate(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate(constructor));
            }
            ++n2;
        }
        ReflectionUtilsTest.assertTrue((boolean)seenPrivate);
        boolean seenPackagePrivate = false;
        constructorArray = declaredConstructors;
        n = declaredConstructors.length;
        n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            if (ReflectionUtils.isPackagePrivate(constructor)) {
                seenPackagePrivate = true;
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected(constructor));
                ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate(constructor));
                ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPackagePrivate(constructor));
            }
            ++n2;
        }
        ReflectionUtilsTest.assertTrue((boolean)seenPackagePrivate);
    }

    @Test
    public void test_isX_Method() throws Exception {
        abstract class Foo {
            Foo() {
            }

            public void a() {
            }

            protected void b() {
            }

            private void c() {
            }

            void d() {
            }

            abstract void e();
        }
        Method method = ReflectionUtils.getMethodBySignature(Foo.class, (String)"a()");
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPublic((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate((Method)method));
        method = ReflectionUtils.getMethodBySignature(Foo.class, (String)"b()");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic((Method)method));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isProtected((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate((Method)method));
        method = ReflectionUtils.getMethodBySignature(Foo.class, (String)"c()");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected((Method)method));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPrivate((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate((Method)method));
        method = ReflectionUtils.getMethodBySignature(Foo.class, (String)"d()");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected((Method)method));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate((Method)method));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPackagePrivate((Method)method));
        method = ReflectionUtils.getMethodBySignature(Foo.class, (String)"a()");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAbstract((Method)method));
        method = ReflectionUtils.getMethodBySignature(Foo.class, (String)"e()");
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAbstract((Method)method));
    }

    @Test
    public void test_isX_Field() throws Exception {
        class Foo {
            public int a;
            protected int b;
            private int c;
            int d;

            Foo() {
            }
        }
        Field field = ReflectionUtils.getFieldByName(Foo.class, (String)"a");
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPublic((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate((Field)field));
        field = ReflectionUtils.getFieldByName(Foo.class, (String)"b");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic((Field)field));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isProtected((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate((Field)field));
        field = ReflectionUtils.getFieldByName(Foo.class, (String)"c");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected((Field)field));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPrivate((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate((Field)field));
        field = ReflectionUtils.getFieldByName(Foo.class, (String)"d");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected((Field)field));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate((Field)field));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPackagePrivate((Field)field));
    }

    @Test
    public void test_isX_Class() throws Exception {
        Class clazz = Class_public.class;
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPublic(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate(clazz));
        clazz = Class_protected.class;
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic(clazz));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isProtected(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate(clazz));
        clazz = Class_private.class;
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected(clazz));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPrivate(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPackagePrivate(clazz));
        clazz = Class_packagePrivate.class;
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPublic(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isProtected(clazz));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isPrivate(clazz));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isPackagePrivate(clazz));
    }

    @Test
    public void test_isAbstract_Class() throws Exception {
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAbstract(Object.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAbstract(JComponent.class));
    }

    @Test
    public void test_isStatic_Field() throws Exception {
        Field field = ReflectionUtils.getFieldByName(Integer.class, (String)"MIN_VALUE");
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isStatic((Field)field));
        field = ReflectionUtils.getFieldByName(Dimension.class, (String)"width");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isStatic((Field)field));
    }

    @Test
    public void test_getMethods() throws Exception {
        class Bar
        extends Foo {
            Bar() {
                class Foo {
                    Foo() {
                    }

                    public void a() {
                    }

                    protected void b() {
                    }

                    private void c() {
                    }

                    void d() {
                    }
                }
            }

            public void e() {
            }
        }
        Map methods = ReflectionUtils.getMethods(Bar.class);
        Assertions.assertThat(methods.values()).contains((Object[])new Method[]{Foo.class.getDeclaredMethod("a", new Class[0]), Foo.class.getDeclaredMethod("b", new Class[0]), Foo.class.getDeclaredMethod("c", new Class[0]), Foo.class.getDeclaredMethod("d", new Class[0]), Bar.class.getDeclaredMethod("e", new Class[0])});
    }

    @Test
    public void test_getMethods_forInterface() throws Exception {
        abstract class Foo
        implements Collection<Object> {
            Foo() {
            }
        }
        Map methods = ReflectionUtils.getMethods(Foo.class);
        Assertions.assertThat(methods.values()).contains((Object[])new Method[]{Collection.class.getDeclaredMethod("size", new Class[0])});
    }

    @Test
    public void test_getMethodByName_public() throws Exception {
        class Foo {
            Foo() {
            }

            public void a() {
            }
        }
        ReflectionUtilsTest.assertSame(null, (Object)ReflectionUtils.getMethodByName(Foo.class, (String)"noSuchMethod"));
        Method actual = ReflectionUtils.getMethodByName(Foo.class, (String)"a");
        ReflectionUtilsTest.assertNotNull((Object)actual);
        ReflectionUtilsTest.assertEquals((Object)"a()", (Object)ReflectionUtils.getMethodSignature((Method)actual));
    }

    @Test
    public void test_getMethodByName_private() throws Exception {
        class Foo {
            Foo() {
            }

            private void a() {
            }
        }
        Method actual = ReflectionUtils.getMethodByName(Foo.class, (String)"a");
        ReflectionUtilsTest.assertNotNull((Object)actual);
        ReflectionUtilsTest.assertEquals((Object)"a()", (Object)ReflectionUtils.getMethodSignature((Method)actual));
    }

    @Test
    public void test_getMethodByName_useOneOfThem() throws Exception {
        class Foo {
            Foo() {
            }

            private void a(boolean value) {
            }

            private void a(int value) {
            }
        }
        Method actual = ReflectionUtils.getMethodByName(Foo.class, (String)"a");
        ReflectionUtilsTest.assertNotNull((Object)actual);
        ReflectionUtilsTest.assertEquals((Object)"a", (Object)actual.getName());
    }

    @Test
    public void test_getMethodBySignature_public() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethodBySignature(Object.class, (String)"hashCode()"));
    }

    @Test
    public void test_getMethodBySignature_notFound() throws Exception {
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getMethodBySignature(Object.class, (String)"hashCode2()"));
    }

    @Test
    public void test_getMethodBySignature_private_direct() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethodBySignature(Mock.class, (String)"foo2(int)"));
    }

    @Test
    public void test_getMethodBySignature_private_super() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethodBySignature(Mock.class, (String)"foo(int)"));
    }

    @Test
    public void test_getMethodBySignature_private_super2() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethodBySignature(Mock.class, (String)"foo1(int)"));
    }

    @Test
    public void test_getMethodBySignature_superInterface() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethodBySignature(MyCollection.class, (String)"size()"));
    }

    @Test
    public void test_getMethodByGenericSignature_notFound() throws Exception {
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getMethodByGenericSignature(Arrays.class, (String)"noSuchMethod()"));
    }

    @Test
    public void test_getMethodByGenericSignature_array() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethodByGenericSignature(Arrays.class, (String)"asList(T[])"));
    }

    @Test
    public void test_getMethod_public() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethod(Object.class, (String)"hashCode", (Class[])new Class[0]));
    }

    @Test
    public void test_getMethod_private_direct() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getMethod(Mock.class, (String)"foo2", (Class[])new Class[]{Integer.TYPE}));
    }

    @Test
    public void test_isMoreSpecific_Class() throws Exception {
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isMoreSpecific(List.class, ArrayList.class));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMoreSpecific(ArrayList.class, List.class));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMoreSpecific(List.class, String.class));
    }

    @Test
    public void test_isMoreSpecific_ClassArray() throws Exception {
        Class[] base = new Class[]{List.class};
        Class[] specific = new Class[]{ArrayList.class};
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isMoreSpecific((Class[])base, (Class[])specific));
        base = new Class[]{ArrayList.class};
        specific = new Class[]{List.class};
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMoreSpecific((Class[])base, (Class[])specific));
        base = new Class[]{List.class, Object.class};
        specific = new Class[]{ArrayList.class, String.class};
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isMoreSpecific((Class[])base, (Class[])specific));
        base = new Class[]{List.class, Object.class};
        specific = new Class[]{ArrayList.class};
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMoreSpecific((Class[])base, (Class[])specific));
        base = new Class[]{List.class, Object.class};
        specific = new Class[]{ArrayList.class, Object.class};
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isMoreSpecific((Class[])base, (Class[])specific));
        base = new Class[]{List.class, String.class};
        specific = new Class[]{ArrayList.class, Object.class};
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMoreSpecific((Class[])base, (Class[])specific));
    }

    @Test
    public void test_isMoreSpecific() throws Exception {
        class A {
            A() {
            }

            void foo() {
            }

            void foo(Object a) {
            }

            void foo(String a) {
            }

            void bar(String a) {
            }
        }
        Method base = ReflectionUtils.getMethodBySignature(A.class, (String)"foo()");
        Method specific = ReflectionUtils.getMethodBySignature(A.class, (String)"foo(java.lang.String)");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMoreSpecific((Method)base, (Method)specific));
        base = ReflectionUtils.getMethodBySignature(A.class, (String)"foo(java.lang.Object)");
        specific = ReflectionUtils.getMethodBySignature(A.class, (String)"foo(java.lang.String)");
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isMoreSpecific((Method)base, (Method)specific));
        base = ReflectionUtils.getMethodBySignature(A.class, (String)"foo(java.lang.Object)");
        specific = ReflectionUtils.getMethodBySignature(A.class, (String)"bar(java.lang.String)");
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMoreSpecific((Method)base, (Method)specific));
    }

    @Test
    public void test_getMostSpecific() throws Exception {
        class A {
            A() {
            }

            void foo(Object a) {
            }

            void foo(String a) {
            }

            void bar(String a) {
            }
        }
        Method base = ReflectionUtils.getMethodBySignature(A.class, (String)"foo(java.lang.Object)");
        Method specific = ReflectionUtils.getMethodBySignature(A.class, (String)"foo(java.lang.String)");
        Method bar = ReflectionUtils.getMethodBySignature(A.class, (String)"bar(java.lang.String)");
        ReflectionUtilsTest.assertSame((Object)specific, (Object)ReflectionUtils.getMostSpecific(List.of(base, specific, bar)));
        ReflectionUtilsTest.assertSame(null, (Object)ReflectionUtils.getMostSpecific(Collections.emptyList()));
    }

    @Test
    public void test_isAlreadyDeclaredIn() throws Exception {
        class Bar
        extends Foo {
            Bar() {
                class Foo {
                    Foo() {
                    }
                }
            }

            public void m() {
            }
        }
        Method method = ReflectionUtils.getMethodBySignature(Bar.class, (String)"m()");
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAlreadyDeclaredIn((Method)method, Bar.class));
        class Baz
        extends Bar {
            Baz() {
            }
        }
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAlreadyDeclaredIn((Method)method, Baz.class));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAlreadyDeclaredIn((Method)method, Foo.class));
    }

    @Test
    public void test_getNormalClass() throws Exception {
        ReflectionUtilsTest.assertSame(ArrayList.class, (Object)ReflectionUtils.getNormalClass(ArrayList.class));
        Class clazz = new ByteBuddy().subclass(ArrayList.class).make().load(((Object)((Object)this)).getClass().getClassLoader()).getLoaded();
        Assertions.assertThat((String)clazz.getName()).contains(new CharSequence[]{"$"});
        ReflectionUtilsTest.assertSame(ArrayList.class, (Object)ReflectionUtils.getNormalClass((Class)clazz));
    }

    @Test
    public void test_toString_forMethod() throws Exception {
        Method method = ReflectionUtils.getMethodBySignature(ArrayList.class, (String)"size()");
        ReflectionUtilsTest.assertEquals((Object)"public int java.util.ArrayList.size()", (Object)ReflectionUtils.toString((Method)method));
        Class clazz = new ByteBuddy().subclass(ArrayList.class).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)SuperMethodCall.INSTANCE).defineMethod("__foo__", Void.class, new ModifierContributor.ForMethod[0]).intercept(FixedValue.nullValue()).make().load(((Object)((Object)this)).getClass().getClassLoader()).getLoaded();
        Method method2 = ReflectionUtils.getMethodBySignature((Class)clazz, (String)"size()");
        Assertions.assertThat((String)method2.toString()).contains(new CharSequence[]{"$"});
        ReflectionUtilsTest.assertEquals((Object)"public int java.util.ArrayList.size()", (Object)ReflectionUtils.toString((Method)method2));
        method2 = ReflectionUtils.getMethodBySignature((Class)clazz, (String)"__foo__()");
        String usualToString = method2.toString();
        Assertions.assertThat((String)usualToString).contains(new CharSequence[]{"$"});
        ReflectionUtilsTest.assertEquals((Object)usualToString, (Object)ReflectionUtils.toString((Method)method2));
    }

    @Test
    public void test_getShortConstructorString() throws Exception {
        Constructor constructor = null;
        ReflectionUtilsTest.assertEquals((Object)"<null-constructor>", (Object)ReflectionUtils.getShortConstructorString(constructor));
        constructor = ReflectionUtils.getConstructorBySignature(ArrayList.class, (String)"<init>(int)");
        ReflectionUtilsTest.assertEquals((Object)"ArrayList(int)", (Object)ReflectionUtils.getShortConstructorString((Constructor)constructor));
        constructor = ReflectionUtils.getConstructorBySignature(String.class, (String)"<init>(byte[],java.lang.String)");
        ReflectionUtilsTest.assertEquals((Object)"String(byte[],String)", (Object)ReflectionUtils.getShortConstructorString((Constructor)constructor));
    }

    @Test
    public void test_invokeMethod2() throws Exception {
        Object myObject = new Object(){
            {
                this.method_0();
                this.method_1(0);
                this.method_2(0, 1);
                this.method_3(0, 1, 2);
                this.method_4(0, 1, 2, 3);
            }

            public int method_0() {
                return 0;
            }

            public int method_1(int a) {
                return 1;
            }

            public int method_2(int a, int b) {
                return 2;
            }

            public int method_3(int a, int b, int c) {
                return 3;
            }

            public int method_4(int a, int b, int c, int d) {
                return 4;
            }
        };
        Class[] types = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] values = new Object[]{0, 0};
        ReflectionUtilsTest.assertEquals((Object)2, (Object)ReflectionUtils.invokeMethod2((Object)myObject, (String)"method_2", (Class[])types, (Object[])values));
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod2((Object)myObject, (String)"method_0"));
        ReflectionUtilsTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod2((Object)myObject, (String)"method_1", Integer.TYPE, (Object)0));
        ReflectionUtilsTest.assertEquals((Object)2, (Object)ReflectionUtils.invokeMethod2((Object)myObject, (String)"method_2", Integer.TYPE, Integer.TYPE, (Object)0, (Object)0));
        ReflectionUtilsTest.assertEquals((Object)3, (Object)ReflectionUtils.invokeMethod2((Object)myObject, (String)"method_3", Integer.TYPE, Integer.TYPE, Integer.TYPE, (Object)0, (Object)0, (Object)0));
        ReflectionUtilsTest.assertEquals((Object)4, (Object)ReflectionUtils.invokeMethod2((Object)myObject, (String)"method_4", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, (Object)0, (Object)0, (Object)0, (Object)0));
    }

    @Test
    public void test_invokeMethod() throws Exception {
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod(new ArrayList(), (String)"size()", (Object[])new Object[0]));
    }

    @Test
    public void test_invokeMethod_static() throws Exception {
        ReflectionUtilsTest.assertSame((Object)Collections.EMPTY_LIST, (Object)ReflectionUtils.invokeMethod(Collections.class, (String)"emptyList()", (Object[])new Object[0]));
    }

    @Test
    public void test_invokeMethod_notFound() throws Exception {
        try {
            ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod(new ArrayList(), (String)"size2()", (Object[])new Object[0]));
            ReflectionUtilsTest.fail();
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void test_invokeMethod_throw_InvocationTargetException() throws Exception {
        try {
            ReflectionUtils.invokeMethod((Object)Collections.EMPTY_LIST, (String)"add(java.lang.Object)", (Object[])new Object[]{this});
            ReflectionUtilsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void test_invokeMethod_throwErrorAsIs() throws Exception {
        try {
            class Foo {
                Foo() {
                }

                void throwException() {
                    throw new IllegalStateException();
                }
            }
            ReflectionUtils.invokeMethod((Object)new Foo(), (String)"throwException()", (Object[])new Object[0]);
            ReflectionUtilsTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_invokeMethodEx_noException() {
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethodEx(new ArrayList(), (String)"size()", (Object[])new Object[0]));
    }

    @Test
    public void test_invokeMethodEx_throwExceptionAsIs() {
        try {
            class Foo {
                Foo() {
                }

                void throwException() throws Exception {
                    throw new Exception("Bar");
                }
            }
            ReflectionUtils.invokeMethodEx((Object)new Foo(), (String)"throwException()", (Object[])new Object[0]);
            ReflectionUtilsTest.fail();
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(Exception.class);
            ReflectionUtilsTest.assertEquals((Object)"Bar", (Object)e.getMessage());
        }
    }

    @Test
    public void test_getConstructorBySignature_1() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getConstructorBySignature(ArrayList.class, (String)"<init>()"));
    }

    @Test
    public void test_getConstructorBySignature_2() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getConstructorBySignature(ArrayList.class, (String)"<init>(int)"));
    }

    @Test
    public void test_getConstructorBySignature_notFound() throws Exception {
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getConstructorBySignature(ArrayList.class, (String)"<init>(long)"));
    }

    @Test
    public void test_getConstructorByGenericSignature() throws Exception {
        class Foo<E> {
            public Foo(E e, String s) {
            }
        }
        Constructor constructor = ReflectionUtils.getConstructorByGenericSignature(Foo.class, (String)"<init>(E,java.lang.String)");
        ReflectionUtilsTest.assertNotNull((Object)constructor);
        constructor = ReflectionUtils.getConstructorByGenericSignature(Foo.class, (String)"<init>(E,java.lang.Integer)");
        ReflectionUtilsTest.assertNull((Object)constructor);
    }

    @Test
    public void test_getConstructorByGenericSignature_array() throws Exception {
        class Foo<E> {
            public Foo(E[] e, String s) {
            }
        }
        Constructor constructor = ReflectionUtils.getConstructorByGenericSignature(Foo.class, (String)"<init>(E[],java.lang.String)");
        ReflectionUtilsTest.assertNotNull((Object)constructor);
    }

    @Test
    public void test_getConstructor_byTypes_noParameters() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[0]));
    }

    @Test
    public void test_getConstructor_byTypes_withParameters() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}));
    }

    @Test
    public void test_getConstructor_byTypes_notFound() throws Exception {
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[]{Long.TYPE}));
    }

    @Test
    public void test_getConstructorForArguments() throws Exception {
        Constructor constructor = ReflectionUtils.getConstructorForArguments(Foo_getConstructorForArguments.class, (Object[])new Object[]{"a"});
        ReflectionUtilsTest.assertNull((Object)constructor);
        constructor = ReflectionUtils.getConstructorForArguments(Foo_getConstructorForArguments.class, (Object[])new Object[]{"a", "b"});
        ReflectionUtilsTest.assertNull((Object)constructor);
        constructor = ReflectionUtils.getConstructorForArguments(Foo_getConstructorForArguments.class, (Object[])new Object[]{"a", 1});
        ReflectionUtilsTest.assertNotNull((Object)constructor);
        constructor = ReflectionUtils.getConstructorForArguments(Foo_getConstructorForArguments.class, (Object[])new Object[]{1});
        ReflectionUtilsTest.assertNotNull((Object)constructor);
    }

    @Test
    public void test_equalsConstructor_sameConstructor() throws Exception {
        Constructor constructor = ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE});
        ReflectionUtilsTest.assertSame((Object)constructor, (Object)constructor);
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.equals((Constructor)constructor, (Constructor)constructor));
    }

    @Test
    public void test_equalsConstructor_sameClass_sameSignature() throws Exception {
        Constructor constructor_1 = ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE});
        Constructor constructor_2 = ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE});
        ReflectionUtilsTest.assertNotSame((Object)constructor_1, (Object)constructor_2);
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.equals((Constructor)constructor_1, (Constructor)constructor_2));
    }

    @Test
    public void test_equalsConstructor_differentClass_sameSignature() throws Exception {
        Constructor constructor_1 = ReflectionUtils.getConstructor(Vector.class, (Class[])new Class[]{Integer.TYPE});
        Constructor constructor_2 = ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE});
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.equals((Constructor)constructor_1, (Constructor)constructor_2));
    }

    @Test
    public void test_equalsConstructor_sameClass_differentSignature() throws Exception {
        Constructor constructor_1 = ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[0]);
        Constructor constructor_2 = ReflectionUtils.getConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE});
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.equals((Constructor)constructor_1, (Constructor)constructor_2));
    }

    @Test
    public void test_getShortestConstructor() throws Exception {
        Class<Class_getShortestConstructor> clazz = Class_getShortestConstructor.class;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Assertions.assertThat((Object[])constructors[0].getParameterTypes()).hasSize(2);
        Assertions.assertThat((Object[])constructors[1].getParameterTypes()).hasSize(1);
        Constructor constructor = ReflectionUtils.getShortestConstructor(clazz);
        Assertions.assertThat((Object[])constructor.getParameterTypes()).hasSize(1);
    }

    @Test
    public void test_getFields() throws Exception {
        class Bar
        extends Foo {
            public int e;

            Bar() {
                class Foo {
                    public int a;
                    protected int b;
                    private int c;
                    int d;

                    Foo() {
                    }
                }
            }
        }
        List fields = ReflectionUtils.getFields(Bar.class);
        Assertions.assertThat((List)fields).contains((Object[])new Field[]{Foo.class.getDeclaredField("a"), Foo.class.getDeclaredField("b"), Foo.class.getDeclaredField("c"), Foo.class.getDeclaredField("d"), Bar.class.getDeclaredField("e")});
    }

    @Test
    public void test_getFieldByName_public_static() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getFieldByName(Collections.class, (String)"EMPTY_LIST"));
    }

    @Test
    public void test_getFieldByName_private_super() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getFieldByName(ArrayList.class, (String)"modCount"));
    }

    @Test
    public void test_getFieldByName_fromInterface() throws Exception {
        ReflectionUtilsTest.assertNotNull((Object)ReflectionUtils.getFieldByName(JFrame.class, (String)"HIDE_ON_CLOSE"));
    }

    @Test
    public void test_getFieldByName_notFound() throws Exception {
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getFieldByName(Collections.class, (String)"EMPTY_LIST_NO"));
    }

    @Test
    public void test_getFieldObject() throws Exception {
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.getFieldObject((Object)new Mock(), (String)"o"));
    }

    @Test
    public void test_getFieldObject_static() throws Exception {
        ReflectionUtilsTest.assertSame((Object)Collections.EMPTY_LIST, (Object)ReflectionUtils.getFieldObject(Collections.class, (String)"EMPTY_LIST"));
    }

    @Test
    public void test_getFieldObject_notFound() throws Exception {
        try {
            ReflectionUtils.getFieldObject(Object.class, (String)"no-such-field");
            ReflectionUtilsTest.fail();
        }
        catch (Throwable e) {
            ReflectionUtilsTest.assertInstanceOf(IllegalArgumentException.class, (Object)DesignerExceptionUtils.getRootCause((Throwable)e));
        }
    }

    @Test
    public void test_getFieldString() throws Exception {
        class Foo {
            String m_value;

            Foo() {
            }
        }
        Foo foo = new Foo();
        foo.m_value = "some value";
        ReflectionUtilsTest.assertEquals((Object)"some value", (Object)foo.m_value);
        String fieldString = ReflectionUtils.getFieldString((Object)foo, (String)"m_value");
        ReflectionUtilsTest.assertEquals((Object)"some value", (Object)fieldString);
    }

    @Test
    public void test_getFieldShort() throws Exception {
        class A {
            short m_value = (short)123;

            A() {
            }
        }
        A foo = new A();
        ReflectionUtilsTest.assertEquals((short)foo.m_value, (short)ReflectionUtils.getFieldShort((Object)foo, (String)"m_value"));
    }

    @Test
    public void test_getFieldInt() throws Exception {
        ReflectionUtilsTest.assertEquals((int)0, (int)ReflectionUtils.getFieldInt((Object)new Mock(), (String)"i"));
    }

    @Test
    public void test_getFieldLong() throws Exception {
        class A {
            long field = 555L;

            A() {
            }
        }
        A a = new A();
        ReflectionUtilsTest.assertEquals((long)a.field, (long)ReflectionUtils.getFieldLong((Object)a, (String)"field"));
    }

    @Test
    public void test_getFieldFloat() throws Exception {
        ReflectionUtilsTest.assertEquals((double)0.0, (double)ReflectionUtils.getFieldFloat(Component.class, (String)"LEFT_ALIGNMENT"), (double)0.001);
    }

    @Test
    public void test_getFieldBoolean() throws Exception {
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.getFieldBoolean((Object)new Mock(), (String)"b"));
    }

    @Test
    public void test_setField() throws Exception {
        class Foo {
            String field;

            Foo() {
            }
        }
        Foo foo = new Foo();
        ReflectionUtilsTest.assertSame(null, (Object)foo.field);
        String s = "string";
        ReflectionUtils.setField((Object)foo, (String)"field", (Object)s);
        ReflectionUtilsTest.assertSame((Object)s, (Object)foo.field);
    }

    @Test
    public void test_setField_exception() throws Exception {
        class Foo {
            String field;

            Foo() {
            }
        }
        Foo foo = new Foo();
        try {
            Object invalidValue = new Object();
            ReflectionUtils.setField((Object)foo, (String)"field", (Object)invalidValue);
            ReflectionUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_propagate() throws Exception {
        RuntimeException result;
        Exception toThrow;
        Throwable toThrow2 = new Exception();
        try {
            ReflectionUtils.propagate((Throwable)toThrow2);
        }
        catch (Throwable e) {
            ReflectionUtilsTest.assertSame((Object)toThrow2, (Object)e);
        }
        toThrow2 = new Error();
        try {
            ReflectionUtils.propagate((Throwable)toThrow2);
        }
        catch (Throwable e) {
            ReflectionUtilsTest.assertSame((Object)toThrow2, (Object)e);
        }
        String key = "wbp.ReflectionUtils.propagate().forceReturn";
        System.setProperty(key, "true");
        try {
            toThrow = new Exception();
            result = ReflectionUtils.propagate((Throwable)toThrow);
            ReflectionUtilsTest.assertSame(null, (Object)result);
        }
        finally {
            System.clearProperty(key);
        }
        key = "wbp.ReflectionUtils.propagate().InstantiationException";
        System.setProperty(key, "true");
        try {
            toThrow = new Exception();
            result = ReflectionUtils.propagate((Throwable)toThrow);
            ReflectionUtilsTest.assertSame(null, (Object)result);
        }
        finally {
            System.clearProperty(key);
        }
        key = "wbp.ReflectionUtils.propagate().IllegalAccessException";
        System.setProperty(key, "true");
        try {
            toThrow = new Exception();
            result = ReflectionUtils.propagate((Throwable)toThrow);
            ReflectionUtilsTest.assertSame(null, (Object)result);
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    public void test_getExceptionToThrow() throws Exception {
        Throwable e = new Exception();
        Exception toThrow = ReflectionUtils.getExceptionToThrow((Throwable)e);
        ReflectionUtilsTest.assertSame((Object)e, (Object)toThrow);
        e = new Error();
        toThrow = ReflectionUtils.getExceptionToThrow((Throwable)e);
        ReflectionUtilsTest.assertNotSame((Object)e, (Object)toThrow);
        ReflectionUtilsTest.assertSame((Object)e, (Object)toThrow.getCause());
    }

    @Test
    public void test_getClassByName() throws Exception {
        Class[] primitiveClasses;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Class[] classArray = primitiveClasses = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        int n = primitiveClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class primitiveClass = classArray[n2];
            ReflectionUtilsTest.assertSame((Object)primitiveClass, (Object)ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)primitiveClass.getName()));
            ++n2;
        }
        ReflectionUtilsTest.assertSame(List.class, (Object)ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)"java.util.List"));
        ReflectionUtilsTest.assertSame(int[].class, (Object)ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)"int[]"));
        ReflectionUtilsTest.assertSame(String[].class, (Object)ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)"java.lang.String[]"));
        ReflectionUtilsTest.assertSame(boolean[][].class, (Object)ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)"boolean[][]"));
        ReflectionUtilsTest.assertSame(Double[][][].class, (Object)ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)"java.lang.Double[][][]"));
    }

    @Test
    public void test_hasClass() throws Exception {
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = thisClass.getClassLoader();
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.hasClass((ClassLoader)classLoader, (String)thisClass.getName()));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.hasClass((ClassLoader)classLoader, (String)"no.such.Class"));
    }

    @Test
    public void test_getDefaultValue() throws Exception {
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getDefaultValue(null));
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getDefaultValue((String)""));
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getDefaultValue((String)"java.lang.String"));
        ReflectionUtilsTest.assertNull((Object)ReflectionUtils.getDefaultValue((String)"java.util.ArrayList"));
        ReflectionUtilsTest.assertEquals((Object)false, (Object)ReflectionUtils.getDefaultValue((String)"boolean"));
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.getDefaultValue((String)"byte"));
        ReflectionUtilsTest.assertEquals((Object)Character.valueOf('\u0000'), (Object)ReflectionUtils.getDefaultValue((String)"char"));
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.getDefaultValue((String)"short"));
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.getDefaultValue((String)"int"));
        ReflectionUtilsTest.assertEquals((Object)0L, (Object)ReflectionUtils.getDefaultValue((String)"long"));
        ReflectionUtilsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)ReflectionUtils.getDefaultValue((String)"float"));
        ReflectionUtilsTest.assertEquals((Object)0.0, (Object)ReflectionUtils.getDefaultValue((String)"double"));
    }

    @Test
    public void test_getDefaultValue_byClass() throws Exception {
        ReflectionUtilsTest.assertEquals((Object)false, (Object)ReflectionUtils.getDefaultValue(Boolean.TYPE));
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.getDefaultValue(Byte.TYPE));
        ReflectionUtilsTest.assertEquals((Object)Character.valueOf('\u0000'), (Object)ReflectionUtils.getDefaultValue(Character.TYPE));
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.getDefaultValue(Short.TYPE));
        ReflectionUtilsTest.assertEquals((Object)0, (Object)ReflectionUtils.getDefaultValue(Integer.TYPE));
        ReflectionUtilsTest.assertEquals((Object)0L, (Object)ReflectionUtils.getDefaultValue(Long.TYPE));
        ReflectionUtilsTest.assertEquals((Object)Float.valueOf(0.0f), (Object)ReflectionUtils.getDefaultValue(Float.TYPE));
        ReflectionUtilsTest.assertEquals((Object)0.0, (Object)ReflectionUtils.getDefaultValue(Double.TYPE));
        ReflectionUtilsTest.assertEquals((Object)"<dynamic>", (Object)ReflectionUtils.getDefaultValue(String.class));
        Object o = (List)ReflectionUtils.getDefaultValue(ArrayList.class);
        Assertions.assertThat((List)o).isEmpty();
        o = (Set)ReflectionUtils.getDefaultValue(HashSet.class);
        Assertions.assertThat((Collection)o).isEmpty();
        o = (Map)ReflectionUtils.getDefaultValue(HashMap.class);
        Assertions.assertThat((Map)o).isEmpty();
        ReflectionUtilsTest.assertEquals(null, (Object)ReflectionUtils.getDefaultValue(System.class));
    }

    @Test
    public void test_getPropertyDescriptors_standardSwing() throws Exception {
        ReflectionUtilsTest.assertHasProperties(JButton.class, "enabled", "text");
    }

    @Test
    public void test_getPropertyDescriptors_nonStandardSwing() throws Exception {
        class MyButton
        extends JButton {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }
        }
        ReflectionUtilsTest.assertHasProperties(MyButton.class, "enabled", "text");
    }

    @Test
    public void test_getPropertyDescriptors_forInterface() throws Exception {
        ReflectionUtilsTest.assertHasProperties(I_tmp_Button.class, "enabled", "text");
    }

    @Test
    public void test_getPropertyDescriptors_differentTypesGetterSetter() throws Exception {
        class MyButton
        extends JButton {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            public int getFoo() {
                return 0;
            }

            public void setFoo(boolean b) {
            }
        }
        Map<String, PropertyDescriptor> propertiesMap = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class);
        Set<String> names = propertiesMap.keySet();
        Assertions.assertThat(names).contains((Object[])new String[]{"foo(boolean)", "foo(int)"});
        Assertions.assertThat(names).contains((Object[])new String[]{"enabled", "text"});
    }

    @Test
    public void test_getPropertyDescriptors_twoSettersWithSameName() throws Exception {
        class MyButton
        extends JPanel {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            public void setText(String[] s) {
            }

            public void setText(String s) {
            }
        }
        ReflectionUtilsTest.assertHasProperties(MyButton.class, "text(java.lang.String)", "text(java.lang.String[])");
    }

    @Test
    public void test_getPropertyDescriptors_twoSettersWithCommonNamePrefix() throws Exception {
        class MyButton
        extends JPanel {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            public void setEn(boolean b) {
            }

            public void setEna(boolean b) {
            }
        }
        ReflectionUtilsTest.assertHasProperties(MyButton.class, "en", "ena");
    }

    @Test
    public void test_getPropertyDescriptors_publicGetterProtectedSetter() throws Exception {
        class MyButton
        extends JPanel {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            public String getTitle() {
                return null;
            }

            protected void setTitle(String s) {
            }
        }
        Set<String> names = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class).keySet();
        Assertions.assertThat(names).contains((Object[])new String[]{"title"});
        Assertions.assertThat(names).doesNotContain((Object[])new String[]{"title(java.lang.String)"});
        PropertyDescriptor descriptor = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class).get("title");
        ReflectionUtilsTest.assertNotNull((Object)descriptor);
        ReflectionUtilsTest.assertNotNull((Object)descriptor.getReadMethod());
        ReflectionUtilsTest.assertNotNull((Object)descriptor.getWriteMethod());
    }

    @Test
    public void test_getPropertyDescriptors_protectedGetterPublicSetter() throws Exception {
        class MyButton
        extends JPanel {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            protected String getTitle() {
                return null;
            }

            public void setTitle(String s) {
            }
        }
        Set<String> names = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class).keySet();
        Assertions.assertThat(names).contains((Object[])new String[]{"title"});
        Assertions.assertThat(names).doesNotContain((Object[])new String[]{"title(java.lang.String)"});
        PropertyDescriptor descriptor = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class).get("title");
        ReflectionUtilsTest.assertNotNull((Object)descriptor);
        ReflectionUtilsTest.assertNotNull((Object)descriptor.getReadMethod());
        ReflectionUtilsTest.assertNotNull((Object)descriptor.getWriteMethod());
    }

    @Test
    public void test_getPropertyDescriptors_protectedMethodsWithIBM() throws Exception {
        class MyButton
        extends JPanel {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            protected String getA() {
                return null;
            }

            protected void setA(String s) {
            }
        }
        Set<String> names = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class).keySet();
        Assertions.assertThat(names).contains((Object[])new String[]{"enabled", "a"});
        EnvironmentUtils.setForcedIBM((boolean)true);
        ReflectionUtils.flushPropertyDescriptorsCache(MyButton.class);
        try {
            names = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class).keySet();
            ((AbstractCollectionAssert)Assertions.assertThat(names).contains((Object[])new String[]{"enabled"})).doesNotContain((Object[])new String[]{"a"});
        }
        finally {
            EnvironmentUtils.setForcedIBM((boolean)false);
        }
    }

    @Test
    public void test_getPropertyDescriptors_pureGetName() throws Exception {
        class MyButton
        extends JButton {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            public int get() {
                return 0;
            }
        }
        Map<String, PropertyDescriptor> propertiesMap = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class);
        Set<String> names = propertiesMap.keySet();
        Assertions.assertThat(names).doesNotContain((Object[])new String[]{""});
        Assertions.assertThat(names).contains((Object[])new String[]{"enabled", "text"});
    }

    @Test
    public void test_getPropertyDescriptors_voidGetter() throws Exception {
        class MyButton
        extends JButton {
            private static final long serialVersionUID = 0L;

            MyButton() {
            }

            public void getFoo() {
            }
        }
        Map<String, PropertyDescriptor> propertiesMap = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton.class);
        Set<String> names = propertiesMap.keySet();
        Assertions.assertThat(names).doesNotContain((Object[])new String[]{"foo"});
        Assertions.assertThat(names).contains((Object[])new String[]{"enabled", "text"});
    }

    @Test
    public void test_getPropertyDescriptors_whenBridgeMethod() throws Exception {
        class SpecificClass
        extends 1GenericClass<String> {
            SpecificClass() {
                class GenericClass<T> {
                    GenericClass() {
                    }

                    public T getFoo() {
                        return null;
                    }

                    public void setFoo(T value) {
                    }
                }
            }

            @Override
            public String getFoo() {
                return null;
            }
        }
        Map<String, PropertyDescriptor> descriptors = ReflectionUtilsTest.getPropertyDescriptorNames(SpecificClass.class);
        PropertyDescriptor propertyDescriptor = descriptors.get("foo");
        ReflectionUtilsTest.assertNotNull((Object)propertyDescriptor);
        ReflectionUtilsTest.assertSame(Object.class, propertyDescriptor.getPropertyType());
    }

    @Test
    public void test_getPropertyDescriptors_ignoreStaticSetters() throws Exception {
        Map<String, PropertyDescriptor> propertiesMap = ReflectionUtilsTest.getPropertyDescriptorNames(MyButton_getPropertyDescriptors_ignoreStaticSetters.class);
        Set<String> names = propertiesMap.keySet();
        Assertions.assertThat(names).doesNotContain((Object[])new String[]{"foo"});
        Assertions.assertThat(names).contains((Object[])new String[]{"enabled", "text"});
    }

    private static void assertHasProperties(Class<?> clazz, String ... expectedNames) throws Exception {
        List<PropertyDescriptor> descriptors = ReflectionUtilsTest.getPropertyDescriptors(clazz);
        ArrayList<String> propertyNames = new ArrayList<String>();
        ArrayList<Method> propertySetters = new ArrayList<Method>();
        for (PropertyDescriptor descriptor : descriptors) {
            propertyNames.add(descriptor.getName());
            if (descriptor.getWriteMethod() == null) continue;
            propertySetters.add(descriptor.getWriteMethod());
        }
        Assertions.assertThat(propertyNames).doesNotHaveDuplicates();
        Assertions.assertThat(propertySetters).doesNotHaveDuplicates();
        Assertions.assertThat(propertyNames).contains((Object[])expectedNames);
    }

    private static Map<String, PropertyDescriptor> getPropertyDescriptorNames(Class<?> clazz) throws Exception {
        List<PropertyDescriptor> descriptors = ReflectionUtilsTest.getPropertyDescriptors(clazz);
        return ReflectionUtilsTest.getPropertyDescriptorNames(descriptors);
    }

    private static Map<String, PropertyDescriptor> getPropertyDescriptorNames(List<PropertyDescriptor> descriptors) throws Exception {
        TreeMap<String, PropertyDescriptor> propertiesMap = new TreeMap<String, PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            propertiesMap.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return propertiesMap;
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) throws Exception {
        BeanInfo beanInfo = ReflectionUtils.getBeanInfo(clazz);
        return ReflectionUtils.getPropertyDescriptors((BeanInfo)beanInfo, clazz);
    }

    @Test
    public void test_isSuccessorOf() throws Exception {
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf(List.class, (String)"java.util.List"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf(List.class, (String)"java.util.Collection"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf(ArrayList.class, (String)"java.util.List"));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isSuccessorOf(Map.class, (String)"java.util.Collection"));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isSuccessorOf(List.class, (String)"no.such.Class"));
    }

    @Test
    public void test_isAssignableFrom() throws Exception {
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Object.class, (Object)new Object()));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Object.class, (Object)"string"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(String.class, (Object)"string"));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAssignableFrom(Integer.class, (Object)"string"));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAssignableFrom(String.class, (Object)new Object()));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(String.class, null));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Integer.class, null));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAssignableFrom(Integer.TYPE, null));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isAssignableFrom(Integer.TYPE, (Object)"string"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Byte.TYPE, (Object)0));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Character.TYPE, (Object)Character.valueOf('0')));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Short.TYPE, (Object)0));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Integer.TYPE, (Object)0));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Long.TYPE, (Object)0L));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Float.TYPE, (Object)Float.valueOf(0.0f)));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isAssignableFrom(Double.TYPE, (Object)0.0));
    }

    @Test
    public void test_isSuccessorOf_Object_String() throws Exception {
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isSuccessorOf(null, (String)"java.lang.Object"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)0, (String)"byte"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)Character.valueOf('0'), (String)"char"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)0, (String)"int"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)0, (String)"short"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)0L, (String)"long"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)Float.valueOf(0.0f), (String)"float"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)0.0, (String)"double"));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isSuccessorOf((Object)0, (String)"int"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)new Object(), (String)"java.lang.Object"));
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isSuccessorOf((Object)new Object(), (String)"java.lang.String"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)new String(), (String)"java.lang.Object"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)new String(), (String)"java.lang.String"));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf(new ArrayList(), (String)"java.util.List"));
    }

    @Test
    public void test_isMemberClass() throws Exception {
        ReflectionUtilsTest.assertFalse((boolean)ReflectionUtils.isMemberClass(Map.class));
        ReflectionUtilsTest.assertTrue((boolean)ReflectionUtils.isMemberClass(Map.Entry.class));
    }

    @Test
    public void test_getAllSupertypes() throws Exception {
        List types = ReflectionUtils.getSuperHierarchy(Object.class);
        Assertions.assertThat((List)types).containsExactly((Object[])new Class[]{Object.class});
        abstract class A
        implements List<String> {
            A() {
            }
        }
        types = ReflectionUtils.getSuperHierarchy(A.class);
        Assertions.assertThat((List)types).containsExactly((Object[])new Class[]{A.class, List.class, Object.class});
        abstract class B
        extends A
        implements Comparable<String> {
            B() {
            }
        }
        types = ReflectionUtils.getSuperHierarchy(B.class);
        Assertions.assertThat((List)types).containsExactly((Object[])new Class[]{B.class, Comparable.class, A.class, List.class, Object.class});
    }

    public static class Class_getShortestConstructor {
        public Class_getShortestConstructor(int a, int b) {
        }

        public Class_getShortestConstructor(int a) {
        }
    }

    class Class_packagePrivate {
        Class_packagePrivate() {
        }
    }

    private class Class_private {
        private Class_private() {
        }
    }

    protected class Class_protected {
        protected Class_protected() {
        }
    }

    public class Class_public {
    }

    private static class Foo_getConstructorForArguments {
        public Foo_getConstructorForArguments(String a, Integer b) {
        }

        public Foo_getConstructorForArguments(int a) {
        }
    }

    private static interface I_tmp_Button
    extends I_tmp_Component {
        public void setText(String var1);
    }

    private static interface I_tmp_Component {
        public void setEnabled(boolean var1);
    }

    private static class Mock
    extends MockBase {
        private Mock() {
        }

        private void foo2(int j) {
        }

        @Override
        protected void foo(int j) {
        }
    }

    private static class MockBase {
        private final boolean b = true;
        private final int i = 0;
        private final Object o = 0;

        private MockBase() {
        }

        private void foo1(int j) {
        }

        protected void foo(int j) {
        }
    }

    private static class MyButton_getPropertyDescriptors_ignoreStaticSetters
    extends JButton {
        private MyButton_getPropertyDescriptors_ignoreStaticSetters() {
        }

        public static void setFoo(int value) {
        }
    }

    static interface MyCollection
    extends Collection<Object> {
    }
}

