/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.jdt.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.wb.internal.core.utils.jdt.core.SubtypesScope;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SubtypesScopeTest
extends AbstractJavaTest {
    private IJavaProject javaProject;
    private IType aType;
    private IType bType;
    private IType cType;
    private SubtypesScope scope;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject != null) {
            this.javaProject = m_testProject.getJavaProject();
            ICompilationUnit aUnit = this.createModelCompilationUnit("test", "A.java", SubtypesScopeTest.getSourceDQ("package test;", "public class A {", "}"));
            ICompilationUnit bUnit = this.createModelCompilationUnit("test", "B.java", SubtypesScopeTest.getSourceDQ("package test;", "public class B extends A {", "}"));
            ICompilationUnit cUnit = this.createModelCompilationUnit("test", "C.java", SubtypesScopeTest.getSourceDQ("package test;", "public class C extends B {", "}"));
            this.aType = aUnit.findPrimaryType();
            this.bType = bUnit.findPrimaryType();
            this.cType = cUnit.findPrimaryType();
            this.scope = new SubtypesScope(this.bType);
        }
    }

    @BeforeAll
    public static void setUpClass() throws Exception {
        SubtypesScopeTest.do_projectCreate();
    }

    @Test
    public void test_enclosesType() throws Exception {
        SubtypesScopeTest.assertFalse((boolean)this.scope.encloses((IJavaElement)this.cType.getCompilationUnit()));
        SubtypesScopeTest.assertTrue((boolean)this.scope.encloses((IJavaElement)this.cType));
        SubtypesScopeTest.assertFalse((boolean)this.scope.encloses((IJavaElement)this.aType));
        SubtypesScopeTest.assertFalse((boolean)this.scope.encloses((IJavaElement)this.bType));
        SubtypesScopeTest.assertFalse((boolean)this.scope.encloses((IJavaElement)this.javaProject.findType("java.util.List")));
        SubtypesScopeTest.assertFalse((boolean)this.scope.encloses((IJavaElement)this.javaProject.findType("java.lang.Object")));
    }

    @Test
    public void test_enclosesResource() throws Exception {
        SubtypesScopeTest.assertTrue((boolean)this.scope.encloses("/TestProject/src/test/C.java"));
        SubtypesScopeTest.assertFalse((boolean)this.scope.encloses("/TestProject/src/test/A.java"));
        SubtypesScopeTest.assertFalse((boolean)this.scope.encloses("/TestProject/src/test/B.java"));
    }

    @Test
    public void test_enclosingProjectsAndJars() throws Exception {
        IPath[] paths = this.scope.enclosingProjectsAndJars();
        SubtypesScopeTest.assertTrue((paths.length >= 2 ? 1 : 0) != 0);
    }

    @Test
    public void test_deprecated() throws Exception {
        this.scope.setIncludesBinaries(true);
        this.scope.setIncludesClasspaths(true);
        SubtypesScopeTest.assertTrue((boolean)this.scope.includesBinaries());
        SubtypesScopeTest.assertTrue((boolean)this.scope.includesClasspaths());
    }

    @Test
    public void test_otherScope() throws Exception {
        SubtypesScope scope2 = new SubtypesScope(this.javaProject.findType("java.util.List"));
        SubtypesScopeTest.assertTrue((boolean)scope2.encloses((IJavaElement)this.javaProject.findType("java.util.ArrayList")));
        SubtypesScopeTest.assertTrue((boolean)scope2.encloses("C:/some/path/rt.jar|java/util/ArrayList.class"));
        SubtypesScopeTest.assertFalse((boolean)scope2.encloses("C:/some/path/rt.jar|java/util/HashMap.class"));
    }
}

