/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.wst.jsdt.core.BufferChangedEvent;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferChangedListener;
import org.eclipse.wst.jsdt.core.IBufferFactory;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.codeassist.CompletionEngine;
import org.eclipse.wst.jsdt.internal.codeassist.SelectionEngine;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.BufferManager;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelCache;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.NullBuffer;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SelectionRequestor;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class Openable
extends JavaElement
implements IOpenable,
IBufferChangedListener {
    protected Openable(JavaElement parent) {
        super(parent);
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().add(this);
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws JavaScriptModelException;

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        return !buffer.hasUnsavedChanges();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    protected void closing(Object info) {
        this.closeBuffer();
    }

    protected void codeComplete(ICompilationUnit cu, ICompilationUnit unitToSkip, int position, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaScriptModelException {
        IBuffer buffer;
        PerformanceStats performanceStats;
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        PerformanceStats performanceStats2 = performanceStats = CompletionEngine.PERF ? PerformanceStats.getStats((String)"org.eclipse.wst.jsdt.core/perf/completion", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(cu.getFileName())) + " at " + position);
        }
        if ((buffer = this.getBuffer()) == null) {
            return;
        }
        if (position < -1 || position > buffer.getLength()) {
            throw new JavaScriptModelException(new JavaModelStatus(980));
        }
        JavaProject project = (JavaProject)this.getJavaScriptProject();
        SearchableEnvironment environment = this.newSearchableNameEnvironment(owner);
        environment.unitToSkip = unitToSkip;
        CompletionEngine engine = new CompletionEngine(environment, requestor, project.getOptions(true), project);
        engine.complete(cu, position, 0);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
    }

    protected IJavaScriptElement[] codeSelect(ICompilationUnit cu, int offset, int length, WorkingCopyOwner owner) throws JavaScriptModelException {
        PerformanceStats performanceStats;
        PerformanceStats performanceStats2 = performanceStats = SelectionEngine.PERF ? PerformanceStats.getStats((String)"org.eclipse.wst.jsdt.core/perf/selection", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(cu.getFileName())) + " at [" + offset + "," + length + "]");
        }
        JavaProject project = (JavaProject)this.getJavaScriptProject();
        SearchableEnvironment environment = this.newSearchableNameEnvironment(owner);
        SelectionRequestor requestor = new SelectionRequestor(environment.nameLookup, this);
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return requestor.getElements();
        }
        int end = buffer.getLength();
        if (offset < 0 || length < 0 || offset + length > end) {
            throw new JavaScriptModelException(new JavaModelStatus(980));
        }
        SelectionEngine engine = new SelectionEngine(environment, requestor, project.getOptions(true));
        engine.select(cu, offset, offset + length - 1);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
        return requestor.getElements();
    }

    protected Object createElementInfo() {
        return new OpenableElementInfo();
    }

    public boolean exists() {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (manager.getInfo(this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (!(root == null || root != this && root.isArchive())) {
            return this.resourceExists();
        }
        return super.exists();
    }

    public String findRecommendedLineSeparator() throws JavaScriptModelException {
        IBuffer buffer = this.getBuffer();
        String source = buffer == null ? null : buffer.getContents();
        return Util.getLineSeparator(source, this.getJavaScriptProject());
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor monitor) throws JavaScriptModelException {
        if (JavaModelCache.VERBOSE) {
            String element;
            switch (this.getElementType()) {
                case 2: {
                    element = "project";
                    break;
                }
                case 3: {
                    element = "root";
                    break;
                }
                case 4: {
                    element = "package";
                    break;
                }
                case 6: {
                    element = "class file";
                    break;
                }
                case 5: {
                    element = "compilation unit";
                    break;
                }
                default: {
                    element = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + element + " " + this.toStringWithAncestors());
        }
        this.openParent(info, newElements, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        newElements.put(this, info);
        try {
            OpenableElementInfo openableElementInfo = (OpenableElementInfo)info;
            boolean isStructureKnown = this.buildStructure(openableElementInfo, monitor, newElements, this.getResource());
            openableElementInfo.setIsStructureKnown(isStructureKnown);
        }
        catch (JavaScriptModelException e) {
            newElements.remove(this);
            throw e;
        }
        JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        if (JavaModelCache.VERBOSE) {
            System.out.println(JavaModelManager.getJavaModelManager().cacheToString("-> "));
        }
    }

    public IBuffer getBuffer() throws JavaScriptModelException {
        if (this.hasBuffer()) {
            Object info = this.getElementInfo();
            IBuffer buffer = this.getBufferManager().getBuffer(this);
            if (buffer == null) {
                buffer = this.openBuffer(null, info);
            }
            if (buffer instanceof NullBuffer) {
                return null;
            }
            return buffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws JavaScriptModelException {
        return this.getUnderlyingResource();
    }

    public IOpenable getOpenable() {
        return this;
    }

    public IResource getUnderlyingResource() throws JavaScriptModelException {
        IResource parentResource = this.parent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.getElementName());
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws JavaScriptModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer buf = this.getBuffer();
        if (buf != null && buf.hasUnsavedChanges()) {
            return true;
        }
        int elementType = this.getElementType();
        if (elementType == 4 || elementType == 3 || elementType == 2 || elementType == 1) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                IJavaScriptElement owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (IJavaScriptElement)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isOpen() {
        return JavaModelManager.getJavaModelManager().getInfo(this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    public boolean isStructureKnown() throws JavaScriptModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    public void makeConsistent(IProgressMonitor monitor) throws JavaScriptModelException {
    }

    public void open(IProgressMonitor pm) throws JavaScriptModelException {
        this.getElementInfo(pm);
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaScriptModelException {
        return null;
    }

    protected void openParent(Object childInfo, HashMap newElements, IProgressMonitor pm) throws JavaScriptModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    protected boolean parentExists() {
        IJavaScriptElement parentElement = this.getParent();
        if (parentElement == null) {
            return true;
        }
        return parentElement.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return JavaModel.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    public void save(IProgressMonitor pm, boolean force) throws JavaScriptModelException {
        if (this.isReadOnly()) {
            throw new JavaScriptModelException(new JavaModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    public PackageFragmentRoot getPackageFragmentRoot() {
        return (PackageFragmentRoot)this.getAncestor(3);
    }
}

