/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptImageRegistry;

public class JavaScriptImageDescriptor
extends CompositeImageDescriptor {
    public static final int INSTALLED = 1;
    public static final int ENTRY = 2;
    public static final int EXIT = 4;
    public static final int ENABLED = 8;
    public static final int CONDITIONAL = 16;
    public static final int SCOPED = 32;
    private Image fBaseImage;
    private int fFlags;
    private Point fSize;

    public JavaScriptImageDescriptor(Image baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JavaScriptImageDescriptor)) {
            return false;
        }
        JavaScriptImageDescriptor other = (JavaScriptImageDescriptor)((Object)object);
        return this.getBaseImage().equals((Object)other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    private ImageData getImageData(String imageDescriptorKey) {
        return JavaScriptImageRegistry.getSharedImage(imageDescriptorKey).getImageData();
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((flags & 1) != 0) {
            x = 0;
            y = this.getSize().y;
            data = (flags & 8) != 0 ? this.getImageData("IMG_OVR_INSTALLED") : this.getImageData("IMG_OVR_INSTALLED_DISABLED");
            this.drawImage(data, x, y -= data.height);
        }
        if ((flags & 0x20) != 0) {
            data = (flags & 8) != 0 ? this.getImageData("IMG_OVR_SCOPED") : this.getImageData("IMG_OVR_SCOPED_DISABLED");
            x = 0;
            y = this.getSize().y;
            this.drawImage(data, x, y -= data.height);
        }
        if ((flags & 0x10) != 0) {
            data = (flags & 8) != 0 ? this.getImageData("IMG_OVR_CONDITIONAL") : this.getImageData("IMG_OVR_CONDITIONAL_DISABLED");
            x = 0;
            y = 0;
            this.drawImage(data, x, y);
        }
        if ((flags & 2) != 0) {
            x = this.getSize().x;
            y = 0;
            data = (flags & 8) != 0 ? this.getImageData("IMG_OVR_ENTRY") : this.getImageData("IMG_OVR_ENTRY_DISABLED");
            x -= data.width;
            this.drawImage(data, x -= 2, y);
        }
        if ((flags & 4) != 0) {
            x = this.getSize().x;
            y = this.getSize().y;
            data = (flags & 8) != 0 ? this.getImageData("IMG_OVR_EXIT") : this.getImageData("IMG_OVR_EXIT_DISABLED");
            x -= data.width;
            this.drawImage(data, x -= 2, y -= data.height);
        }
    }

    protected Image getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(Image baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

