/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.model.IDesigntimeAdapter;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.ui.internal.common.Messages;

public final class ViewObjectPresenter {
    public static String present(ComponentTypeInfo typeInfo) {
        String componentType = typeInfo.getComponentType();
        String componentFamily = typeInfo.getComponentFamily();
        String renderType = typeInfo.getRenderFamily();
        String componentClass = typeInfo.getClassName();
        ArrayList<TitleValuePair> values = new ArrayList<TitleValuePair>();
        values.add(new TitleValuePair(Messages.ViewObjectPresenter_ComponentType, componentType == null ? "" : componentType));
        values.add(new TitleValuePair(Messages.ViewObjectPresenter_ComponentClass, componentClass == null ? "" : componentClass));
        values.add(new TitleValuePair(Messages.ViewObjectPresenter_ComponentFamily, componentFamily == null ? "" : componentFamily));
        values.add(new TitleValuePair(Messages.ViewObjectPresenter_RenderType, renderType == null ? "" : renderType));
        return String.format("<form>%s</form>", ViewObjectPresenter.createLines(values));
    }

    public static String presentCompInterfaces(ComponentTypeInfo typeInfo, ComponentInfo compInfo) {
        HashSet<String> interfaces = new HashSet<String>();
        interfaces.addAll(Arrays.asList(typeInfo.getInterfaces()));
        if (compInfo != null) {
            for (Map.Entry entry : compInfo.getAllAdapters().entrySet()) {
                Object infObject = entry.getValue();
                if (!(infObject instanceof IDesigntimeAdapter)) continue;
                interfaces.addAll(Arrays.asList(((IDesigntimeAdapter)infObject).getInterfaces()));
            }
        }
        ArrayList sortedInterfaceNames = new ArrayList(interfaces);
        Collections.sort(sortedInterfaceNames);
        Object text = "";
        for (String name : sortedInterfaceNames) {
            text = (String)text + ViewObjectPresenter.createLine(null, name);
        }
        return String.format("<form>%s</form>", text);
    }

    public static String createLines(List<TitleValuePair> values) {
        Object lines = "";
        for (TitleValuePair valueEntry : values) {
            String title = valueEntry.getTitle();
            String value = valueEntry.getValue();
            lines = (String)lines + ViewObjectPresenter.createLine(title, value);
        }
        return lines;
    }

    public static String createLine(String title, String value) {
        if (title == null) {
            return String.format("<p>%s</p>", value);
        }
        return String.format("<p><b>%s</b>: %s</p>", title, value);
    }

    private ViewObjectPresenter() {
    }

    public static final class TitleValuePair
    implements Comparable<TitleValuePair> {
        private final String _title;
        private final String _value;

        public TitleValuePair(String title, String value) {
            if (value == null) {
                throw new IllegalArgumentException("Value must not be null");
            }
            this._title = title;
            this._value = value;
        }

        protected final String getTitle() {
            return this._title;
        }

        protected final String getValue() {
            return this._value;
        }

        @Override
        public int compareTo(TitleValuePair other) {
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return 1;
            }
            if (this._title == null) {
                return other.getTitle() == null ? 0 : 1;
            }
            if (other.getTitle() == null) {
                return 1;
            }
            return this._title.compareTo(other.getTitle());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TitleValuePair) {
                TitleValuePair other = (TitleValuePair)obj;
                String otherValue = other.getValue();
                if (!otherValue.equals(this._value)) {
                    return false;
                }
                String otherTitle = other.getTitle();
                if (this._title == null) {
                    return otherTitle == null;
                }
                if (otherTitle == null) {
                    return this._title == null;
                }
                return this._title.equals(otherTitle);
            }
            return false;
        }

        public int hashCode() {
            return this.getTitle().hashCode();
        }
    }
}

