/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axis.Part;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class JAFDataHandlerSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(JAFDataHandlerSerializer.class.getName());

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        DataHandler dh = (DataHandler)value;
        Attachments attachments = context.getCurrentMessage().getAttachmentsImpl();
        if (attachments == null) {
            throw new IOException(Messages.getMessage("noAttachments"));
        }
        SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
        Part attachmentPart = attachments.createAttachmentPart(dh);
        AttributesImpl attrs = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attrs.setAttributes(attributes);
        }
        int typeIndex = -1;
        typeIndex = attrs.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeIndex != -1) {
            attrs.removeAttribute(typeIndex);
        }
        if (attachments.getSendType() == 4) {
            context.setWriteXMLType(null);
            context.startElement(name, attrs);
            AttributesImpl attrs2 = new AttributesImpl();
            attrs2.addAttribute("", soapConstants.getAttrHref(), soapConstants.getAttrHref(), "CDATA", attachmentPart.getContentIdRef());
            context.startElement(new QName("http://www.w3.org/2004/08/xop/include", "Include"), attrs2);
            context.endElement();
            context.endElement();
        } else {
            boolean doTheDIME = false;
            if (attachments.getSendType() == 3) {
                doTheDIME = true;
            }
            attrs.addAttribute("", soapConstants.getAttrHref(), soapConstants.getAttrHref(), "CDATA", doTheDIME ? attachmentPart.getContentId() : attachmentPart.getContentIdRef());
            context.startElement(name, attrs);
            context.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}

