/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.stack;

import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.stack.Stack;

public class DequeStack<E>
implements Stack<E>,
Serializable {
    private Deque<E> deque;
    private static final long serialVersionUID = 1L;

    public DequeStack(Deque<E> deque) {
        this.deque = deque;
    }

    @Override
    public void push(E element) {
        this.deque.enqueueHead(element);
    }

    @Override
    public E pop() {
        try {
            return this.deque.dequeueHead();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new EmptyStackException();
        }
    }

    @Override
    public E peek() {
        try {
            return this.deque.peekHead();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new EmptyStackException();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public String toString() {
        return this.deque.toString();
    }
}

