/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.catalog;

import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.wst.json.core.internal.schema.catalog.CommonXML;
import org.eclipse.wst.json.core.internal.schema.catalog.EntryParser;
import org.eclipse.wst.json.core.internal.schema.catalog.UserEntry;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CatalogTests
extends TestCase {
    static final String ONE_ENTRY_USING_JAXB = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><entries><entry fileMatch=\"fileMatch0\" url=\"file:///Users/user_0\"/></entries>";

    public void testVersusXmlBinding() throws Exception {
        Document jaxbDocument = CommonXML.getDocumentBuilder((boolean)false).parse(new InputSource(new StringReader(ONE_ENTRY_USING_JAXB)));
        UserEntry[] entryArray = new UserEntry[1];
        int i = 0;
        while (i < entryArray.length) {
            entryArray[i] = new UserEntry();
            entryArray[i].setFileMatch("fileMatch" + i);
            entryArray[i].setUrl(new URI("file:///Users/user_" + i));
            ++i;
        }
        HashSet<UserEntry> entries = new HashSet<UserEntry>(Arrays.asList(entryArray));
        String newXML = new EntryParser().serialize(entries);
        Document newDocument = CommonXML.getDocumentBuilder((boolean)false).parse(new InputSource(new StringReader(newXML)));
        boolean same = this.compareNodeLists("#document", this.getElements(jaxbDocument.getChildNodes()), this.getElements(newDocument.getChildNodes()));
        Assert.assertTrue((String)"Incompatible storage, user preferences might be lost!", (boolean)same);
    }

    private Element[] getElements(NodeList nodes) {
        ArrayList<Element> elements = new ArrayList<Element>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getNodeType() == 1) {
                elements.add((Element)nodes.item(i));
            }
            ++i;
        }
        return elements.toArray(new Element[elements.size()]);
    }

    private boolean compareNodeLists(String elementName, Element[] oldList, Element[] newList) {
        Assert.assertEquals((String)(String.valueOf(elementName) + " children differed by number"), (long)oldList.length, (long)newList.length);
        int i = 0;
        while (i < oldList.length) {
            Assert.assertEquals((String)("child " + i + " of " + elementName + " had a different name"), (Object)oldList[i].getNodeName(), (Object)newList[i].getNodeName());
            this.compareNodeLists(oldList[i].getNodeName(), this.getElements(oldList[i].getChildNodes()), this.getElements(newList[i].getChildNodes()));
            ++i;
        }
        return true;
    }
}

