/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.eol;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.io.FileTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class CheckWinEOL {
    private static final String DEFAULT_ROOT_DIR_NAME = "C:/dev/main";
    public static final int CR = 13;
    public static final int LF = 10;
    private static final Predicate<File> FILE_IS_JAVA_FILE = new FileIsJavaFile();
    private static final Predicate<File> FILE_HAS_INVALID_WIN_EOL = new FileHasInvalidWinEOL();
    private static final Transformer<File, String> FILE_ABSOLUTE_PATH_TRANSFORMER = new FileAbsolutePathTransformer();

    public static void main(String[] args) {
        CheckWinEOL.main(args.length == 0 ? DEFAULT_ROOT_DIR_NAME : args[0]);
        System.exit(0);
    }

    public static void main(String rootDirectoryName) {
        Iterable<File> invalidJavaFiles = CheckWinEOL.getAllJavaFilesWithInvalidWinEOL(rootDirectoryName);
        int count = 0;
        System.out.println("Java files with bogus EOL:");
        for (String invalidFileName : CollectionTools.treeSet((Iterable)IterableTools.transform(invalidJavaFiles, FILE_ABSOLUTE_PATH_TRANSFORMER))) {
            ++count;
            System.out.print('\t');
            System.out.println(invalidFileName);
        }
        System.out.println("*** total = " + count + " ***");
    }

    public static Iterable<File> getAllJavaFilesWithInvalidWinEOL(String directoryName) {
        return CheckWinEOL.getAllJavaFilesWithInvalidWinEOL(new File(directoryName));
    }

    public static Iterable<File> getAllJavaFilesWithInvalidWinEOL(File directory) {
        return CheckWinEOL.extractFilesWithInvalidWinEOL(CheckWinEOL.javaFiles(FileTools.getAllFiles((File)directory)));
    }

    private static Iterable<File> javaFiles(Iterable<File> files) {
        return IterableTools.filter(files, FILE_IS_JAVA_FILE);
    }

    public static Iterable<File> getAllFilesWithInvalidWinEOL(String directoryName) {
        return CheckWinEOL.getAllFilesWithInvalidWinEOL(new File(directoryName));
    }

    public static Iterable<File> getAllFilesWithInvalidWinEOL(File directory) {
        return CheckWinEOL.extractFilesWithInvalidWinEOL(FileTools.getAllFiles((File)directory));
    }

    public static Iterable<File> extractFilesWithInvalidWinEOL(Iterable<File> files) {
        return IterableTools.filter(files, FILE_HAS_INVALID_WIN_EOL);
    }

    public static boolean streamHasInvalidWinEOL(InputStream stream) throws IOException {
        int previous = -1;
        int current = stream.read();
        int next = stream.read();
        while (current != -1) {
            if (CheckWinEOL.charsAreInvalidWinEOL(previous, current, next)) {
                return true;
            }
            previous = current;
            current = next;
            next = stream.read();
        }
        return false;
    }

    public static boolean charsAreInvalidWinEOL(int previous, int current, int next) {
        if (current == 13) {
            return next != 10;
        }
        if (current == 10) {
            return previous != 13;
        }
        return false;
    }

    static class FileAbsolutePathTransformer
    extends TransformerAdapter<File, String> {
        FileAbsolutePathTransformer() {
        }

        public String transform(File file) {
            return file.getAbsolutePath();
        }
    }

    static class FileHasInvalidWinEOL
    extends PredicateAdapter<File> {
        FileHasInvalidWinEOL() {
        }

        public boolean evaluate(File file) {
            try {
                return this.fileHasInvalidWinEOL(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
        }

        private boolean fileHasInvalidWinEOL(File file) throws FileNotFoundException, IOException {
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 262144);){
                boolean bl = CheckWinEOL.streamHasInvalidWinEOL(stream);
                return bl;
            }
        }
    }

    static class FileIsJavaFile
    extends PredicateAdapter<File> {
        FileIsJavaFile() {
        }

        public boolean evaluate(File file) {
            return file.getName().toLowerCase().endsWith(".java");
        }
    }
}

