/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.AbstractCollationEqualFunction;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnCompare;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnIndexOf
extends AbstractCollationEqualFunction {
    private static Collection _expected_args = null;

    public FnIndexOf() {
        super(new QName("index-of"), 2, 3);
    }

    @Override
    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        return FnIndexOf.index_of(args, ec.getDynamicContext());
    }

    private static CmpEq get_comparable(AnyType at) throws DynamicError {
        if (at instanceof NodeType) {
            XSString nodeString = new XSString(at.getStringValue());
            return nodeString;
        }
        if (!(at instanceof AnyAtomicType)) {
            DynamicError.throw_type_error();
        }
        if (!(at instanceof CmpEq)) {
            throw DynamicError.not_cmp(null);
        }
        return (CmpEq)((Object)at);
    }

    public static ResultSequence index_of(Collection args, DynamicContext dc) {
        ResultSequence arg3;
        Function.convert_arguments(args, FnIndexOf.expected_args());
        Iterator citer = args.iterator();
        ResultSequence arg1 = (ResultSequence)citer.next();
        ResultSequence arg2 = (ResultSequence)citer.next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        if (arg2.size() != 1) {
            DynamicError.throw_type_error();
        }
        String collationUri = dc.getCollationProvider().getDefaultCollation();
        if (citer.hasNext() && !(arg3 = (ResultSequence)citer.next()).empty()) {
            XSString collation = (XSString)arg3.first();
            collationUri = collation.getStringValue();
        }
        ResultBuffer rb = new ResultBuffer();
        AnyAtomicType at = (AnyAtomicType)arg2.first();
        FnIndexOf.get_comparable(at);
        int index = 1;
        Iterator<Item> i = arg1.iterator();
        while (i.hasNext()) {
            XSString itemStr;
            XSString xstr1;
            AnyType cmptype = (AnyType)i.next();
            FnIndexOf.get_comparable(cmptype);
            if (!(at instanceof CmpEq)) continue;
            if (FnIndexOf.isBoolean(cmptype, (AnyType)at)) {
                XSBoolean boolat = (XSBoolean)cmptype;
                if (boolat.eq(at, dc)) {
                    rb.add(new XSInteger(BigInteger.valueOf(index)));
                }
            } else if (FnIndexOf.isNumeric(cmptype, (AnyType)at)) {
                NumericType numericat = (NumericType)at;
                if (numericat.eq(cmptype, dc)) {
                    rb.add(new XSInteger(BigInteger.valueOf(index)));
                }
            } else if (FnIndexOf.isDuration(cmptype, (AnyType)at)) {
                XSDuration durat = (XSDuration)at;
                if (durat.eq(cmptype, dc)) {
                    rb.add(new XSInteger(BigInteger.valueOf(index)));
                }
            } else if (at instanceof QName && cmptype instanceof QName) {
                QName qname = (QName)at;
                if (qname.eq(cmptype, dc)) {
                    rb.add(new XSInteger(BigInteger.valueOf(index)));
                }
            } else if (FnIndexOf.needsStringComparison(cmptype, (AnyType)at) && FnCompare.compare_string(collationUri, xstr1 = new XSString(cmptype.getStringValue()), itemStr = new XSString(at.getStringValue()), dc).equals(BigInteger.ZERO)) {
                rb.add(new XSInteger(BigInteger.valueOf(index)));
            }
            ++index;
        }
        return rb.getSequence();
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(AnyType.class, 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(AnyAtomicType.class, 0));
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(arg);
        }
        return _expected_args;
    }
}

