/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class FileUtil {
    public static boolean isXMLFile(IFile file) {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType[] types = contentTypeManager.findContentTypesFor(file.getName());
        IContentType xmlContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType illformedXML = contentTypeManager.getContentType("org.eclipse.wst.xml.core.xmlsource");
        IContentType[] iContentTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType.isKindOf(xmlContentType) || contentType.isKindOf(illformedXML)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isXSLFile(IFile file) {
        IContentType[] types;
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType xslContentType = contentTypeManager.getContentType("org.eclipse.wst.xml.core.xslsource");
        IContentType[] iContentTypeArray = types = contentTypeManager.findContentTypesFor(file.getName());
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (contentType.equals(xslContentType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

