/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;

public class TestReconcilerXML
extends TestCase {
    private final String PROJECT_NAME = "TestReconcilerXML";
    private final String FILE_NAME = "TestReconcilerXMLfile.xml";
    private final String ANNOTATION_ERROR = "org.eclipse.wst.sse.ui.temp.error";
    private final String ANNOTATION_WARNING = "org.eclipse.wst.sse.ui.temp.warning";
    private static IEditorPart fEditor;
    private static IFile fFile;
    private static boolean fIsSetup;
    private boolean fReconcilerPref;

    static {
        fIsSetup = false;
    }

    public TestReconcilerXML() {
        super("TestReconcilerXML");
    }

    protected void setUp() throws Exception {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage page;
        if (!fIsSetup) {
            this.createProject("TestReconcilerXML");
            fFile = this.getOrCreateFile("TestReconcilerXML/TestReconcilerXMLfile.xml");
            fIsSetup = true;
        }
        if (fIsSetup && fEditor == null && !((fEditor = IDE.openEditor((IWorkbenchPage)(page = (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()), (IFile)fFile, (boolean)true, (boolean)true)) instanceof XMLMultiPageEditorPart) && !(fEditor instanceof StructuredTextEditor)) {
            TestReconcilerXML.assertTrue((String)"Unable to open structured text editor", (boolean)false);
        }
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        this.fReconcilerPref = store.getBoolean(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
        if (!this.fReconcilerPref) {
            store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, true);
        }
    }

    protected void tearDown() throws Exception {
        IPreferenceStore store = SSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, this.fReconcilerPref);
        if (fEditor != null) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            page.closeEditor(fEditor, false);
            TestReconcilerXML.assertTrue((String)"Unable to close editor", (boolean)true);
            fEditor = null;
        }
    }

    private void createProject(String projName) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private IFile getOrCreateFile(String filePath) {
        IFile blankFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (blankFile != null && !blankFile.exists()) {
            try {
                blankFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return blankFile;
    }

    public void testWellFormed() {
        IDocument doc = (IDocument)fEditor.getAdapter(IDocument.class);
        doc.set("<html><body><h1>Title</h1></body></html>");
        ITextEditor textEditor = (ITextEditor)fEditor.getAdapter(ITextEditor.class);
        IAnnotationModel annoModel = textEditor.getDocumentProvider().getAnnotationModel((Object)fEditor.getEditorInput());
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        try {
            Thread.sleep(5000L);
            Iterator iter = annoModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation anno = (Annotation)iter.next();
                String annoType = anno.getType();
                if (!annotationAccess.isSubtype((Object)annoType, (Object)"org.eclipse.wst.sse.ui.temp.error") && !annotationAccess.isSubtype((Object)annoType, (Object)"org.eclipse.wst.sse.ui.temp.warning")) continue;
                TestReconcilerXML.assertTrue((String)("testReconciler: Unexpected initial annotations" + anno.getText()), (anno.getText().indexOf("No grammar constraints") > -1 ? 1 : 0) != 0);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void testIllFormedNoCloseBracket() {
        IDocument doc = (IDocument)fEditor.getAdapter(IDocument.class);
        doc.set("<html><body><h1>Title</h1></body></html>");
        ITextEditor textEditor = (ITextEditor)fEditor.getAdapter(ITextEditor.class);
        IAnnotationModel annoModel = textEditor.getDocumentProvider().getAnnotationModel((Object)fEditor.getEditorInput());
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        try {
            doc.replace(6, 6, "<body ");
            Thread.sleep(5000L);
            boolean errorFound = false;
            Iterator iter = annoModel.getAnnotationIterator();
            StringBuffer buffer = new StringBuffer();
            while (iter.hasNext()) {
                Annotation anno = (Annotation)iter.next();
                String annoType = anno.getType();
                if (!annotationAccess.isSubtype((Object)annoType, (Object)"org.eclipse.wst.sse.ui.temp.error") && !annotationAccess.isSubtype((Object)annoType, (Object)"org.eclipse.wst.sse.ui.temp.warning")) continue;
                buffer.append("\n");
                buffer.append(anno.getText());
                errorFound = true;
            }
            TestReconcilerXML.assertTrue((String)("testReconciler: Did not find expected errors in: " + doc.get() + buffer.toString()), (boolean)errorFound);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void testIllFormedNoAttrValue() {
        IDocument doc = (IDocument)fEditor.getAdapter(IDocument.class);
        doc.set("<html><body><h1>Title</h1></body></html>");
        ITextEditor textEditor = (ITextEditor)fEditor.getAdapter(ITextEditor.class);
        IAnnotationModel annoModel = textEditor.getDocumentProvider().getAnnotationModel((Object)fEditor.getEditorInput());
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        try {
            doc.replace(6, 6, "<body hello>");
            Thread.sleep(5000L);
            boolean errorFound = false;
            Iterator iter = annoModel.getAnnotationIterator();
            StringBuffer buffer = new StringBuffer();
            while (iter.hasNext()) {
                Annotation anno = (Annotation)iter.next();
                String annoType = anno.getType();
                if (!annotationAccess.isSubtype((Object)annoType, (Object)"org.eclipse.wst.sse.ui.temp.error") && !annotationAccess.isSubtype((Object)annoType, (Object)"org.eclipse.wst.sse.ui.temp.warning")) continue;
                buffer.append("\n");
                buffer.append(anno.getText());
                errorFound = true;
            }
            TestReconcilerXML.assertTrue((String)("testReconciler: Did not find expected errors in: " + doc.get() + buffer), (boolean)errorFound);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

