/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.el.DefaultDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.internal.symbols.ResourceBundleMapSourceFactory;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.osgi.framework.Bundle;

public class TestDefaultPropertyResolver
extends TestCase {
    private static final int NUM_PROPERTIES_TEST_BEAN_1 = 6;
    private JDTTestEnvironment _jdtTestEnvironment;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;
    private IType _testBean1Type;
    private IType _testMapBean1Type;
    private IType _testBean2Type;
    private IType _testBean3Type;
    private IType _testBeanWithMapProp;
    private IType _testListBeanType;
    private IType _testBeanWithListPropType;
    private IType _testBeanWithGenericProperties;
    private static final String SRC_FOLDER_NAME = "src";
    private static final String PACKAGE_NAME = "com.test";
    private static final String TESTBEAN1_NAME = "TestBean1";
    private static final String TESTBEAN2_NAME = "TestBean2";
    private static final String TESTBEAN3_NAME = "TestBean3";
    private static final String MAPBEAN_NAME = "MapBean";
    private static final String BEANWITHMAPPROP_NAME = "BeanWithMapProp";
    private static final String LISTBEAN_NAME = "ListBean";
    private static final String BEANWITHLISTPROP_NAME = "BeanWithListProp";
    private static final String BEANWITHGENERICPROP_NAME = "TestBeanWithGenericProperties";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestDefaultPropertyResolver_" + this.getName());
        projectTestEnvironment.createProject(false);
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        this._jdtTestEnvironment.addResourceFile(SRC_FOLDER_NAME, (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/TestBean1.java.data", (String)TESTBEAN1_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testBean1Type);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/MapBean.java.data", (String)MAPBEAN_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testMapBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.MapBean");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testMapBean1Type);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/TestBean2.java.data", (String)TESTBEAN2_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBean2Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean2");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testBean2Type);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/TestBean3.java.data", (String)TESTBEAN3_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBean3Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean3");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testBean3Type);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/BeanWithMapProp.java.data", (String)BEANWITHMAPPROP_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBeanWithMapProp = this._jdtTestEnvironment.getJavaProject().findType("com.test.BeanWithMapProp");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testBeanWithMapProp);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/ListBean.java.data", (String)LISTBEAN_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testListBeanType = this._jdtTestEnvironment.getJavaProject().findType("com.test.ListBean");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testListBeanType);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/BeanWithListProp.java.data", (String)BEANWITHLISTPROP_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBeanWithListPropType = this._jdtTestEnvironment.getJavaProject().findType("com.test.BeanWithListProp");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testBeanWithListPropType);
        JSFTestUtil.loadSourceClass((Bundle)DesignTimeTestsPlugin.getDefault().getBundle(), (String)"/testdata/TestBeanWithGenericProperties.java.data", (String)BEANWITHGENERICPROP_NAME, (String)SRC_FOLDER_NAME, (String)PACKAGE_NAME, (JDTTestEnvironment)this._jdtTestEnvironment);
        this._testBeanWithGenericProperties = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBeanWithGenericProperties");
        TestDefaultPropertyResolver.assertNotNull((Object)this._testBeanWithGenericProperties);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            IProject project = this._jdtTestEnvironment.getJavaProject().getProject();
            project.close(null);
            project.delete(true, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
    }

    public void testSanity() {
        JDTBeanIntrospector beanIntrospector = JDTBeanIntrospector.forType((IType)this._testBean1Type);
        Map props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)6, (int)props.size());
        TestDefaultPropertyResolver.assertTrue((boolean)props.containsKey("stringProp1"));
        TestDefaultPropertyResolver.assertTrue((boolean)props.containsKey("booleanIsProp1"));
        beanIntrospector = JDTBeanIntrospector.forType((IType)this._testMapBean1Type);
        props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)2, (int)props.size());
        beanIntrospector = JDTBeanIntrospector.forType((IType)this._testBean2Type);
        props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)2, (int)props.size());
        beanIntrospector = JDTBeanIntrospector.forType((IType)this._testBean3Type);
        props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)2, (int)props.size());
        beanIntrospector = JDTBeanIntrospector.forType((IType)this._testBeanWithMapProp);
        props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)2, (int)props.size());
        beanIntrospector = JDTBeanIntrospector.forType((IType)this._testListBeanType);
        props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)3, (int)props.size());
        beanIntrospector = JDTBeanIntrospector.forType((IType)this._testBeanWithListPropType);
        props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)2, (int)props.size());
        beanIntrospector = JDTBeanIntrospector.forType((IType)this._testBeanWithGenericProperties);
        props = beanIntrospector.getProperties();
        TestDefaultPropertyResolver.assertEquals((int)3, (int)props.size());
    }

    public void testBeanInstanceSymbol() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("myBean");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testBean1Type);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)6, (int)properties.length);
        HashMap<String, ISymbol> checkProps = new HashMap<String, ISymbol>();
        ISymbol[] iSymbolArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol propSymbol = iSymbolArray[n2];
            checkProps.put(propSymbol.getName(), propSymbol);
            ++n2;
        }
        TestDefaultPropertyResolver.assertTrue((boolean)checkProps.containsKey("stringProp1"));
        TestDefaultPropertyResolver.assertTrue((boolean)checkProps.containsKey("booleanIsProp1"));
        ISymbol stringProp1 = propResolver.getProperty((ISymbol)symbol, (Object)"stringProp1");
        TestDefaultPropertyResolver.assertNotNull((Object)stringProp1);
        TestDefaultPropertyResolver.assertTrue((boolean)(stringProp1 instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertTrue((boolean)((IPropertySymbol)stringProp1).getTypeDescriptor().getTypeSignature().equals("Ljava.lang.String;"));
        IPropertySymbol mapStringProp1 = (IPropertySymbol)checkProps.get("stringProp1");
        TestDefaultPropertyResolver.assertEquals((String)((IPropertySymbol)stringProp1).getTypeDescriptor().getTypeSignature(), (String)mapStringProp1.getTypeDescriptor().getTypeSignature());
        ISymbol booleanIsProp = propResolver.getProperty((ISymbol)symbol, (Object)"booleanIsProp1");
        TestDefaultPropertyResolver.assertNotNull((Object)booleanIsProp);
        TestDefaultPropertyResolver.assertTrue((boolean)(booleanIsProp instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertTrue((boolean)((IPropertySymbol)booleanIsProp).getTypeDescriptor().getTypeSignature().equals("Z"));
        IPropertySymbol mapBooleanProp = (IPropertySymbol)checkProps.get("booleanIsProp1");
        TestDefaultPropertyResolver.assertEquals((String)((IPropertySymbol)booleanIsProp).getTypeDescriptor().getTypeSignature(), (String)mapBooleanProp.getTypeDescriptor().getTypeSignature());
    }

    public void testMapBeanInstanceSymbol() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("myMapBean");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testMapBean1Type);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)0, (int)properties.length);
        int i = 0;
        while (i < 25) {
            String unconstrainedPropName = "someName" + i * 7 + "withNonSequentialNumber" + i * 11;
            ISymbol someProperty1 = propResolver.getProperty((ISymbol)symbol, (Object)unconstrainedPropName);
            TestDefaultPropertyResolver.assertNotNull((Object)someProperty1);
            TestDefaultPropertyResolver.assertEquals((String)unconstrainedPropName, (String)someProperty1.getName());
            TestDefaultPropertyResolver.assertTrue((boolean)(someProperty1 instanceof IPropertySymbol));
            TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.Object;", (String)((IPropertySymbol)someProperty1).getTypeDescriptor().getTypeSignature());
            ++i;
        }
    }

    public void testComponentBeanInstanceSymbol() {
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName("myComponentSymbol");
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        HashMap<String, String> mapSource = new HashMap<String, String>();
        mapSource.put("prop1", "propValue1");
        mapSource.put("prop2", "propValue2");
        mapSource.put("dotted.property", "dottedPropertyValue");
        typeDesc.setMapSource(mapSource);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)3, (int)properties.length);
        int j = 0;
        while (j < 10) {
            ISymbol[] iSymbolArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                ISymbol propertie = iSymbolArray[n2];
                TestDefaultPropertyResolver.assertTrue((mapSource.containsKey(propertie.getName()) || propertie.getName().startsWith("dotted") ? 1 : 0) != 0);
                TestDefaultPropertyResolver.assertTrue((boolean)(propertie instanceof IPropertySymbol));
                IPropertySymbol propSymbol = (IPropertySymbol)propertie;
                ISymbol symbolById = propResolver.getProperty((ISymbol)symbol, (Object)propSymbol.getName());
                TestDefaultPropertyResolver.assertEquals((String)propSymbol.getName(), (String)symbolById.getName());
                TestDefaultPropertyResolver.assertEquals((String)propSymbol.getTypeDescriptor().getTypeSignature(), (String)((IObjectSymbol)symbolById).getTypeDescriptor().getTypeSignature());
                ++n2;
            }
            ++j;
        }
        ISymbol symbolById = propResolver.getProperty((ISymbol)symbol, (Object)"dotted");
        TestDefaultPropertyResolver.assertNotNull((Object)symbolById);
        TestDefaultPropertyResolver.assertTrue((boolean)((IPropertySymbol)symbolById).isIntermediate());
        ISymbol dottedProp = propResolver.getProperty(symbolById, (Object)"property");
        TestDefaultPropertyResolver.assertTrue((boolean)(dottedProp instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.String;", (String)((IPropertySymbol)dottedProp).getTypeDescriptor().getTypeSignature());
    }

    public void testBeanPropertyOnBeanProperty() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("myBean2");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testBean2Type);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)2, (int)properties.length);
        HashMap<String, IPropertySymbol> gotProps = new HashMap<String, IPropertySymbol>();
        ISymbol[] iSymbolArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol propertie = iSymbolArray[n2];
            IPropertySymbol propSymbol = (IPropertySymbol)propertie;
            TestDefaultPropertyResolver.assertEquals((String)propSymbol.getTypeDescriptor().getTypeSignature(), (String)((IObjectSymbol)propResolver.getProperty((ISymbol)symbol, (Object)propSymbol.getName())).getTypeDescriptor().getTypeSignature());
            gotProps.put(propSymbol.getName(), propSymbol);
            ++n2;
        }
        TestDefaultPropertyResolver.assertTrue((boolean)gotProps.containsKey("myBean3"));
        TestDefaultPropertyResolver.assertTrue((boolean)gotProps.containsKey("class"));
        IBeanInstanceSymbol curBase = symbol;
        int i = 0;
        while (i < 10) {
            ISymbol[] properties2 = propResolver.getAllProperties((ISymbol)curBase);
            TestDefaultPropertyResolver.assertEquals((int)2, (int)properties2.length);
            IPropertySymbol propSymbol = (IPropertySymbol)this.findSymbol(i % 2 == 0 ? "myBean3" : "myBean2", properties2);
            if (i % 2 == 0) {
                TestDefaultPropertyResolver.assertEquals((String)"myBean3", (String)propSymbol.getName());
                TestDefaultPropertyResolver.assertEquals((String)"Lcom.test.TestBean3;", (String)propSymbol.getTypeDescriptor().getTypeSignature());
                curBase = propSymbol;
            } else {
                TestDefaultPropertyResolver.assertEquals((String)"myBean2", (String)propSymbol.getName());
                TestDefaultPropertyResolver.assertEquals((String)"Lcom.test.TestBean2;", (String)propSymbol.getTypeDescriptor().getTypeSignature());
                curBase = propSymbol;
            }
            curBase = propSymbol;
            ++i;
        }
    }

    public void testBeanWithMapProperty() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName(BEANWITHMAPPROP_NAME);
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testBeanWithMapProp);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)2, (int)properties.length);
        TestDefaultPropertyResolver.assertNotNull((Object)this.findSymbol("mapProp", properties));
        TestDefaultPropertyResolver.assertEquals((String)this.findSymbol("mapProp", properties).getName(), (String)propResolver.getProperty((ISymbol)symbol, (Object)"mapProp").getName());
        IPropertySymbol mapProp = (IPropertySymbol)propResolver.getProperty((ISymbol)symbol, (Object)"mapProp");
        TestDefaultPropertyResolver.assertEquals((String)"Lcom.test.MapBean;", (String)mapProp.getTypeDescriptor().getTypeSignature());
        properties = propResolver.getAllProperties((ISymbol)mapProp);
        TestDefaultPropertyResolver.assertEquals((int)0, (int)properties.length);
        IPropertySymbol unboundedProp = (IPropertySymbol)propResolver.getProperty((ISymbol)mapProp, (Object)"foo");
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.Object;", (String)unboundedProp.getTypeDescriptor().getTypeSignature());
    }

    public void testBeanWithArrayProperty() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("BeanWithArrayProp");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testBean1Type);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol arrayOfStringsProperty = propResolver.getProperty((ISymbol)symbol, (Object)"stringArrayProperty");
        TestDefaultPropertyResolver.assertTrue((boolean)(arrayOfStringsProperty instanceof IPropertySymbol));
        IPropertySymbol arrayOfStringsPropertySymbol = (IPropertySymbol)arrayOfStringsProperty;
        TestDefaultPropertyResolver.assertEquals((String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)1), (String)arrayOfStringsPropertySymbol.getTypeDescriptor().getTypeSignature());
        TestDefaultPropertyResolver.assertTrue((boolean)arrayOfStringsPropertySymbol.getTypeDescriptor().isArray());
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.String;", (String)arrayOfStringsPropertySymbol.getTypeDescriptor().getArrayElement().getTypeDescriptor().getTypeSignature());
        ISymbol arrayElement = propResolver.getProperty((ISymbol)arrayOfStringsPropertySymbol, 0);
        TestDefaultPropertyResolver.assertTrue((boolean)(arrayElement instanceof IObjectSymbol));
        IObjectSymbol arrayElementSymbol = (IObjectSymbol)arrayElement;
        TestDefaultPropertyResolver.assertNotNull((Object)((IJavaTypeDescriptor2)arrayElementSymbol.getTypeDescriptor()).getType());
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.String;", (String)arrayElementSymbol.getTypeDescriptor().getTypeSignature());
        ISymbol arrayOfIntProperty = propResolver.getProperty((ISymbol)symbol, (Object)"intArrayProperty");
        TestDefaultPropertyResolver.assertTrue((boolean)(arrayOfIntProperty instanceof IPropertySymbol));
        IPropertySymbol arrayOfIntPropertySymbol = (IPropertySymbol)arrayOfIntProperty;
        TestDefaultPropertyResolver.assertEquals((String)Signature.createArraySignature((String)"I", (int)1), (String)arrayOfIntPropertySymbol.getTypeDescriptor().getTypeSignature());
        TestDefaultPropertyResolver.assertTrue((boolean)arrayOfIntPropertySymbol.getTypeDescriptor().isArray());
        TestDefaultPropertyResolver.assertEquals((String)"I", (String)arrayOfIntPropertySymbol.getTypeDescriptor().getArrayElement().getTypeDescriptor().getTypeSignature());
        arrayElement = propResolver.getProperty((ISymbol)arrayOfIntPropertySymbol, 0);
        TestDefaultPropertyResolver.assertTrue((boolean)(arrayElement instanceof IObjectSymbol));
        arrayElementSymbol = (IObjectSymbol)arrayElement;
        TestDefaultPropertyResolver.assertNull((Object)((IJavaTypeDescriptor2)arrayElementSymbol.getTypeDescriptor()).getType());
        TestDefaultPropertyResolver.assertEquals((String)"I", (String)arrayElementSymbol.getTypeDescriptor().getTypeSignature());
        arrayOfIntProperty = propResolver.getProperty((ISymbol)symbol, (Object)"arrayOfArrayOfStringProperty");
        TestDefaultPropertyResolver.assertTrue((boolean)(arrayOfIntProperty instanceof IPropertySymbol));
        arrayOfIntPropertySymbol = (IPropertySymbol)arrayOfIntProperty;
        TestDefaultPropertyResolver.assertEquals((String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)2), (String)arrayOfIntPropertySymbol.getTypeDescriptor().getTypeSignature());
        TestDefaultPropertyResolver.assertTrue((boolean)arrayOfIntPropertySymbol.getTypeDescriptor().isArray());
        TestDefaultPropertyResolver.assertEquals((String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)1), (String)arrayOfIntPropertySymbol.getTypeDescriptor().getArrayElement().getTypeDescriptor().getTypeSignature());
        arrayElement = propResolver.getProperty((ISymbol)arrayOfIntPropertySymbol, 0);
        TestDefaultPropertyResolver.assertTrue((boolean)(arrayElement instanceof IObjectSymbol));
        arrayElementSymbol = (IObjectSymbol)arrayElement;
        TestDefaultPropertyResolver.assertNotNull((Object)((IJavaTypeDescriptor2)arrayElementSymbol.getTypeDescriptor()).getType());
        TestDefaultPropertyResolver.assertEquals((String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)1), (String)arrayElementSymbol.getTypeDescriptor().getTypeSignature());
        TestDefaultPropertyResolver.assertTrue((boolean)arrayElementSymbol.getTypeDescriptor().isArray());
        ISymbol arrayElementElement = propResolver.getProperty((ISymbol)arrayElementSymbol, 0);
        TestDefaultPropertyResolver.assertTrue((boolean)(arrayElementElement instanceof IObjectSymbol));
        IObjectSymbol arrayElementElementSymbol = (IObjectSymbol)arrayElementElement;
        TestDefaultPropertyResolver.assertNotNull((Object)((IJavaTypeDescriptor2)arrayElementElementSymbol.getTypeDescriptor()).getType());
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.String;", (String)arrayElementElementSymbol.getTypeDescriptor().getTypeSignature());
    }

    public void testListBeanInstanceSymbol() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("myListBean");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testListBeanType);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)0, (int)properties.length);
        int i = 0;
        while (i < 25) {
            ISymbol someProperty1 = propResolver.getProperty((ISymbol)symbol, i);
            TestDefaultPropertyResolver.assertNotNull((Object)someProperty1);
            TestDefaultPropertyResolver.assertTrue((boolean)(someProperty1 instanceof IPropertySymbol));
            TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.Object;", (String)((IPropertySymbol)someProperty1).getTypeDescriptor().getTypeSignature());
            ++i;
        }
    }

    public void testBeanWithListProperty() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("beanWithListProp");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testBeanWithListPropType);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)2, (int)properties.length);
        TestDefaultPropertyResolver.assertNotNull((Object)this.findSymbol("listProp", properties));
        TestDefaultPropertyResolver.assertEquals((String)this.findSymbol("listProp", properties).getName(), (String)propResolver.getProperty((ISymbol)symbol, (Object)"listProp").getName());
        IPropertySymbol listProp = (IPropertySymbol)propResolver.getProperty((ISymbol)symbol, (Object)"listProp");
        TestDefaultPropertyResolver.assertEquals((String)"Lcom.test.ListBean;", (String)listProp.getTypeDescriptor().getTypeSignature());
        properties = propResolver.getAllProperties((ISymbol)listProp);
        TestDefaultPropertyResolver.assertEquals((int)0, (int)properties.length);
        IPropertySymbol unboundedProp = (IPropertySymbol)propResolver.getProperty((ISymbol)listProp, 0);
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.Object;", (String)unboundedProp.getTypeDescriptor().getTypeSignature());
        TestDefaultPropertyResolver.assertNull((Object)propResolver.getProperty((ISymbol)listProp, (Object)"anyKey"));
    }

    public void testGenericListProperty() {
        IBeanInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        symbol.setName("beanWithListProp");
        IJavaTypeDescriptor2 typeDesc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        typeDesc.setType(this._testBeanWithGenericProperties);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol[] properties = propResolver.getAllProperties((ISymbol)symbol);
        TestDefaultPropertyResolver.assertEquals((int)3, (int)properties.length);
        TestDefaultPropertyResolver.assertNotNull((Object)this.findSymbol("listOfStrings", properties));
        TestDefaultPropertyResolver.assertEquals((String)this.findSymbol("listOfStrings", properties).getName(), (String)propResolver.getProperty((ISymbol)symbol, (Object)"listOfStrings").getName());
        IPropertySymbol listProp = (IPropertySymbol)propResolver.getProperty((ISymbol)symbol, (Object)"listOfStrings");
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.util.List;", (String)listProp.getTypeDescriptor().getTypeSignature());
        properties = propResolver.getAllProperties((ISymbol)listProp);
        TestDefaultPropertyResolver.assertEquals((int)0, (int)properties.length);
        IPropertySymbol unboundedProp = (IPropertySymbol)propResolver.getProperty((ISymbol)listProp, 0);
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.String;", (String)unboundedProp.getTypeDescriptor().getTypeSignature());
    }

    public void testBoundedTypeDescriptor() {
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName("componentSymbol");
        IBoundedMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
        typeDesc.setMapSource(new HashMap());
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol propSymbol = propResolver.getProperty((ISymbol)symbol, (Object)"anyProp");
        TestDefaultPropertyResolver.assertNotNull((Object)propSymbol);
        TestDefaultPropertyResolver.assertTrue((boolean)(propSymbol instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertEquals((String)"Ljava.lang.Object;", (String)((IPropertySymbol)propSymbol).getTypeDescriptor().getTypeSignature());
    }

    public void testDottedPropertyNames() throws Exception {
        this.checkDottedBundleNames();
    }

    private void checkDottedBundleNames() throws Exception {
        Map map = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject(), (String)"bundles.bundle1");
        TestDefaultPropertyResolver.assertNotNull((Object)map);
        TestDefaultPropertyResolver.assertEquals((int)3, (int)map.size());
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource(map);
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName("dottedMapSource");
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        DefaultDTPropertyResolver propResolver = new DefaultDTPropertyResolver();
        propResolver.setProject(this._jdtTestEnvironment.getProjectEnvironment().getTestProject());
        ISymbol oneDot = propResolver.getProperty((ISymbol)symbol, (Object)"one");
        TestDefaultPropertyResolver.assertNotNull((Object)oneDot);
        TestDefaultPropertyResolver.assertTrue((boolean)(oneDot instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertTrue((boolean)((IPropertySymbol)oneDot).isIntermediate());
        oneDot = propResolver.getProperty((ISymbol)symbol, (Object)"one.dot");
        TestDefaultPropertyResolver.assertNotNull((Object)oneDot);
        TestDefaultPropertyResolver.assertTrue((boolean)(oneDot instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertFalse((boolean)((IPropertySymbol)oneDot).isIntermediate());
        ISymbol twoDots = propResolver.getProperty((ISymbol)symbol, (Object)"two");
        TestDefaultPropertyResolver.assertNotNull((Object)twoDots);
        TestDefaultPropertyResolver.assertTrue((boolean)(twoDots instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertTrue((boolean)((IPropertySymbol)twoDots).isIntermediate());
        twoDots = propResolver.getProperty((ISymbol)symbol, (Object)"two.dot");
        TestDefaultPropertyResolver.assertNotNull((Object)twoDots);
        TestDefaultPropertyResolver.assertTrue((boolean)(twoDots instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertTrue((boolean)((IPropertySymbol)twoDots).isIntermediate());
        twoDots = propResolver.getProperty((ISymbol)symbol, (Object)"two.dot.property");
        TestDefaultPropertyResolver.assertNotNull((Object)twoDots);
        TestDefaultPropertyResolver.assertTrue((boolean)(twoDots instanceof IPropertySymbol));
        TestDefaultPropertyResolver.assertFalse((boolean)((IPropertySymbol)twoDots).isIntermediate());
    }

    private ISymbol findSymbol(String name, ISymbol[] symbols) {
        ISymbol[] iSymbolArray = symbols;
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol symbol = iSymbolArray[n2];
            if (symbol.getName().equals(name)) {
                return symbol;
            }
            ++n2;
        }
        return null;
    }
}

