/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.VirtualTable;
import org.eclipse.jpt.jpa.core.context.VirtualUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmVirtualTable<P extends JpaContextModel, PA extends Table.ParentAdapter<P>, T extends Table>
extends AbstractOrmXmlContextModel<P>
implements VirtualTable {
    protected final PA parentAdapter;
    protected final T overriddenTable;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final AbstractJpaContextModel.ContextListContainer<VirtualUniqueConstraint, UniqueConstraint> uniqueConstraintContainer;

    protected AbstractOrmVirtualTable(PA parentAdapter, T overriddenTable) {
        super(parentAdapter.getTableParent());
        this.parentAdapter = parentAdapter;
        this.overriddenTable = overriddenTable;
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setSpecifiedName(this.buildSpecifiedName());
        this.setDefaultName(this.buildDefaultName());
        this.setSpecifiedSchema(this.buildSpecifiedSchema());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setSpecifiedCatalog(this.buildSpecifiedCatalog());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateUniqueConstraints(monitor);
    }

    public T getOverriddenTable() {
        return this.overriddenTable;
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    protected void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getOverriddenTable().getSpecifiedName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    protected void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        return this.getOverriddenTable().getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    protected void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        return this.getOverriddenTable().getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    public ListIterable<VirtualUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer;
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.size();
    }

    @Override
    public VirtualUniqueConstraint getUniqueConstraint(int index) {
        return (VirtualUniqueConstraint)this.uniqueConstraintContainer.get(index);
    }

    protected void updateUniqueConstraints(IProgressMonitor monitor) {
        this.uniqueConstraintContainer.update(monitor);
    }

    protected ListIterable<UniqueConstraint> getOverriddenUniqueConstraints() {
        return new SuperListIterableWrapper(this.getOverriddenTable().getUniqueConstraints());
    }

    protected void moveUniqueConstraint(int index, VirtualUniqueConstraint constraint) {
        this.uniqueConstraintContainer.move(index, constraint);
    }

    protected VirtualUniqueConstraint addUniqueConstraint(int index, UniqueConstraint uniqueConstraint) {
        return (VirtualUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, uniqueConstraint);
    }

    protected VirtualUniqueConstraint buildUniqueConstraint(UniqueConstraint uniqueConstraint) {
        return this.getContextModelFactory().buildOrmVirtualUniqueConstraint(this, uniqueConstraint);
    }

    protected void removeUniqueConstraint(VirtualUniqueConstraint constraint) {
        this.uniqueConstraintContainer.remove(constraint);
    }

    protected AbstractJpaContextModel.ContextListContainer<VirtualUniqueConstraint, UniqueConstraint> buildUniqueConstraintContainer() {
        return this.buildVirtualContextListContainer("uniqueConstraints", new UniqueConstraintContainerAdapter());
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    protected boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    protected boolean hasResolvedCatalog() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildTableValidator().validate(messages, reporter);
    }

    protected JpaValidator buildTableValidator() {
        return this.parentAdapter.buildTableValidator(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        return ((JpaContextModel)this.parent).getValidationTextRange();
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.getValidationTextRange();
    }

    @Override
    public TextRange getSchemaValidationTextRange() {
        return this.getValidationTextRange();
    }

    @Override
    public TextRange getCatalogValidationTextRange() {
        return this.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedName((String[])new String[]{this.getCatalog(), this.getSchema(), this.getName()});
    }

    public class UniqueConstraintContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<VirtualUniqueConstraint, UniqueConstraint> {
        public UniqueConstraintContainerAdapter() {
            super(AbstractOrmVirtualTable.this);
        }

        @Override
        public VirtualUniqueConstraint buildContextElement(UniqueConstraint resourceElement) {
            return AbstractOrmVirtualTable.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        public ListIterable<UniqueConstraint> getResourceElements() {
            return AbstractOrmVirtualTable.this.getOverriddenUniqueConstraints();
        }

        @Override
        public UniqueConstraint extractResourceElement(VirtualUniqueConstraint contextElement) {
            return contextElement.getOverriddenUniqueConstraint();
        }
    }
}

