/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.datatype.business;

import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.Contacts;
import org.uddi4j.datatype.service.BusinessServices;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.DiscoveryURLs;
import org.uddi4j.util.IdentifierBag;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BusinessEntity
extends UDDIElement {
    public static final String UDDI_TAG = "businessEntity";
    protected Element base = null;
    String businessKey = null;
    String operator = null;
    String authorizedName = null;
    DiscoveryURLs discoveryURLs = null;
    Contacts contacts = null;
    BusinessServices businessServices = null;
    IdentifierBag identifierBag = null;
    CategoryBag categoryBag = null;
    Vector description = new Vector();
    Vector nameVector = new Vector();

    public BusinessEntity() {
    }

    public BusinessEntity(String businessKey, String name) {
        this.businessKey = businessKey;
        this.nameVector.addElement(new Name(name));
    }

    public BusinessEntity(String businessKey, String name, String lang) {
        this.businessKey = businessKey;
        this.nameVector.addElement(new Name(name, lang));
    }

    public BusinessEntity(Element base) throws UDDIException {
        super(base);
        this.businessKey = base.getAttribute("businessKey");
        this.operator = this.getAttr(base, "operator");
        this.authorizedName = this.getAttr(base, "authorizedName");
        NodeList nl = null;
        nl = this.getChildElementsByTagName(base, "discoveryURLs");
        if (nl.getLength() > 0) {
            this.discoveryURLs = new DiscoveryURLs((Element)nl.item(0));
        }
        nl = this.getChildElementsByTagName(base, "name");
        int i = 0;
        while (i < nl.getLength()) {
            this.nameVector.addElement(new Name((Element)nl.item(i)));
            ++i;
        }
        nl = this.getChildElementsByTagName(base, "contacts");
        if (nl.getLength() > 0) {
            this.contacts = new Contacts((Element)nl.item(0));
        }
        if ((nl = this.getChildElementsByTagName(base, "businessServices")).getLength() > 0) {
            this.businessServices = new BusinessServices((Element)nl.item(0));
        }
        if ((nl = this.getChildElementsByTagName(base, "identifierBag")).getLength() > 0) {
            this.identifierBag = new IdentifierBag((Element)nl.item(0));
        }
        if ((nl = this.getChildElementsByTagName(base, "categoryBag")).getLength() > 0) {
            this.categoryBag = new CategoryBag((Element)nl.item(0));
        }
        nl = this.getChildElementsByTagName(base, "description");
        i = 0;
        while (i < nl.getLength()) {
            this.description.addElement(new Description((Element)nl.item(i)));
            ++i;
        }
    }

    private String getAttr(Element base, String attrname) {
        if (base.getAttributeNode(attrname) != null && base.getAttributeNode(attrname).getSpecified()) {
            return base.getAttribute(attrname);
        }
        return null;
    }

    public void setBusinessKey(String s) {
        this.businessKey = s;
    }

    public void setOperator(String s) {
        this.operator = s;
    }

    public void setAuthorizedName(String s) {
        this.authorizedName = s;
    }

    public void setDiscoveryURLs(DiscoveryURLs s) {
        this.discoveryURLs = s;
    }

    public void setName(Name s) {
        this.setDefaultName(s);
    }

    public void setName(String s) {
        this.setDefaultNameString(s, null);
    }

    public void setDefaultName(Name name) {
        if (this.nameVector.size() > 0) {
            this.nameVector.setElementAt(name, 0);
        } else {
            this.nameVector.addElement(name);
        }
    }

    public void setDefaultNameString(String value, String lang) {
        Name name = new Name(value, lang);
        if (this.nameVector.size() > 0) {
            this.nameVector.setElementAt(name, 0);
        } else {
            this.nameVector.addElement(name);
        }
    }

    public void setNameVector(Vector s) {
        this.nameVector = s;
    }

    public void setContacts(Contacts s) {
        this.contacts = s;
    }

    public void setBusinessServices(BusinessServices s) {
        this.businessServices = s;
    }

    public void setIdentifierBag(IdentifierBag s) {
        this.identifierBag = s;
    }

    public void setCategoryBag(CategoryBag s) {
        this.categoryBag = s;
    }

    public void setDescriptionVector(Vector s) {
        this.description = s;
    }

    public void setDefaultDescriptionString(String s) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(s), 0);
        } else {
            this.description.addElement(new Description(s));
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public DiscoveryURLs getDiscoveryURLs() {
        return this.discoveryURLs;
    }

    public Name getName() {
        return this.getDefaultName();
    }

    public String getNameString() {
        return this.getDefaultNameString();
    }

    public Name getDefaultName() {
        return (Name)this.nameVector.elementAt(0);
    }

    public String getDefaultNameString() {
        if (this.nameVector.size() > 0) {
            return ((Name)this.nameVector.elementAt(0)).getText();
        }
        return null;
    }

    public Vector getNameVector() {
        return this.nameVector;
    }

    public Contacts getContacts() {
        return this.contacts;
    }

    public BusinessServices getBusinessServices() {
        return this.businessServices;
    }

    public IdentifierBag getIdentifierBag() {
        return this.identifierBag;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description t = (Description)this.description.elementAt(0);
            return t.getText();
        }
        return null;
    }

    public void saveToXML(Element parent) {
        int i;
        this.base = parent.getOwnerDocument().createElementNS(UDDIElement.XMLNS, String.valueOf(UDDIElement.XMLNS_PREFIX) + UDDI_TAG);
        if (this.businessKey != null) {
            this.base.setAttribute("businessKey", this.businessKey);
        }
        if (this.operator != null) {
            this.base.setAttribute("operator", this.operator);
        }
        if (this.authorizedName != null) {
            this.base.setAttribute("authorizedName", this.authorizedName);
        }
        if (this.discoveryURLs != null) {
            this.discoveryURLs.saveToXML(this.base);
        }
        if (this.nameVector != null) {
            i = 0;
            while (i < this.nameVector.size()) {
                ((Name)this.nameVector.elementAt(i)).saveToXML(this.base);
                ++i;
            }
        }
        if (this.description != null) {
            i = 0;
            while (i < this.description.size()) {
                ((Description)this.description.elementAt(i)).saveToXML(this.base);
                ++i;
            }
        }
        if (this.contacts != null) {
            this.contacts.saveToXML(this.base);
        }
        if (this.businessServices != null) {
            this.businessServices.saveToXML(this.base);
        }
        if (this.identifierBag != null) {
            this.identifierBag.saveToXML(this.base);
        }
        if (this.categoryBag != null) {
            this.categoryBag.saveToXML(this.base);
        }
        parent.appendChild(this.base);
    }
}

