/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import junit.framework.TestCase;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.DomTestUtils;
import org.eclipse.jst.ws.jaxws.testutils.dom.WaitingDomUtil;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;

public class ImplicitSeiMethodSynchronizationTests
extends TestCase {
    private TestProject testPrj1;
    private JaxWsWorkspaceResource target;
    private IJavaModel javaModel;
    private IType baseClassWithWsAnnot;
    private IType baseClassWithoutWsAnnot;
    private IType wsClass;
    private IWebServiceProject wsPrj1;
    private IWebService ws1;
    private DomTestUtils util = new DomTestUtils();
    private DomUtil domUtil;
    private static final String ws1ImplName = "com.sap.test.modelsync1.WS1";

    public void setUp() throws Exception {
        this.domUtil = new WaitingDomUtil();
        this.javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.target = new JaxWsWorkspaceResource(this.javaModel){

            public IProjectSelector[] getProjectSelectors() {
                return new IProjectSelector[]{new IProjectSelector(){

                    public boolean approve(IJavaProject prj) {
                        return prj.getElementName().equals(ImplicitSeiMethodSynchronizationTests.this.testPrj1.getJavaProject().getElementName());
                    }
                }};
            }
        };
        this.testPrj1 = new TestProject("TestProject1");
        this.testPrj1.createSourceFolder("src");
        IPackageFragment modelSync1 = this.testPrj1.createPackage("com.sap.test.modelsync1");
        this.baseClassWithoutWsAnnot = this.testPrj1.createType(modelSync1, "BaseClassWithoutWsAnnot.java", "public class BaseClassWithoutWsAnnot {\n@javax.jws.WebMethod public void annotationInBaseNoWSClass(){}\npublic void noAnnotationInBaseNoWSClass(){}\nvoid nonPublicInBaseNoWSClass() {}\n@javax.jws.WebMethod public void toOverride() {}\n@javax.jws.WebMethod(exclude=true) public void excludedPublicInBaseNoWSClass() {}\n}");
        this.baseClassWithWsAnnot = this.testPrj1.createType(modelSync1, "BaseClassWithWsAnnot.java", "@javax.jws.WebService public class BaseClassWithWsAnnot extends BaseClassWithoutWsAnnot {\npublic void noWMAnnoationInBaseWSClass() {}\nvoid nonPublicInBaseWSClass() {}\n@javax.jws.WebMethod(operationName=\"nameInBaseClassWithAnnot\") public void toOverride() {}\n@javax.jws.WebMethod(exclude=true) public void excludedPublicInBaseWSClass() {}\n}");
        this.wsClass = this.testPrj1.createType(modelSync1, "WS1.java", "@javax.jws.WebService(name=\"ImplicitSei1Name\") public class WS1 extends BaseClassWithWsAnnot {\npublic void noWMAnnotationInWSClass();\nvoid nonPublicInWSClass() {}\n@javax.jws.WebMethod(operationName=\"nameInWsClass\") public void toOverride() {}\n@javax.jws.WebMethod(exclude=true) public void excludedPublicInWSClass() {}\n@javax.jws.WebMethod(operationName=\"webName\", exclude=true) public void voidMethodWithNoArgsWithAnnotation(){}\n}");
        JobUtils.waitForJobs();
        this.target.load(null);
        ImplicitSeiMethodSynchronizationTests.assertEquals((String)"One projects were defined but a different number were found in the DOM", (int)1, (int)this.target.getDOM().getWebServiceProjects().size());
        ImplicitSeiMethodSynchronizationTests.assertEquals((int)2, (int)((IWebServiceProject)this.target.getDOM().getWebServiceProjects().get(0)).getWebServices().size());
        this.wsPrj1 = this.domUtil.findProjectByName(this.target.getDOM(), this.testPrj1.getJavaProject().getElementName());
        ImplicitSeiMethodSynchronizationTests.assertNotNull((Object)this.wsPrj1);
        this.ws1 = this.domUtil.findWsByImplName(this.wsPrj1, ws1ImplName);
        ImplicitSeiMethodSynchronizationTests.assertNotNull((Object)this.ws1);
    }

    public void test_methodNoAnnotationSynched() throws JavaModelException {
        IMethod methodElem = this.util.getExistingMethod(this.wsClass, "noWMAnnotationInWSClass", new String[0]);
        IWebMethod wm = this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElem));
        ImplicitSeiMethodSynchronizationTests.assertNotNull((Object)wm);
        ImplicitSeiMethodSynchronizationTests.assertEquals((String)methodElem.getElementName(), (String)wm.getName());
        ImplicitSeiMethodSynchronizationTests.assertTrue((boolean)wm.getParameters().isEmpty());
        ImplicitSeiMethodSynchronizationTests.assertEquals((String)this.calcImplementation(methodElem), (String)wm.getImplementation());
        ImplicitSeiMethodSynchronizationTests.assertFalse((boolean)wm.isExcluded());
    }

    public void test_methodNoAnnotationInParentWithWSAnnotationSynched() throws JavaModelException {
        IMethod methodElem = this.util.getExistingMethod(this.baseClassWithWsAnnot, "noWMAnnoationInBaseWSClass", new String[0]);
        IWebMethod wm = this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElem));
        ImplicitSeiMethodSynchronizationTests.assertNotNull((Object)wm);
        ImplicitSeiMethodSynchronizationTests.assertEquals((String)methodElem.getElementName(), (String)wm.getName());
        ImplicitSeiMethodSynchronizationTests.assertTrue((boolean)wm.getParameters().isEmpty());
        ImplicitSeiMethodSynchronizationTests.assertEquals((String)this.calcImplementation(methodElem), (String)wm.getImplementation());
        ImplicitSeiMethodSynchronizationTests.assertFalse((boolean)wm.isExcluded());
    }

    public void test_methodNoAnnotationInParentWithoutWsAnnotationNotSynched() throws JavaModelException {
        IMethod methodElem = this.util.getExistingMethod(this.baseClassWithoutWsAnnot, "noAnnotationInBaseNoWSClass", new String[0]);
        IWebMethod wm = this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElem));
        ImplicitSeiMethodSynchronizationTests.assertNull((Object)wm);
    }

    public void test_methodWithAnnotationInParentWithoutWsAnnotationSynched() throws JavaModelException {
        IMethod methodElemBaseNoWsClass = this.util.getExistingMethod(this.baseClassWithoutWsAnnot, "annotationInBaseNoWSClass", new String[0]);
        ImplicitSeiMethodSynchronizationTests.assertNotNull((Object)this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemBaseNoWsClass)));
    }

    public void test_nonPublicMethodTroughHierarchyNotSynched() throws JavaModelException {
        IMethod methodElemBaseNoWsClass = this.util.getExistingMethod(this.baseClassWithoutWsAnnot, "nonPublicInBaseNoWSClass", new String[0]);
        ImplicitSeiMethodSynchronizationTests.assertFalse((boolean)Modifier.isPublic((int)methodElemBaseNoWsClass.getFlags()));
        IMethod methodElemBaseWsClass = this.util.getExistingMethod(this.baseClassWithWsAnnot, "nonPublicInBaseWSClass", new String[0]);
        ImplicitSeiMethodSynchronizationTests.assertFalse((boolean)Modifier.isPublic((int)methodElemBaseWsClass.getFlags()));
        IMethod methodElemWsClass = this.util.getExistingMethod(this.wsClass, "nonPublicInWSClass", new String[0]);
        ImplicitSeiMethodSynchronizationTests.assertFalse((boolean)Modifier.isPublic((int)methodElemWsClass.getFlags()));
        ImplicitSeiMethodSynchronizationTests.assertNull((Object)this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemBaseNoWsClass)));
        ImplicitSeiMethodSynchronizationTests.assertNull((Object)this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemBaseWsClass)));
        ImplicitSeiMethodSynchronizationTests.assertNull((Object)this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemWsClass)));
    }

    public void test_excludedMethodTroughHierarchyNotSynched() throws JavaModelException {
        IMethod methodElemBaseNoWsClass = this.util.getExistingMethod(this.baseClassWithoutWsAnnot, "excludedPublicInBaseNoWSClass", new String[0]);
        ImplicitSeiMethodSynchronizationTests.assertTrue((boolean)Modifier.isPublic((int)methodElemBaseNoWsClass.getFlags()));
        IMethod methodElemBaseWsClass = this.util.getExistingMethod(this.baseClassWithWsAnnot, "excludedPublicInBaseWSClass", new String[0]);
        ImplicitSeiMethodSynchronizationTests.assertTrue((boolean)Modifier.isPublic((int)methodElemBaseWsClass.getFlags()));
        IMethod methodElemWsClass = this.util.getExistingMethod(this.wsClass, "excludedPublicInWSClass", new String[0]);
        ImplicitSeiMethodSynchronizationTests.assertTrue((boolean)Modifier.isPublic((int)methodElemWsClass.getFlags()));
        ImplicitSeiMethodSynchronizationTests.assertNull((Object)this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemBaseNoWsClass)));
        ImplicitSeiMethodSynchronizationTests.assertNull((Object)this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemBaseWsClass)));
        ImplicitSeiMethodSynchronizationTests.assertNull((Object)this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemWsClass)));
    }

    public void test_overrideMethodsLoadedProperly() throws JavaModelException {
        IMethod methodElemBaseNoWsClass = this.util.getExistingMethod(this.baseClassWithoutWsAnnot, "toOverride", new String[0]);
        IWebMethod wm = this.findWebMethodByImpl(this.ws1.getServiceEndpoint(), this.calcImplementation(methodElemBaseNoWsClass));
        ImplicitSeiMethodSynchronizationTests.assertNotNull((Object)wm);
        ImplicitSeiMethodSynchronizationTests.assertEquals((String)"nameInWsClass", (String)wm.getName());
    }

    private IWebMethod findWebMethodByImpl(IServiceEndpointInterface sei, String impl) {
        for (IWebMethod wm : sei.getWebMethods()) {
            if (!wm.getImplementation().equals(impl)) continue;
            return wm;
        }
        return null;
    }

    private String calcImplementation(IMethod m) throws JavaModelException {
        return String.valueOf(m.getElementName()) + m.getSignature();
    }
}

