/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jface.internal.text.html.HTML2TextReader;

public class HTML2TextReaderTester
extends TestCase {
    private static final boolean DEBUG = false;
    private static final String LD = System.getProperty("line.separator", "\n");

    public HTML2TextReaderTester(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(HTML2TextReaderTester.class);
    }

    private void verify(String input, String expectedOutput) throws IOException {
        StringReader reader = new StringReader(input);
        HTML2TextReader htmlReader = new HTML2TextReader((Reader)reader, null);
        String result = htmlReader.getString();
        HTML2TextReaderTester.assertEquals((String)expectedOutput, (String)result);
    }

    public void test0() throws IOException {
        String string = "<code>3<5<code>";
        String expected = "3<5";
        this.verify(string, expected);
    }

    public void test1() throws IOException {
        String string = "<dl><dt>@author</dt><dd>Foo Bar</dd></dl>";
        String expected = String.valueOf(LD) + "@author" + LD + "\tFoo Bar" + LD;
        this.verify(string, expected);
    }

    public void test2() throws IOException {
        String string = "<code>3>5<code>";
        String expected = "3>5";
        this.verify(string, expected);
    }

    public void test3() throws IOException {
        String string = "<a href= \"<p>this is only a string - not a tag<p>\">text</a>";
        String expected = "text";
        this.verify(string, expected);
    }

    public void test4() throws IOException {
        String string = "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1><h5>void p.Bb.fes()</h5><p><dl><dt>Parameters:</dt><dd><b>i</b> fred or <code>null</code></dd></dl></font></body></html>";
        String expected = "void p.Bb.fes()" + LD + LD + LD + "Parameters:" + LD + "\ti fred or null" + LD;
        this.verify(string, expected);
    }

    public void test5() throws IOException {
        String string = "<code>1<2<3<4</code>";
        String expected = "1<2<3<4";
        this.verify(string, expected);
    }

    public void test6() throws IOException {
        String string = "<p>Something.<p>Something more.";
        String expected = String.valueOf(LD) + "Something." + LD + "Something more.";
        this.verify(string, expected);
    }

    public void testComments() throws Exception {
        String string = "<!-- begin-user-doc -->no comment<!-- end-user-doc -->";
        String expected = "no comment";
        this.verify(string, expected);
    }
}

