/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.tests.internal.Activator;

public class BundleResourceUtil {
    static WeakHashMap exists = new WeakHashMap();

    public static void _copyBundleEntriesIntoWorkspace(String rootEntry, String fullTargetPath) throws Exception {
        Enumeration entries = Activator.getDefault().getBundle().getEntryPaths(rootEntry);
        while (entries != null && entries.hasMoreElements()) {
            String entryPath = entries.nextElement().toString();
            String targetPath = new Path(String.valueOf(fullTargetPath) + "/" + entryPath.substring(rootEntry.length())).toString();
            if (entryPath.endsWith("/")) {
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(targetPath));
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                BundleResourceUtil._copyBundleEntriesIntoWorkspace(entryPath, targetPath);
                continue;
            }
            BundleResourceUtil._copyBundleEntryIntoWorkspace(entryPath, targetPath);
        }
    }

    public static IFile _copyBundleEntryIntoWorkspace(String entryname, String fullPath) throws Exception {
        IFile file = null;
        URL entry = Activator.getDefault().getBundle().getEntry(entryname);
        if (entry != null) {
            Path path = new Path(fullPath);
            int j = path.segmentCount() - 2;
            while (j > 0) {
                IPath folderPath = path.removeLastSegments(j);
                if (exists.get(folderPath) == null) {
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath);
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                    exists.put(folderPath, Boolean.TRUE);
                }
                --j;
            }
            byte[] b = new byte[2048];
            InputStream input = entry.openStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int i = -1;
            while ((i = input.read(b)) > -1) {
                output.write(b, 0, i);
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file != null) {
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(output.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    file.setContents((InputStream)new ByteArrayInputStream(output.toByteArray()), true, false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        } else {
            System.err.println("can't find " + entryname);
        }
        return file;
    }

    public static void copyBundleEntriesIntoWorkspace(final String rootEntry, final String fullTargetPath) throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    BundleResourceUtil._copyBundleEntriesIntoWorkspace(rootEntry, fullTargetPath);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, null, (Throwable)e));
                }
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IFile copyBundleEntryIntoWorkspace(final String entryname, final String fullPath) throws Exception {
        final IFile[] file = new IFile[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    file[0] = BundleResourceUtil._copyBundleEntryIntoWorkspace(entryname, fullPath);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
                }
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        return file[0];
    }

    public static void copyBundleZippedEntriesIntoWorkspace(final String zipFileEntry, final IPath fullTargetPath) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                block29: {
                    IFile file = null;
                    URL entry = Activator.getDefault().getBundle().getEntry(zipFileEntry);
                    if (entry != null) {
                        ZipInputStream input = null;
                        try {
                            byte[] b = new byte[2048];
                            input = new ZipInputStream(entry.openStream());
                            ZipEntry nextEntry = input.getNextEntry();
                            while (nextEntry != null) {
                                IPath path = fullTargetPath.append(nextEntry.getName());
                                if (nextEntry.isDirectory()) {
                                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                                    if (!folder.exists()) {
                                        folder.create(true, true, null);
                                    }
                                } else {
                                    IPath folderPath = path.removeLastSegments(1);
                                    int i = folderPath.segmentCount();
                                    while (i > 0) {
                                        IFolder folder;
                                        IPath parentFolderPath = path.removeLastSegments(i);
                                        if (parentFolderPath.segmentCount() > 1 && !(folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(parentFolderPath)).exists()) {
                                            folder.create(true, true, null);
                                        }
                                        --i;
                                    }
                                    file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                                    int i2 = -1;
                                    while ((i2 = input.read(b)) > -1) {
                                        output.write(b, 0, i2);
                                    }
                                    if (!file.exists()) {
                                        file.create((InputStream)new ByteArrayInputStream(output.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                                    } else {
                                        file.setContents((InputStream)new ByteArrayInputStream(output.toByteArray()), true, false, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                }
                                ResourcesPlugin.getWorkspace().checkpoint(true);
                                nextEntry = input.getNextEntry();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                if (input != null) {
                                    input.close();
                                }
                                break block29;
                            }
                            catch (IOException iOException) {}
                            break block29;
                        }
                        catch (CoreException e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (input != null) {
                                        input.close();
                                    }
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                if (input != null) {
                                    input.close();
                                }
                                break block29;
                            }
                            catch (IOException iOException) {}
                            break block29;
                        }
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        catch (IOException iOException) {}
                    } else {
                        System.err.println("can't find " + zipFileEntry);
                    }
                }
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IProject createSimpleProject(String name, IPath location, String[] natureIds) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (location != null) {
            description.setLocation(location);
        }
        if (natureIds != null) {
            description.setNatureIds(natureIds);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }
}

