/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ClasspathInitializerTests;
import org.eclipse.wst.jsdt.core.tests.model.ContainerInitializer;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.Semaphore;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;

public class ThreadSafetyTests
extends ModifyingResourceTests {
    public ThreadSafetyTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ThreadSafetyTests.buildModelTestSuite(ThreadSafetyTests.class);
    }

    public void testDeadlock01() throws CoreException {
        System.out.println("Test deadlock scenario");
        try {
            final IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[]{"org.eclipse.wst.jsdt.core.tests.model.TEST_CONTAINER"});
            ThreadSafetyTests.waitUntilIndexesReady();
            project.getJavaScriptModel().close();
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            manager.previousSessionContainers = new HashMap(5);
            manager.containers = new HashMap(5);
            manager.removePerProjectInfo((JavaProject)project);
            final Semaphore step1 = new Semaphore("<1:permission to populate JavaModel inducing containers inits>", 0);
            final Semaphore step2 = new Semaphore("<2:permission to perform resource modification >", 0);
            final Semaphore hasCompleted = new Semaphore(0);
            ContainerInitializer.setInitializer(new ClasspathInitializerTests.DefaultContainerInitializer(new String[]{"P", ""}){

                @Override
                public void initialize(IPath containerPath, IJavaScriptProject javaProject) throws CoreException {
                    step2.release();
                    System.out.println(Thread.currentThread() + " initializer has started: attempting to acquire workspace lock");
                    super.initialize(containerPath, javaProject);
                    System.out.println(Thread.currentThread() + " initializer has finished");
                }
            });
            Thread performJavaOperationInsideWorkspaceLock = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                System.out.println(Thread.currentThread() + " got workspace lock");
                                step1.release();
                                step2.acquire();
                                ThreadSafetyTests.this.createFile("/P/X.js", "public class X {}");
                                System.out.println(Thread.currentThread() + " created file X.js");
                            }
                        }, null);
                    }
                    catch (CoreException coreException) {}
                    hasCompleted.release();
                    System.out.println(Thread.currentThread() + " ResourceModification DONE");
                }
            }, "ModifyResource");
            performJavaOperationInsideWorkspaceLock.setDaemon(true);
            performJavaOperationInsideWorkspaceLock.start();
            Thread attemptPopulateTheJavaModel = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        step1.acquire();
                        System.out.println(Thread.currentThread() + " about to populate Java model");
                        project.getChildren();
                        System.out.println(Thread.currentThread() + " done populating the model");
                    }
                    catch (JavaScriptModelException javaScriptModelException) {}
                    hasCompleted.release();
                    System.out.println(Thread.currentThread() + " Populate JavaModel DONE");
                }
            }, "PopulateModel");
            attemptPopulateTheJavaModel.setDaemon(true);
            attemptPopulateTheJavaModel.start();
            hasCompleted.acquire();
            hasCompleted.acquire();
            System.out.println("SUCCESS - no deadlock encountered");
        }
        finally {
            this.deleteProject("P");
        }
    }
}

