/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavadocCompletionModelTest;

public class JavadocMethodCompletionModelTest
extends AbstractJavadocCompletionModelTest {
    public JavadocMethodCompletionModelTest(String name) {
        super(name);
    }

    public static Test suite() {
        return JavadocMethodCompletionModelTest.buildModelTestSuite(JavadocMethodCompletionModelTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setUpProjectOptions("1.4");
    }

    public void test001() throws JavaScriptModelException {
        String source = "package javadoc.methods;\npublic class Test {\n\t/**\n\t * Completion on empty tag name:\n\t * \t@\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/Test.js", source, true, "@");
        this.assertResults("deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "exception[JSDOC_BLOCK_TAG]{@exception, null, null, exception, null, " + this.positions + 8 + "}\n" + "param[JSDOC_BLOCK_TAG]{@param, null, null, param, null, " + this.positions + 8 + "}\n" + "return[JSDOC_BLOCK_TAG]{@return, null, null, return, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "serialData[JSDOC_BLOCK_TAG]{@serialData, null, null, serialData, null, " + this.positions + 8 + "}\n" + "throws[JSDOC_BLOCK_TAG]{@throws, null, null, throws, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}");
    }

    public void test002() throws JavaScriptModelException {
        String source = "package javadoc.methods;\npublic class Test {\n\t/**\n\t * Completion on impossible tag name:\n\t * \t@aut\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/Test.js", source, true, "@aut");
        this.assertResults("");
    }

    public void test003() throws JavaScriptModelException {
        String source = "package javadoc.methods;\npublic class Test {\n\t/**\n\t * Completion on one letter:\n\t * \t@r\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/Test.js", source, true, "@r");
        this.assertResults("return[JSDOC_BLOCK_TAG]{@return, null, null, return, null, " + this.positions + 8 + "}");
    }

    public void test004() throws JavaScriptModelException {
        String source = "package javadoc.methods;\npublic class Test {\n\t/**\n\t * Completion with several letters:\n\t * \t@ser\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/Test.js", source, true, "@ser");
        this.assertResults("serialData[JSDOC_BLOCK_TAG]{@serialData, null, null, serialData, null, " + this.positions + 8 + "}");
    }

    public void test005() throws JavaScriptModelException {
        String source = "package javadoc.methods;\npublic class Test {\n\t/**\n\t * Completion on full tag name:\n\t * \t@inheritDoc\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/Test.js", source, true, "@inheritDoc");
        this.assertResults("inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}");
    }

    public void test006() throws JavaScriptModelException {
        this.setUpProjectOptions("1.3");
        String source = "package javadoc.methods;\npublic class Test {\n\t/**\n\t * Completion on empty tag name:\n\t * \t@\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/Test.js", source, true, "@");
        this.assertResults("deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "exception[JSDOC_BLOCK_TAG]{@exception, null, null, exception, null, " + this.positions + 8 + "}\n" + "param[JSDOC_BLOCK_TAG]{@param, null, null, param, null, " + this.positions + 8 + "}\n" + "return[JSDOC_BLOCK_TAG]{@return, null, null, return, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "serialData[JSDOC_BLOCK_TAG]{@serialData, null, null, serialData, null, " + this.positions + 8 + "}\n" + "throws[JSDOC_BLOCK_TAG]{@throws, null, null, throws, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}");
    }

    public void test007() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods;\npublic class Test {\n\t/**\n\t * Completion on empty tag name:\n\t * \t@\n\t */\n\tpublic void foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/Test.js", source, true, "@");
        this.assertResults("deprecated[JSDOC_BLOCK_TAG]{@deprecated, null, null, deprecated, null, " + this.positions + 8 + "}\n" + "exception[JSDOC_BLOCK_TAG]{@exception, null, null, exception, null, " + this.positions + 8 + "}\n" + "param[JSDOC_BLOCK_TAG]{@param, null, null, param, null, " + this.positions + 8 + "}\n" + "return[JSDOC_BLOCK_TAG]{@return, null, null, return, null, " + this.positions + 8 + "}\n" + "see[JSDOC_BLOCK_TAG]{@see, null, null, see, null, " + this.positions + 8 + "}\n" + "category[JSDOC_BLOCK_TAG]{@category, null, null, category, null, " + this.positions + 8 + "}\n" + "since[JSDOC_BLOCK_TAG]{@since, null, null, since, null, " + this.positions + 8 + "}\n" + "serialData[JSDOC_BLOCK_TAG]{@serialData, null, null, serialData, null, " + this.positions + 8 + "}\n" + "throws[JSDOC_BLOCK_TAG]{@throws, null, null, throws, null, " + this.positions + 8 + "}\n" + "link[JSDOC_INLINE_TAG]{{@link}, null, null, link, null, " + this.positions + 8 + "}\n" + "docRoot[JSDOC_INLINE_TAG]{{@docRoot}, null, null, docRoot, null, " + this.positions + 8 + "}\n" + "inheritDoc[JSDOC_INLINE_TAG]{{@inheritDoc}, null, null, inheritDoc, null, " + this.positions + 8 + "}\n" + "linkplain[JSDOC_INLINE_TAG]{{@linkplain}, null, null, linkplain, null, " + this.positions + 8 + "}\n" + "value[JSDOC_INLINE_TAG]{{@value}, null, null, value, null, " + this.positions + 8 + "}\n" + "code[JSDOC_INLINE_TAG]{{@code}, null, null, code, null, " + this.positions + 8 + "}\n" + "literal[JSDOC_INLINE_TAG]{{@literal}, null, null, literal, null, " + this.positions + 8 + "}");
    }

    public void test010() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethodsE\n\t */\n\tpublic void foo() {}\n}\nclass BasicTestMethodsException1 extends Exception{}\nclass BasicTestMethodsException2 extends Exception{}\nclass BasicTestMethodsExample {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethodsE");
        this.assertSortedResults("BasicTestMethodsExample[TYPE_REF]{BasicTestMethodsExample, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsExample;, null, null, " + this.positions + 21 + "}\n" + "BasicTestMethodsException1[TYPE_REF]{BasicTestMethodsException1, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException1;, null, null, " + this.positions + 21 + "}\n" + "BasicTestMethodsException2[TYPE_REF]{BasicTestMethodsException2, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException2;, null, null, " + this.positions + 21 + "}");
    }

    public void test011() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\n\t/**\n\t * Completion after:\n\t * \t@see \n\t */\n\tpublic void foo() {}\n}\nclass BasicTestMethodsException1 extends Exception{}\nclass BasicTestMethodsException2 extends Exception{}\nclass BasicTestMethodsExample {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@see ", 0);
        this.assertResults("BasicTestMethods[TYPE_REF]{BasicTestMethods, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethods;, null, null, " + this.positions + 21 + "}\n" + "BasicTestMethodsException1[TYPE_REF]{BasicTestMethodsException1, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException1;, null, null, " + this.positions + 21 + "}\n" + "BasicTestMethodsException2[TYPE_REF]{BasicTestMethodsException2, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException2;, null, null, " + this.positions + 21 + "}\n" + "BasicTestMethodsExample[TYPE_REF]{BasicTestMethodsExample, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsExample;, null, null, " + this.positions + 21 + "}");
    }

    public void test012() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\n\t/**\n\t * Completion after:\n\t * \t@throws BasicTestMethodsE\n\t */\n\tpublic void foo() {}\n}\nclass BasicTestMethodsException1 extends Exception{}\nclass BasicTestMethodsException2 extends Exception{}\nclass BasicTestMethodsExample {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethodsE");
        this.assertSortedResults("BasicTestMethodsException1[TYPE_REF]{BasicTestMethodsException1, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException1;, null, null, " + this.positions + 41 + "}\n" + "BasicTestMethodsException2[TYPE_REF]{BasicTestMethodsException2, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException2;, null, null, " + this.positions + 41 + "}\n" + "BasicTestMethodsExample[TYPE_REF]{BasicTestMethodsExample, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsExample;, null, null, " + this.positions + 21 + "}");
    }

    public void test013() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\n\t/**\n\t * Completion after:\n\t * \t@throws BasicTestMethodsE\n\t */\n\tpublic void foo() throws BasicTestMethodsException2 {}\n}\nclass BasicTestMethodsException1 extends Exception{}\nclass BasicTestMethodsException2 extends Exception{}\nclass BasicTestMethodsExample {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethodsE");
        this.assertSortedResults("BasicTestMethodsException2[TYPE_REF]{BasicTestMethodsException2, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException2;, null, null, " + this.positions + 71 + "}\n" + "BasicTestMethodsException1[TYPE_REF]{BasicTestMethodsException1, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException1;, null, null, " + this.positions + 41 + "}\n" + "BasicTestMethodsExample[TYPE_REF]{BasicTestMethodsExample, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsExample;, null, null, " + this.positions + 21 + "}");
    }

    public void test014() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\n\t/**\n\t * Completion after:\n\t * \t@throws \n\t */\n\tpublic void foo() throws BasicTestMethodsException {}\n}\nclass BasicTestMethodsException extends Exception{}\nclass BasicTestMethodsExample {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@throws ", 0);
        this.assertResults("BasicTestMethods[TYPE_REF]{BasicTestMethods, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethods;, null, null, " + this.positions + 21 + "}\n" + "BasicTestMethodsException[TYPE_REF]{BasicTestMethodsException, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsException;, null, null, " + this.positions + 71 + "}\n" + "BasicTestMethodsExample[TYPE_REF]{BasicTestMethodsExample, javadoc.methods.tags, Ljavadoc.methods.tags.BasicTestMethodsExample;, null, null, " + this.positions + 21 + "}");
    }

    public void test015() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\n\t/**\n\t * Completion after:\n\t * \t@throws I\n\t * \t\tNote: there should be NO base types in proposals.\t */\n\tpublic void foo() {\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "I");
        this.assertResults("IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 41 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 41 + "}");
    }

    public void test016() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\n\t/**\n\t * Completion after:\n\t * \t@throws java.lang.I\n\t */\n\tpublic void foo() throws InterruptedException {\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "java.lang.I");
        this.assertResults("IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 38 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 68 + "}");
    }

    public void test020() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #fo\n\t */\n\tint foo;\n\tvoid foo() {}\n}";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "fo");
        this.assertResults("foo[FIELD_REF]{foo, Ljavadoc.methods.tags.BasicTestMethods;, I, foo, null, " + this.positions + 29 + "}\n" + "foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, foo, null, " + this.positions + 29 + "}");
    }

    public void test021() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#fo\n\t */\n\tint foo;\n\tvoid foo() {}\n}";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "fo");
        this.assertResults("foo[FIELD_REF]{foo, Ljavadoc.methods.tags.BasicTestMethods;, I, foo, null, " + this.positions + 29 + "}\n" + "foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, foo, null, " + this.positions + 29 + "}");
    }

    public void test022() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see javadoc.methods.tags.BasicTestMethods#fo\n\t */\n\tint foo;\n\tvoid foo() {}\n}";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "fo");
        this.assertResults("foo[FIELD_REF]{foo, Ljavadoc.methods.tags.BasicTestMethods;, I, foo, null, " + this.positions + 29 + "}\n" + "foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, foo, null, " + this.positions + 29 + "}");
    }

    public void test023() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/methods/tags/BasicTestMethods.js", "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see OtherFields#fo\n\t */\n\tint foo;\n}", "/Completion/src/javadoc/methods/tags/OtherFields.js", "package javadoc.methods.tags;\npublic class OtherFields {\n\tint foo;\n\tvoid foo() {}\n}"};
        this.completeInJavadoc(sources, true, "fo");
        this.assertResults("foo[FIELD_REF]{foo, Ljavadoc.methods.tags.OtherFields;, I, foo, null, " + this.positions + 29 + "}\n" + "foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.OtherFields;, ()V, foo, null, " + this.positions + 29 + "}");
    }

    public void test030() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see fo\n\t */\n\tvoid foo() {}\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "fo");
        this.assertResults("");
    }

    public void test031() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #fo\n\t */\n\t<T> void foo() {}\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "fo");
        this.assertResults("foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, <T:Ljava.lang.Object;>()V, foo, null, " + this.positions + 29 + "}");
    }

    public void test032() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #ba\n\t * \n\t * Note that argument names are put in proposals although there are not while completing\n\t * in javadoc text {@link javadoc.text.BasicTestMethods }. This is due to the fact that while\n\t * completing in javadoc tags, it's JDT-UI which compute arguments, not JDT-CORE.\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "ba");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 29 + "}");
    }

    public void test033() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #ba\n\t * \n\t * Note that argument names are put in proposals although there are not while completing\n\t * in javadoc text {@link javadoc.text.BasicTestMethods }. This is due to the fact that while\n\t * completing in javadoc tags, it's JDT-UI which compute arguments, not JDT-CORE.\n\t */\n\t<T, U> void bar(String str, Class<T> clt, Class<U> clu) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "ba");
        this.assertResults("bar[FUNCTION_REF]{bar(String, Class, Class), Ljavadoc.methods.tags.BasicTestMethods;, <T:Ljava.lang.Object;U:Ljava.lang.Object;>(Ljava.lang.String;Ljava.lang.Class<TT;>;Ljava.lang.Class<TU;>;)V, bar, (str, clt, clu), " + this.positions + 29 + "}");
    }

    public void test034() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#ba\n\t * \n\t * Note that argument names are put in proposals although there are not while completing\n\t * in javadoc text {@link javadoc.text.BasicTestMethods }. This is due to the fact that while\n\t * completing in javadoc tags, it's JDT-UI which compute arguments, not JDT-CORE.\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "ba");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 29 + "}");
    }

    public void test035() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see javadoc.methods.tags.BasicTestMethods#ba\n\t * \n\t * Note that argument names are put in proposals although there are not while completing\n\t * in javadoc text {@link javadoc.text.BasicTestMethods }. This is due to the fact that while\n\t * completing in javadoc tags, it's JDT-UI which compute arguments, not JDT-CORE.\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "ba");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 29 + "}");
    }

    public void test036() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/methods/tags/BasicTestMethods.js", "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see OtherTypes#fo\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/methods/tags/OtherTypes.js", "package javadoc.methods.tags;\npublic class OtherTypes {\n\tvoid foo() {};\n}"};
        this.completeInJavadoc(sources, true, "fo");
        this.assertResults("foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.OtherTypes;, ()V, foo, null, " + this.positions + 29 + "}");
    }

    public void test037() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #\n\t */\n\tvoid foo() {}\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, foo, null, " + this.positions + 29 + "}\n" + "bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test038() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #\n\t */\n\t<T> void foo() {}\n\t<TParam1, TParam2> void bar(TParam1 tp1, TParam2 tp2) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, <T:Ljava.lang.Object;>()V, foo, null, " + this.positions + 29 + "}\n" + "bar[FUNCTION_REF]{bar(Object, Object), Ljavadoc.methods.tags.BasicTestMethods;, <TParam1:Ljava.lang.Object;TParam2:Ljava.lang.Object;>(TTParam1;TTParam2;)V, bar, (tp1, tp2), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test039() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#\n\t */\n\tvoid foo() {}\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, foo, null, " + this.positions + 29 + "}\n" + "bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test040() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see javadoc.methods.tags.BasicTestMethods#\n\t */\n\tvoid foo() {}\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("foo[FUNCTION_REF]{foo(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, foo, null, " + this.positions + 29 + "}\n" + "bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test041() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test042() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(Str\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "Str");
        this.assertResults("String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 21 + "}");
    }

    public void test043() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(java.lang.\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "java.lang.");
        this.assertSortedResults("Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 18 + "}\n" + "CloneNotSupportedException[TYPE_REF]{CloneNotSupportedException, java.lang, Ljava.lang.CloneNotSupportedException;, null, null, " + this.positions + 18 + "}\n" + "Error[TYPE_REF]{Error, java.lang, Ljava.lang.Error;, null, null, " + this.positions + 18 + "}\n" + "Exception[TYPE_REF]{Exception, java.lang, Ljava.lang.Exception;, null, null, " + this.positions + 18 + "}\n" + "IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 18 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 18 + "}\n" + "Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 18 + "}\n" + "RuntimeException[TYPE_REF]{RuntimeException, java.lang, Ljava.lang.RuntimeException;, null, null, " + this.positions + 18 + "}\n" + "String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 18 + "}\n" + "Throwable[TYPE_REF]{Throwable, java.lang, Ljava.lang.Throwable;, null, null, " + this.positions + 18 + "}");
    }

    public void test044() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(java.lang.St\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "java.lang.St");
        this.assertResults("String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 18 + "}");
    }

    public void test045() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String s\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String s");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test046() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String str, \n\t */\n\t// Note: Completion takes place just after trailoing comma (there's a space after)\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String str,");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test047() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String str, \n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String str, ");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test048() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String,\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String,");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test049() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String str, bool\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bool");
        this.assertResults("boolean[KEYWORD]{boolean, null, null, boolean, null, " + this.positions + 18 + "}");
    }

    public void test050() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String str, boolean,\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String str, boolean,");
        this.assertResults("");
    }

    public void test051() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String str, boolean flag,\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String str, boolean flag,");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test052() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String,boolean,\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String,boolean,");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test053() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String,boolean,Object\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "Object");
        this.assertResults("Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 25 + "}");
    }

    public void test054() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String, boolean, Object o\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String, boolean, Object o");
        this.assertResults("");
    }

    public void test055() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #bar(String str, boolean flag, Object o\n\t */\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "bar(String str, boolean flag, Object o");
        this.assertResults("bar[FUNCTION_REF]{bar(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, bar, (str, flag, obj), " + this.positions + 25 + "}");
    }

    public void test056() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/methods/tags/BasicTestMethods.js", "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see OtherTypes#foo(\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/methods/tags/OtherTypes.js", "package javadoc.methods.tags;\npublic class OtherTypes {\n\tvoid foo(String str) {};\n}"};
        this.completeInJavadoc(sources, true, "foo(");
        this.assertResults("foo[FUNCTION_REF]{foo(String), Ljavadoc.methods.tags.OtherTypes;, (Ljava.lang.String;)V, foo, (str), " + this.positions + 25 + "}");
    }

    public void test057() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/methods/tags/BasicTestMethods.js", "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see javadoc.methods.tags.OtherTypes#foo(\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/methods/tags/OtherTypes.js", "package javadoc.methods.tags;\npublic class OtherTypes {\n\tvoid foo(String str) {};\n}"};
        this.completeInJavadoc(sources, true, "foo(");
        this.assertResults("foo[FUNCTION_REF]{foo(String), Ljavadoc.methods.tags.OtherTypes;, (Ljava.lang.String;)V, foo, (str), " + this.positions + 25 + "}");
    }

    public void test058() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#method()\n\t */\n\tvoid method() {}\n\tvoid bar(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "meth", 2);
        this.assertResults("method[FUNCTION_REF]{method(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, method, null, " + this.positions + 29 + "}");
    }

    public void test059() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#method()\n\t */\n\tvoid method() {}\n\tvoid method(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "meth", 2);
        this.assertResults("method[FUNCTION_REF]{method(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, method, (str, flag, obj), " + this.positions + 29 + "}\n" + "method[FUNCTION_REF]{method(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, method, null, " + this.positions + 29 + "}");
    }

    public void test060() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#method(String)\n\t */\n\tvoid method() {}\n\tvoid method(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "meth", 2);
        this.assertResults("method[FUNCTION_REF]{method(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, method, (str, flag, obj), " + this.positions + 29 + "}\n" + "method[FUNCTION_REF]{method(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, method, null, " + this.positions + 29 + "}");
    }

    public void test061() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#method(String,boolean,Object)\n\t */\n\tvoid method() {}\n\tvoid method(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "meth", 2);
        this.assertResults("method[FUNCTION_REF]{method(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, method, (str, flag, obj), [116, 145], 29}\nmethod[FUNCTION_REF]{method(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, method, null, [116, 145], 29}");
    }

    public void _test062() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#method(String str,boolean,Object)\n\t */\n\tvoid method() {}\n\tvoid method(String str, boolean flag, Object obj) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "meth", 2);
        this.assertResults("method[FUNCTION_REF]{method(String, boolean, Object), Ljavadoc.methods.tags.BasicTestMethods;, (Ljava.lang.String;ZLjava.lang.Object;)V, method, (str, flag, obj), " + this.positions + 21 + "}\n" + "method[FUNCTION_REF]{method(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, method, null, " + this.positions + 21 + "}");
    }

    public void test070() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param \n\t */\n\tpublic String foo(String str) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertResults("str[JSDOC_PARAM_REF]{str, null, null, str, null, " + this.positions + 13 + "}");
    }

    public void test071() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param x\n\t */\n\tpublic String foo(String xstr) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "x");
        this.assertResults("xstr[JSDOC_PARAM_REF]{xstr, null, null, xstr, null, " + this.positions + 13 + "}");
    }

    public void test072() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t */\n\tpublic String foo(String xstr) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr");
        this.assertResults("xstr[JSDOC_PARAM_REF]{xstr, null, null, xstr, null, " + this.positions + 13 + "}");
    }

    public void test073() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t */\n\tpublic String foo(String xstr) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "x");
        this.assertResults("xstr[JSDOC_PARAM_REF]{xstr, null, null, xstr, null, " + this.positions + 13 + "}");
    }

    public void test074() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xx\n\t */\n\tpublic String foo(String xstr) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xx");
        this.assertResults("");
    }

    public void test075() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t ** \t@param \n\t */\n\tpublic String foo(String xstr) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertResults("");
    }

    public void test076() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr\n\t */\n\tpublic String foo(String xstr) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr");
        this.assertResults("");
    }

    public void test077() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr\n\t */\n\tpublic String foo(String xstr) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr", 2);
        this.assertResults("");
    }

    public void test078() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr\n\t */\n\tpublic String foo(String xstr, String xstr2) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr");
        this.assertResults("xstr2[JSDOC_PARAM_REF]{xstr2, null, null, xstr2, null, " + this.positions + 13 + "}");
    }

    public void test079() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr\n\t */\n\tpublic String foo(String xstr, String xstr2) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr", 2);
        this.assertResults("xstr2[JSDOC_PARAM_REF]{xstr2, null, null, xstr2, null, " + this.positions + 13 + "}");
    }

    public void test080() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr2\n\t */\n\tpublic String foo(String xstr, String xstr2) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr");
        this.assertResults("xstr[JSDOC_PARAM_REF]{xstr, null, null, xstr, null, " + this.positions + 13 + "}");
    }

    public void test081() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr2\n\t */\n\tpublic String foo(String xstr, String xstr2) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr", 2);
        this.assertResults("xstr2[JSDOC_PARAM_REF]{xstr2, null, null, xstr2, null, " + this.positions + 13 + "}");
    }

    public void test082() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr\n\t * \t@param xstr2\n\t */\n\tpublic String foo(String xstr, String xstr2) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr");
        this.assertResults("");
    }

    public void test083() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr\n\t * \t@param xstr2\n\t */\n\tpublic String foo(String xstr, String xstr2) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr", 2);
        this.assertResults("");
    }

    public void test084() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t * \t@param xstr\n\t * \t@param xstr2\n\t */\n\tpublic String foo(String xstr, String xstr2) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "xstr", 3);
        this.assertResults("xstr2[JSDOC_PARAM_REF]{xstr2, null, null, xstr2, null, " + this.positions + 13 + "}");
    }

    public void test085() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param \n\t */\n\tpublic String foo(String xstr, boolean flag, Object obj) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertResults("xstr[JSDOC_PARAM_REF]{xstr, null, null, xstr, null, " + this.positions + 15 + "}\n" + "flag[JSDOC_PARAM_REF]{flag, null, null, flag, null, " + this.positions + 14 + "}\n" + "obj[JSDOC_PARAM_REF]{obj, null, null, obj, null, " + this.positions + 13 + "}");
    }

    public void test086() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param xstr\n\t ** \t@param \n\t */\n\tpublic String methodMultipleParam2(String xstr, boolean flag, Object obj) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertResults("flag[JSDOC_PARAM_REF]{flag, null, null, flag, null, " + this.positions + 14 + "}\n" + "obj[JSDOC_PARAM_REF]{obj, null, null, obj, null, " + this.positions + 13 + "}");
    }

    public void test087() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param \n\t * \t@param flag\n\t */\n\tpublic String methodMultipleParam3(String xstr, boolean flag, Object obj) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertResults("xstr[JSDOC_PARAM_REF]{xstr, null, null, xstr, null, " + this.positions + 14 + "}\n" + "obj[JSDOC_PARAM_REF]{obj, null, null, obj, null, " + this.positions + 13 + "}");
    }

    public void test088() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param obj\n\t * \t@param xstr\n\t ** \t@param \n\t */\n\tpublic String methodMultipleParam4(String xstr, boolean flag, Object obj) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertResults("flag[JSDOC_PARAM_REF]{flag, null, null, flag, null, " + this.positions + 13 + "}");
    }

    public void test089() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param \n\t * \t@param obj\n\t * \t@param xstr\n\t * \t@param flag\n\t */\n\tpublic String methodMultipleParam5(String xstr, boolean flag, Object obj) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertResults("");
    }

    public void test090() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param obj\n\t * \t@param xstr\n\t * \t@param flag\n\t */\n\tpublic String methodMultipleParam5(String xstr, boolean flag, Object obj) {\n\t\treturn null;\n\t}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "ob");
        this.assertResults("obj[JSDOC_PARAM_REF]{obj, null, null, obj, null, " + this.positions + 13 + "}");
    }

    public void test100() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param \n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + 14 + "}\n" + "xtc[JSDOC_PARAM_REF]{xtc, null, null, xtc, null, " + this.positions + 13 + "}\n" + "TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test101() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <TM>\n\t ** \t@param \n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + 14 + "}\n" + "xtc[JSDOC_PARAM_REF]{xtc, null, null, xtc, null, " + this.positions + 13 + "}");
    }

    public void test102() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param xtc\n\t * \t@param <TM>\n\t ** \t@param \n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + 13 + "}");
    }

    public void test103() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param xtc\n\t ** \t@param \n\t * \t@param xtc\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + 13 + "}\n" + "TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test104() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t ** \t@param \n\t * \t@param xtc\n\t * \t@param xtm\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertSortedResults("TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test105() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param xtc\n\t * \t@param xtm\n\t * \t@param <TM>\n\t ** \t@param \n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "** \t@param ", 0);
        this.assertSortedResults("");
    }

    public void test106() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<", 2);
        this.assertSortedResults("TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test107() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <T\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<T", 2);
        this.assertSortedResults("TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test108() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <TC\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<TC", 2);
        this.assertSortedResults("");
    }

    public void test109() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <TM>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<TM");
        this.assertSortedResults("TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test110() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <TM>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<TM>");
        this.assertSortedResults("TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test111() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <TM>\n\t * \t@param <TM>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<TM");
        this.assertSortedResults("");
    }

    public void test112() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <TM>\n\t * \t@param <TM>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<TM>", 2);
        this.assertSortedResults("");
    }

    public void test113() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@param ab\n\t */\n\tvoid foo(Object ab1, Object ab2) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertSortedResults("ab1[JSDOC_PARAM_REF]{ab1, null, null, ab1, null, " + this.positions + 14 + "}\n" + "ab2[JSDOC_PARAM_REF]{ab2, null, null, ab2, null, " + this.positions + 13 + "}");
    }

    public void test114() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <ZZZ>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + "14}\n" + "xtc[JSDOC_PARAM_REF]{xtc, null, null, xtc, null, " + this.positions + "13}\n" + "TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test115() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <ZZZ>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "<", 2);
        this.assertSortedResults("TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test116() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <ZZZ>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "Z");
        this.assertSortedResults("");
    }

    public void test117() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param <ZZZ>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "ZZZ");
        this.assertSortedResults("");
    }

    public void test118() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param ZZZ>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, [105, 108], 14}\nxtc[JSDOC_PARAM_REF]{xtc, null, null, xtc, null, [105, 108], 13}\nTM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, [105, 108], 8}");
    }

    public void test119() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param ZZZ>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "Z");
        this.assertSortedResults("");
    }

    public void test120() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param ZZZ>\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "ZZZ");
        this.assertSortedResults("");
    }

    public void test121() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param ZZZ.\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + "14}\n" + "xtc[JSDOC_PARAM_REF]{xtc, null, null, xtc, null, " + this.positions + "13}\n" + "TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test122() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param ZZZ#\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + "14}\n" + "xtc[JSDOC_PARAM_REF]{xtc, null, null, xtc, null, " + this.positions + "13}\n" + "TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test123() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods<TC> {\n\t/**\n\t * Completion after:\n\t * \t@param ZZZ?\n\t */\n\t<TM> void foo(Class<TM> xtm, Class<TC> xtc) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "@param ", 0);
        this.assertSortedResults("xtm[JSDOC_PARAM_REF]{xtm, null, null, xtm, null, " + this.positions + "14}\n" + "xtc[JSDOC_PARAM_REF]{xtc, null, null, xtc, null, " + this.positions + "13}\n" + "TM[JSDOC_PARAM_REF]{<TM>, null, null, TM, null, " + this.positions + 8 + "}");
    }

    public void test130() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTest\n\t */\n\tBasicTestMethods() {}\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTest", 2);
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test131() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTest\n\t * @since 3.2\n\t */\n\tBasicTestMethods() {}\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTest", 2);
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test132() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTest\n\t */\n\tBasicTestMethods() {}\n\t<T> BasicTestMethods(int xxx, float real, Class<T> clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTest", 2);
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, <T:Ljava.lang.Object;>(IFLjava.lang.Class<TT;>;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test133() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#BasicTest\n\t */\n\tBasicTestMethods() {}\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTest", 3);
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test134() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see javadoc.methods.tags.BasicTestMethods#BasicTest\n\t */\n\tBasicTestMethods() {}\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTest", 3);
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test135() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/methods/tags/BasicTestMethods.js", "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see OtherTypes#O\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/methods/tags/OtherTypes.js", "package javadoc.methods.tags;\npublic class OtherTypes {\n\tOtherTypes() {};\n}"};
        this.completeInJavadoc(sources, true, "O", 2);
        this.assertResults("OtherTypes[FUNCTION_REF<CONSTRUCTOR>]{OtherTypes(), Ljavadoc.methods.tags.OtherTypes;, ()V, OtherTypes, null, " + this.positions + 8 + "}");
    }

    public void test136() throws JavaScriptModelException {
        String[] sources = new String[]{"/Completion/src/javadoc/methods/tags/BasicTestMethods.js", "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see OtherTypes#O implicit default constructor\n\t */\n\tvoid foo() {};\n}", "/Completion/src/javadoc/methods/tags/OtherTypes.js", "package javadoc.methods.tags;\npublic class OtherTypes {\n}"};
        this.completeInJavadoc(sources, true, "O", 2);
        this.assertResults("OtherTypes[FUNCTION_REF<CONSTRUCTOR>]{OtherTypes(), Ljavadoc.methods.tags.OtherTypes;, ()V, OtherTypes, null, " + this.positions + 8 + "}");
    }

    public void test137() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #\n\t */\n\tBasicTestMethods() {}\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test138() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #\n\t * @since 3.2\n\t */\n\tBasicTestMethods() {}\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test139() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see #\n\t */\n\t<T> BasicTestMethods() {}\n\t<T, U> BasicTestMethods(int xxx, Class<T> cl1, Class<U> cl2) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, Class, Class), Ljavadoc.methods.tags.BasicTestMethods;, <T:Ljava.lang.Object;U:Ljava.lang.Object;>(ILjava.lang.Class<TT;>;Ljava.lang.Class<TU;>;)V, BasicTestMethods, (xxx, cl1, cl2), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, <T:Ljava.lang.Object;>()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test140() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\n/**\n * Completion after:\n * \t@see #\n */\npublic class BasicTestMethods {\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "#", 0);
        this.assertResults("wait[FUNCTION_REF]{wait(long, int), Ljava.lang.Object;, (JI)V, wait, (millis, nanos), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(long), Ljava.lang.Object;, (J)V, wait, (millis), " + this.positions + 29 + "}\n" + "wait[FUNCTION_REF]{wait(), Ljava.lang.Object;, ()V, wait, null, " + this.positions + 29 + "}\n" + "toString[FUNCTION_REF]{toString(), Ljava.lang.Object;, ()Ljava.lang.String;, toString, null, " + this.positions + 29 + "}\n" + "notifyAll[FUNCTION_REF]{notifyAll(), Ljava.lang.Object;, ()V, notifyAll, null, " + this.positions + 29 + "}\n" + "notify[FUNCTION_REF]{notify(), Ljava.lang.Object;, ()V, notify, null, " + this.positions + 29 + "}\n" + "hashCode[FUNCTION_REF]{hashCode(), Ljava.lang.Object;, ()I, hashCode, null, " + this.positions + 29 + "}\n" + "getClass[FUNCTION_REF]{getClass(), Ljava.lang.Object;, ()Ljava.lang.Class;, getClass, null, " + this.positions + 29 + "}\n" + "finalize[FUNCTION_REF]{finalize(), Ljava.lang.Object;, ()V, finalize, null, " + this.positions + 29 + "}\n" + "equals[FUNCTION_REF]{equals(Object), Ljava.lang.Object;, (Ljava.lang.Object;)Z, equals, (obj), " + this.positions + 29 + "}\n" + "clone[FUNCTION_REF]{clone(), Ljava.lang.Object;, ()Ljava.lang.Object;, clone, null, " + this.positions + 29 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test141() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test142() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(\n\t * @since 3.2\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test143() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods( trailing text\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test144() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(   ...\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test145() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(        \n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test146() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(     ????\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test147() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(  ,,\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
    }

    public void test148() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see BasicTestMethods#BasicTestMethods(\n\t */\n\tBasicTestMethods() {}\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}\n" + "BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test149() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\t/**\n\t * Completion after:\n\t * \t@see javadoc.methods.tags.BasicTestMethods#BasicTestMethods(\n\t */\n\tvoid foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMethods(");
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(), Ljavadoc.methods.tags.BasicTestMethods;, ()V, BasicTestMethods, null, " + this.positions + 8 + "}");
    }

    public void test150() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(in\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "in");
        this.assertResults("int[KEYWORD]{int, null, null, int, null, " + this.positions + 18 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 11 + "}");
    }

    public void test151() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(int\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "int");
        this.assertResults("int[KEYWORD]{int, null, null, int, null, " + this.positions + 22 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 11 + "}");
    }

    public void test152() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(int aaa, fl\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "fl");
        this.assertResults("float[KEYWORD]{float, null, null, float, null, " + this.positions + 18 + "}");
    }

    public void test153() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(int aaa, float\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "float");
        this.assertResults("float[KEYWORD]{float, null, null, float, null, " + this.positions + 22 + "}");
    }

    public void test154() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(int, float, Cla\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "Cla");
        this.assertResults("Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 21 + "}");
    }

    public void test155() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(int, float, java.lang.\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "java.lang.");
        this.assertSortedResults("Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 18 + "}\n" + "CloneNotSupportedException[TYPE_REF]{CloneNotSupportedException, java.lang, Ljava.lang.CloneNotSupportedException;, null, null, " + this.positions + 18 + "}\n" + "Error[TYPE_REF]{Error, java.lang, Ljava.lang.Error;, null, null, " + this.positions + 18 + "}\n" + "Exception[TYPE_REF]{Exception, java.lang, Ljava.lang.Exception;, null, null, " + this.positions + 18 + "}\n" + "IllegalMonitorStateException[TYPE_REF]{IllegalMonitorStateException, java.lang, Ljava.lang.IllegalMonitorStateException;, null, null, " + this.positions + 18 + "}\n" + "InterruptedException[TYPE_REF]{InterruptedException, java.lang, Ljava.lang.InterruptedException;, null, null, " + this.positions + 18 + "}\n" + "Object[TYPE_REF]{Object, java.lang, Ljava.lang.Object;, null, null, " + this.positions + 18 + "}\n" + "RuntimeException[TYPE_REF]{RuntimeException, java.lang, Ljava.lang.RuntimeException;, null, null, " + this.positions + 18 + "}\n" + "String[TYPE_REF]{String, java.lang, Ljava.lang.String;, null, null, " + this.positions + 18 + "}\n" + "Throwable[TYPE_REF]{Throwable, java.lang, Ljava.lang.Throwable;, null, null, " + this.positions + 18 + "}");
    }

    public void test156() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(int, float, java.lang.Cla\n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "java.lang.Cla");
        this.assertResults("Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 18 + "}");
    }

    public void test157() throws JavaScriptModelException {
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMethods(int, float, Class\n\t * \n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "Class");
        this.assertResults("Class[TYPE_REF]{Class, java.lang, Ljava.lang.Class;, null, null, " + this.positions + 25 + "}");
    }

    public void test160() throws JavaScriptModelException {
        this.oldOptions = JavaScriptCore.getOptions();
        try {
            Hashtable<String, String> options = new Hashtable<String, String>(this.oldOptions);
            options.put("org.eclipse.wst.jsdt.core.codeComplete.camelCaseMatch", "enabled");
            JavaScriptCore.setOptions(options);
            String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid foo() {}\n\t/**\n\t * Completion after:\n\t * \t@see #BTM\n\t * \n\t */\n\tBasicTestMethods(int xxx, float real, Class clazz) {}\n}\n";
            this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BTM");
            this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(int, float, Class), Ljavadoc.methods.tags.BasicTestMethods;, (IFLjava.lang.Class;)V, BasicTestMethods, (xxx, real, clazz), " + this.positions + 8 + "}");
        }
        finally {
            JavaScriptCore.setOptions((Hashtable)this.oldOptions);
        }
    }

    public void test161() throws JavaScriptModelException {
        this.oldOptions = JavaScriptCore.getOptions();
        try {
            Hashtable<String, String> options = new Hashtable<String, String>(this.oldOptions);
            options.put("org.eclipse.wst.jsdt.core.codeComplete.camelCaseMatch", "enabled");
            JavaScriptCore.setOptions(options);
            String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tvoid oneTwoThree(int i) {}\n\t/**\n\t * Completion after:\n\t * \t@see #oTT\n\t * \n\t */\n\tBasicTestMethods() {}\n}\n";
            this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "oTT");
            this.assertResults("oneTwoThree[FUNCTION_REF]{oneTwoThree(int), Ljavadoc.methods.tags.BasicTestMethods;, (I)V, oneTwoThree, (i), " + this.positions + "24}");
        }
        finally {
            JavaScriptCore.setOptions((Hashtable)this.oldOptions);
        }
    }

    public void test162() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tpublic void oneTwoThree(Object... o) {}\n\t/**\n\t * Completion after:\n\t * \t@see #oneTwoT\n\t * \n\t */\n\tBasicTestMethods() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "oneTwoT", 2);
        this.assertResults("oneTwoThree[FUNCTION_REF]{oneTwoThree(Object...), Ljavadoc.methods.tags.BasicTestMethods;, ([Ljava.lang.Object;)V, oneTwoThree, (o), " + this.positions + 29 + "}");
    }

    public void test163() throws JavaScriptModelException {
        this.setUpProjectOptions("1.5");
        String source = "package javadoc.methods.tags;\npublic class BasicTestMethods {\n\tpublic BasicTestMethods(Object... o) {}\n\t/**\n\t * Completion after:\n\t * \t@see #BasicTestMeth\n\t * \n\t */\n\tvoid foo() {}\n}\n";
        this.completeInJavadoc("/Completion/src/javadoc/methods/tags/BasicTestMethods.js", source, true, "BasicTestMeth", 3);
        this.assertResults("BasicTestMethods[FUNCTION_REF<CONSTRUCTOR>]{BasicTestMethods(Object...), Ljavadoc.methods.tags.BasicTestMethods;, ([Ljava.lang.Object;)V, BasicTestMethods, (o), " + this.positions + 8 + "}");
    }
}

