/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class JavaModelTests
extends ModifyingResourceTests {
    public static Test suite() {
        return JavaModelTests.buildModelTestSuite(JavaModelTests.class);
    }

    public JavaModelTests(String name) {
        super(name);
    }

    protected int indexOf(String projectName, IJavaScriptProject[] projects) {
        int i = 0;
        int length = projects.length;
        while (i < length) {
            if (projects[i].getElementName().equals(projectName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void testAddFileToNonJavaProject() throws CoreException {
        IJavaScriptModel model = this.getJavaModel();
        IJavaScriptProject[] projects = model.getJavaScriptProjects();
        JavaModelTests.assertTrue((String)"Project P should not be present already", (this.indexOf("P", projects) == -1 ? 1 : 0) != 0);
        try {
            this.createProject("P");
            this.createFile("/P/toto.txt", "");
            projects = model.getJavaScriptProjects();
            JavaModelTests.assertTrue((String)"Project P should not be present", (this.indexOf("P", projects) == -1 ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCreateNonJavaProject() throws CoreException {
        try {
            IProject project = this.createProject("NonJava");
            JavaModelTests.waitForAutoBuild();
            IMarker[] markers = project.findMarkers(null, true, 2);
            this.assertMarkers("Unexpected markers", "", markers);
        }
        finally {
            this.deleteProject("NonJava");
        }
    }

    public void testContains1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{""});
            IFile file = this.getFile("/P/X.js");
            JavaModelTests.assertTrue((String)"/P/X.java should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            file = this.getFile("/P/read.txt");
            JavaModelTests.assertTrue((String)"/P/read.txt should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            IFolder folder = this.getFolder("/P/p");
            JavaModelTests.assertTrue((String)"/P/p should be in model", (boolean)this.getJavaModel().contains((IResource)folder));
            file = this.createFile("/P/X.js", "");
            project.getProject().close(null);
            JavaModelTests.assertTrue((String)"/P/X.java should be in model (even if project is closed)", (boolean)this.getJavaModel().contains((IResource)file));
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testContains2() throws CoreException {
        try {
            IProject project = this.createJavaProject("P1", new String[]{""}).getProject();
            JavaModelTests.assertTrue((String)"/P1 should be in model", (boolean)this.getJavaModel().contains((IResource)project));
            project = this.createProject("P2");
            JavaModelTests.assertTrue((String)"/P2 should be in model", (boolean)this.getJavaModel().contains((IResource)project));
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testContains3() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""});
            IFile file = this.createFile("/P/X.js", "");
            JavaModelTests.assertTrue((String)"/P/X.java should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            file = this.createFile("/P/X.class", "");
            JavaModelTests.assertTrue((String)"/P/X.class should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            file = this.createFile("/P/read.txt", "");
            JavaModelTests.assertTrue((String)"/P/read.txt should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            IFolder folder = this.createFolder("/P/p");
            JavaModelTests.assertTrue((String)"/P/p should be in model", (boolean)this.getJavaModel().contains((IResource)folder));
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testContains4() throws CoreException {
        try {
            this.createJavaProject("P", new String[0]);
            IFile file = this.createFile("/P/X.js", "");
            JavaModelTests.assertTrue((String)"/P/X.java should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            file = this.createFile("/P/X.class", "");
            JavaModelTests.assertTrue((String)"/P/X.class should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            file = this.createFile("/P/read.txt", "");
            JavaModelTests.assertTrue((String)"/P/read.txt should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            IFolder folder = this.createFolder("/P/p");
            JavaModelTests.assertTrue((String)"/P/p should be in model", (boolean)this.getJavaModel().contains((IResource)folder));
            folder = this.getFolder("/P/bin");
            JavaModelTests.assertTrue((String)"/P/bin should not be in model", (!this.getJavaModel().contains((IResource)folder) ? 1 : 0) != 0);
            file = this.createFile("/P/bin/X.class", "");
            JavaModelTests.assertTrue((String)"/P/bin/X.class should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            this.createFolder("/P/bin/image");
            file = this.createFile("/P/bin/image/ok.gif", "");
            JavaModelTests.assertTrue((String)"/P/bin/image/ok.gif should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testContains5() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{"src"});
            IFile file = this.createFile("/P/src/X.js", "");
            JavaModelTests.assertTrue((String)"/P/src/X.java should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            this.createFolder("/P/src/image");
            file = this.createFile("/P/src/image/ok.gif", "");
            JavaModelTests.assertTrue((String)"/P/src/image/ok.gif should not be in model", (boolean)this.getJavaModel().contains((IResource)file));
            file = this.createFile("/P/bin/X.class", "");
            JavaModelTests.assertTrue((String)"/P/bin/X.class should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            this.createFolder("/P/bin/image");
            file = this.createFile("/P/bin/image/ok.gif", "");
            JavaModelTests.assertTrue((String)"/P/bin/image/ok.gif should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            file = this.createFile("/P/src/X.class", "");
            JavaModelTests.assertTrue((String)"/P/src/X.class should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            file = this.createFile("/P/src/read.txt", "");
            JavaModelTests.assertTrue((String)"/P/src/read.txt should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            IFolder folder = this.createFolder("/P/src/p");
            JavaModelTests.assertTrue((String)"/P/src/p should be in model", (boolean)this.getJavaModel().contains((IResource)folder));
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testContains6() throws CoreException {
        try {
            this.createJavaProject("P", new String[]{""});
            IFile file = this.createFile("/P/X.js", "");
            JavaModelTests.assertTrue((String)"/P/X.java should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            this.createFolder("/P/image");
            file = this.createFile("/P/image/ok.gif", "");
            JavaModelTests.assertTrue((String)"/P/image/ok.gif should not be in model", (boolean)this.getJavaModel().contains((IResource)file));
            file = this.createFile("/P/bin/X.class", "");
            JavaModelTests.assertTrue((String)"/P/bin/X.class should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            this.createFolder("/P/bin/image");
            file = this.createFile("/P/bin/image/ok.gif", "");
            JavaModelTests.assertTrue((String)"/P/bin/image/ok.gif should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            file = this.createFile("/P/X.class", "");
            JavaModelTests.assertTrue((String)"/P/X.class should not be in model", (!this.getJavaModel().contains((IResource)file) ? 1 : 0) != 0);
            file = this.createFile("/P/read.txt", "");
            JavaModelTests.assertTrue((String)"/P/read.txt should be in model", (boolean)this.getJavaModel().contains((IResource)file));
            IFolder folder = this.createFolder("/P/p");
            JavaModelTests.assertTrue((String)"/P/p should be in model", (boolean)this.getJavaModel().contains((IResource)folder));
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testCreatePkgHandleInDifferentProject() throws CoreException {
        try {
            this.createJavaProject("P1", new String[0]);
            IFolder folder = this.createFolder("/P1/lib/x/y");
            this.createJavaProject("P2", new String[0], new String[]{"/P1/lib"});
            IJavaScriptElement element = JavaScriptCore.create((IFolder)folder);
            this.assertElementEquals("Unexpected element", "x.y [in /P1/lib [in P2]]", element);
        }
        catch (Throwable throwable) {
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testFindLineSeparator01() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFile("/P/X.js", "public class X {\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            JavaModelTests.assertEquals((String)"\n", (String)cu.findRecommendedLineSeparator());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testFindLineSeparator02() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFile("/P/X.js", "public class X {\r\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            JavaModelTests.assertEquals((String)"\r\n", (String)cu.findRecommendedLineSeparator());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testFindLineSeparator03() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFile("/P/X.js", "");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            JavaModelTests.assertEquals((String)System.getProperty("line.separator"), (String)cu.findRecommendedLineSeparator());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testFindLineSeparator04() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFolder("/P/p");
            IPackageFragment pkg = this.getPackage("/P/p");
            JavaModelTests.assertEquals((String)System.getProperty("line.separator"), (String)pkg.findRecommendedLineSeparator());
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testGetJavaProject() {
        IJavaScriptModel model = this.getJavaModel();
        JavaModelTests.assertTrue((String)"project should be null", (model.getJavaScriptProject() == null ? 1 : 0) != 0);
    }

    public void testGetJavaProjects1() throws CoreException {
        IJavaScriptModel model = this.getJavaModel();
        IJavaScriptProject[] projects = model.getJavaScriptProjects();
        JavaModelTests.assertTrue((String)"Project P should not be present already", (this.indexOf("P", projects) == -1 ? 1 : 0) != 0);
        try {
            this.createJavaProject("P", new String[0]);
            projects = model.getJavaScriptProjects();
            JavaModelTests.assertTrue((String)"Project P should be present", (this.indexOf("P", projects) != -1 ? 1 : 0) != 0);
            this.deleteProject("P");
            projects = model.getJavaScriptProjects();
            JavaModelTests.assertTrue((String)"Project P should not be present any longer", (this.indexOf("P", projects) == -1 ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testGetJavaProjects2() throws CoreException {
        IJavaScriptModel model = this.getJavaModel();
        IJavaScriptProject[] projects = model.getJavaScriptProjects();
        JavaModelTests.assertTrue((String)"Project P should not be present already", (this.indexOf("P", projects) == -1 ? 1 : 0) != 0);
        try {
            this.createProject("P");
            projects = model.getJavaScriptProjects();
            JavaModelTests.assertTrue((String)"Project P should not be present", (this.indexOf("P", projects) == -1 ? 1 : 0) != 0);
        }
        finally {
            this.deleteProject("P");
        }
    }

    public void testGetNonJavaResources() throws CoreException {
        try {
            IJavaScriptModel model = this.getJavaModel();
            this.createJavaProject("JP", new String[0]);
            this.assertResourceNamesEqual("Unexpected non-Java resources", "", model.getNonJavaScriptResources());
            this.createProject("SP1");
            this.assertResourceNamesEqual("Unexpected non-Java resources after creation of SP1", "SP1", model.getNonJavaScriptResources());
            this.createProject("SP2");
            this.assertResourceNamesEqual("Unexpected non-Java resources after creation of SP2", "SP1\nSP2", model.getNonJavaScriptResources());
            this.deleteProject("SP1");
            this.assertResourceNamesEqual("Unexpected non-Java resources after deletion of SP1", "SP2", model.getNonJavaScriptResources());
        }
        finally {
            this.deleteProject("SP1");
            this.deleteProject("SP2");
            this.deleteProject("JP");
        }
    }

    public void testGetSchedulingRule1() {
        IJavaScriptProject project = this.getJavaProject("P");
        JavaModelTests.assertEquals((String)"Unexpected scheduling rule", (Object)project.getResource(), (Object)project.getSchedulingRule());
    }

    public void testGetSchedulingRule2() {
        IFolder folder = this.getFolder("/P/src");
        IPackageFragmentRoot root = this.getJavaProject("P").getPackageFragmentRoot((IResource)folder);
        JavaModelTests.assertEquals((String)"Unexpected scheduling rule", (Object)root.getResource(), (Object)root.getSchedulingRule());
    }

    public void testGetSchedulingRule3() {
        IPackageFragmentRoot root1 = this.getJavaProject("P1").getPackageFragmentRoot("c:\\some.jar");
        ISchedulingRule rule1 = root1.getSchedulingRule();
        IPackageFragmentRoot root2 = this.getJavaProject("P2").getPackageFragmentRoot("c:\\some.jar");
        ISchedulingRule rule2 = root2.getSchedulingRule();
        JavaModelTests.assertTrue((String)"Rule 1 should contain rule 2", (boolean)rule1.contains(rule2));
        JavaModelTests.assertTrue((String)"Rule 1 should conflict with rule 2", (boolean)rule1.isConflicting(rule2));
        JavaModelTests.assertTrue((String)"Rule 2 should contain rule 1", (boolean)rule2.contains(rule1));
        JavaModelTests.assertTrue((String)"Rule 2 should conflict with rule 1", (boolean)rule2.isConflicting(rule1));
    }

    public void testGetSchedulingRule4() {
        IFolder folder = this.getFolder("/P/src");
        IPackageFragment pkg = this.getJavaProject("P").getPackageFragmentRoot((IResource)folder).getPackageFragment("p");
        JavaModelTests.assertEquals((String)"Unexpected scheduling rule", (Object)pkg.getResource(), (Object)pkg.getSchedulingRule());
    }

    public void testInitializeAfterLoad() throws CoreException {
        this.simulateExitRestart();
        JavaScriptCore.initializeAfterLoad(null);
    }

    public void testPreProcessingResourceChangedListener03() throws CoreException {
        final int[] eventType = new int[1];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                eventType[0] = eventType[0] | event.getType();
            }
        };
        try {
            JavaScriptCore.addPreProcessingResourceChangedListener((IResourceChangeListener)listener, (int)16);
            this.createProject("Test");
            JavaModelTests.waitForAutoBuild();
            JavaModelTests.assertEquals((String)"Unexpected event type", (int)16, (int)eventType[0]);
        }
        finally {
            JavaScriptCore.removePreProcessingResourceChangedListener((IResourceChangeListener)listener);
            this.deleteProject("Test");
        }
    }

    public void testPreProcessingResourceChangedListener04() throws CoreException {
        final int[] eventType = new int[1];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                eventType[0] = eventType[0] | event.getType();
            }
        };
        try {
            JavaScriptCore.addPreProcessingResourceChangedListener((IResourceChangeListener)listener, (int)17);
            this.createProject("Test");
            JavaModelTests.waitForAutoBuild();
            JavaModelTests.assertEquals((String)"Unexpected event type", (int)17, (int)eventType[0]);
        }
        finally {
            JavaScriptCore.removePreProcessingResourceChangedListener((IResourceChangeListener)listener);
            this.deleteProject("Test");
        }
    }
}

