/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;
import org.junit.Assert;
import org.junit.Test;

public class TestTemplateModeCompletionProposal
extends AbstractSourceViewerTest {
    @Test
    public void testModeProposals() throws Exception {
        this.fileName = "modeTest.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int chars = 35;
        int line = 17;
        int offset = document.getLineOffset(line) + chars;
        ICompletionProposal[] proposals = this.getProposals(line, chars);
        this.assertProposalExists("mode1", proposals);
        this.assertProposalExists("mode2", proposals);
        this.assertProposalExists("mode3", proposals);
        proposals = this.getXMLProposals(offset);
        this.assertProposalExists("\"#all\"", proposals);
    }

    private void assertProposalExists(String expected, ICompletionProposal[] proposal) throws Exception {
        Assert.assertNotNull((String)"No proposals.", (Object)proposal);
        boolean foundsw = false;
        int i = 0;
        while (i < proposal.length) {
            if (proposal[i].getDisplayString().equals(expected)) {
                foundsw = true;
                break;
            }
            ++i;
        }
        if (!foundsw) {
            Assert.fail((String)("Proposal " + expected + " was not found in the proposal list."));
        }
    }
}

