/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class GlobalFunctionTests_Edited
extends TestCase {
    private static final String TEST_NAME = "Test Global Functions JavaScript Content Assist after Edit";
    private static TestProjectSetup fTestProjectSetup;

    public GlobalFunctionTests_Edited() {
        super(TEST_NAME);
    }

    public GlobalFunctionTests_Edited(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(GlobalFunctionTests_Edited.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false){

            @Override
            public void additionalSetUp() throws Exception {
                this.editFile("GlobalFunctions.js", 0, 9, 4, "function");
                this.editFile("GlobalFunctions.js", 4, 9, 4, "function");
                this.editFile("NamedFunctionAssignedToVariables.js", 0, 4, 4, "foo1Edit");
                this.editFile("NamedFunctionAssignedToVariables.js", 0, 24, 4, "foo1Edit");
                this.editFile("NamedFunctionAssignedToVariables.js", 4, 0, 4, "foo2Edit");
                this.editFile("NamedFunctionAssignedToVariables.js", 4, 20, 4, "foo2Edit");
            }
        };
        return fTestProjectSetup;
    }

    public void testFindFunctions_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionOne() - Global", "functionTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global", "funcEight(paramOne) : String - Global", "funcNine(paramOne) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalFunctions.html", 8, 1, expectedProposals);
    }

    public void testFindFunctions_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionOne() - Global", "functionTwo() : String - Global", "funcThree(paramOne) - Global", "funcFour(paramOne, paramTwo) : Number - Global", "funcFive(Number paramOne, String paramTwo) : String - Global", "funcSix(paramOne, String paramTwo) : Number - Global", "funcSeven(String paramOne, paramTwo) : Number - Global", "funcEight(paramOne) : String - Global", "funcNine(paramOne) : Number - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalFunctions.html", 10, 4, expectedProposals);
    }

    public void testFindFunctions_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"functionTwo() : String - Global", "funcThree(paramOne) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "GlobalFunctions.html", 12, 5, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionNotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Edit : Function - Global", "foo1Edit(param2) - Global", "foo2Edit : Function - Global", "foo2Edit(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 6, 0, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionStarted1() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Edit : Function - Global", "foo1Edit(param2) - Global", "foo2Edit : Function - Global", "foo2Edit(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 8, 1, expectedProposals);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionNotStarted_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored", "foo1EditIgnored", "foo2EditIgnored", "foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 6, 0, expectedProposals, true, false);
    }

    public void testNamedFunctionsAssignedToVariables_ExpressionStarted1_NegativeTest() throws Exception {
        String[][] expectedProposals = new String[][]{{"foo1Ignored", "foo2Ignored", "foo1EditIgnored", "foo2EditIgnored", "foo1 : Function - Global", "foo1(param2) - Global", "foo2 : Function - Global", "foo2(param3, param4) - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "NamedFunctionAssignedToVariables.html", 8, 1, expectedProposals, true, false);
    }
}

