/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.tests.navigator;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ISEIChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.IWebServiceChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.WebServiceProblemsDecorator;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.testutils.IWaitCondition;
import org.eclipse.jst.ws.jaxws.testutils.assertions.Assertions;
import org.eclipse.jst.ws.jaxws.testutils.assertions.ConditionCheckException;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;

public class WebServiceDecoratorTest
extends MockObjectTestCase {
    private MyWebServiceProblemsDecorator decorator;
    private TestProject testProject;
    private IWebService ws;
    private IServiceEndpointInterface sei;
    private IWebServiceProject wsProject;
    private IWebMethod webMethod;
    private IWebParam webParam;
    private Mock<IWebServiceChildList> wsChildList;
    private Mock<ISEIChildList> seiChildList;
    private IPackageFragment testPackage;
    private IType seiType;
    private IType wsImplType;
    private JaxWsWorkspaceResource jaxwsResource;
    private static final int NO_ERROR = 0;
    private static final String SEI_CONTENT = "@javax.jws.WebService(name=\"{0}\")\npublic interface ISei '{'\n@javax.jws.WebMethod(operationName=\"{1}\")\npublic void testMethod(@javax.jws.WebParam(name=\"{2}\") String s);}";
    private static final String IMPL_CONTENT = "@javax.jws.WebService(serviceName=\"{0}\", endpointInterface=\"test.ISei\")\npublic class EndpointClass '{'\npublic void testMethod(String s)'{'}}";

    public void setUp() throws CoreException {
        this.decorator = new MyWebServiceProblemsDecorator();
        this.testProject = null;
    }

    protected void tearDown() throws Exception {
        if (this.testProject != null) {
            this.testProject.dispose();
            this.jaxwsResource.stopSynchronizing();
        }
    }

    public void testComputeAdornmentForObject() {
        WebServiceDecoratorTest.assertEquals((String)"Unexpected adornment", (int)0, (int)this.decorator.computeAdornmentFlags(new Object()));
    }

    private void createWsContent(String seiName, String webMethodName, String paramName, String serviceName) throws CoreException, WsDOMLoadCanceledException, IOException {
        IProject webP = TestProjectsUtils.createWeb25Project((String)("WebTester" + System.currentTimeMillis()));
        this.testProject = new TestProject(webP);
        this.testProject.setAptProcessingEnabled(true, false);
        this.jaxwsResource = new JaxWsWorkspaceResource(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.jaxwsResource.load(null);
        this.jaxwsResource.startSynchronizing();
        this.testPackage = this.testProject.createPackage("test");
        this.seiType = this.testProject.createType(this.testPackage, "ISei.java", MessageFormat.format(SEI_CONTENT, seiName, webMethodName, paramName));
        this.wsImplType = this.testProject.createType(this.testPackage, "EndpointClass.java", MessageFormat.format(IMPL_CONTENT, serviceName));
        this.testProject.build(15);
    }

    private void initWsDomObjects() throws WsDOMLoadCanceledException {
        this.wsProject = DomUtil.INSTANCE.findProjectByName(this.jaxwsResource.getDOM(), this.testProject.getProject().getName());
        WebServiceDecoratorTest.assertNotNull((Object)this.wsProject);
        this.ws = (IWebService)this.wsProject.getWebServices().iterator().next();
        this.sei = (IServiceEndpointInterface)this.wsProject.getServiceEndpointInterfaces().iterator().next();
        this.webMethod = (IWebMethod)this.sei.getWebMethods().iterator().next();
        this.webParam = (IWebParam)this.webMethod.getParameters().iterator().next();
        this.wsChildList = this.mock(IWebServiceChildList.class);
        this.wsChildList.stubs().method("getWSChildList").will(this.returnValue(this.elist(new EObject[]{this.ws})));
        this.seiChildList = this.mock(ISEIChildList.class);
        this.seiChildList.stubs().method("getSEIChildList").will(this.returnValue(this.elist(new EObject[]{this.sei})));
    }

    private void waitForAptMarkersAppear() {
        Assertions.waitAssert((IWaitCondition)new IWaitCondition(){

            public boolean checkCondition() throws ConditionCheckException {
                try {
                    return WebServiceDecoratorTest.this.findAptMarkers().size() > 0;
                }
                catch (CoreException e) {
                    throw new ConditionCheckException((Throwable)e);
                }
            }
        }, (String)"APT markers did not appear");
    }

    private Collection<IMarker> findAptMarkers() throws CoreException {
        IMarker m;
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = this.testProject.getProject().findMarkers("org.eclipse.jdt.apt.core.compile.problem", false, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = iMarkerArray[n2];
            result.add(m);
            ++n2;
        }
        iMarkerArray = this.testProject.getProject().findMarkers("org.eclipse.jdt.apt.core.nonreconcile.compile.problem", false, 2);
        n = iMarkerArray.length;
        n2 = 0;
        while (n2 < n) {
            m = iMarkerArray[n2];
            result.add(m);
            ++n2;
        }
        return result;
    }

    private void waitForNoAptMarkers() {
        Assertions.waitAssert((IWaitCondition)new IWaitCondition(){

            public boolean checkCondition() throws ConditionCheckException {
                try {
                    return WebServiceDecoratorTest.this.testProject.getProject().findMarkers("org.eclipse.jdt.apt.core.nonreconcile.compile.problem", false, 2).length == 0;
                }
                catch (CoreException e) {
                    throw new ConditionCheckException((Throwable)e);
                }
            }
        }, (String)"APT markers did not disappear");
    }

    private EList<EObject> elist(EObject ... elements) {
        BasicEList result = new BasicEList();
        EObject[] eObjectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObj = eObjectArray[n2];
            result.add((Object)eObj);
            ++n2;
        }
        return result;
    }

    private void fixAptErrors() throws CoreException, AnnotationGeneratorException {
        AnnotationWriter annWriter = AnnotationWriter.getInstance();
        IAnnotationInspector seiInspector = AnnotationFactory.createAnnotationInspector((IType)this.seiType);
        IAnnotation seiWsAnnotation = seiInspector.inspectType("javax.jws.WebService");
        seiWsAnnotation.getParamValuePairs().clear();
        annWriter.update(seiWsAnnotation);
        IMethod seiMethod = this.seiType.getMethods()[0];
        IAnnotation seiWebMethodAnnotation = seiInspector.inspectMethod(seiMethod, "javax.jws.WebMethod");
        annWriter.remove(seiWebMethodAnnotation);
        ITypeParameter seiMethodParam = seiMethod.getTypeParameter(seiMethod.getParameterNames()[0]);
        IAnnotation seiWebParamAnnotation = seiInspector.inspectParam(seiMethodParam, "javax.jws.WebParam");
        annWriter.remove(seiWebParamAnnotation);
        IAnnotationInspector wsImplInspector = AnnotationFactory.createAnnotationInspector((IType)this.wsImplType);
        IAnnotation wsImplWsAnnotation = wsImplInspector.inspectType("javax.jws.WebService");
        HashSet<IParamValuePair> newAnnValues = new HashSet<IParamValuePair>();
        for (IParamValuePair pair : wsImplWsAnnotation.getParamValuePairs()) {
            if (pair.getParam().equals("serviceName")) {
                newAnnValues.add(AnnotationFactory.createParamValuePairValue((String)"serviceName", (IValue)AnnotationFactory.createStringValue((String)"MyServiceName")));
                continue;
            }
            newAnnValues.add(pair);
        }
        wsImplWsAnnotation.getParamValuePairs().clear();
        wsImplWsAnnotation.getParamValuePairs().addAll(newAnnValues);
        annWriter.update(wsImplWsAnnotation);
        this.waitForNoAptMarkers();
    }

    private void checkNoErrorsAdornment() {
        WebServiceDecoratorTest.assertEquals((String)"Unexpected adornment", (int)0, (int)this.decorator.computeAdornmentFlags(this.wsChildList.proxy()));
        WebServiceDecoratorTest.assertEquals((String)"Unexpected adornment", (int)0, (int)this.decorator.computeAdornmentFlags(this.seiChildList.proxy()));
        WebServiceDecoratorTest.assertEquals((String)"Unexpected adornment", (int)0, (int)this.decorator.computeAdornmentFlags(this.ws));
        WebServiceDecoratorTest.assertEquals((String)"Unexpected adornment", (int)0, (int)this.decorator.computeAdornmentFlags(this.sei));
        WebServiceDecoratorTest.assertEquals((String)"Unexpected adornment", (int)0, (int)this.decorator.computeAdornmentFlags(this.webMethod));
        WebServiceDecoratorTest.assertEquals((String)"Unexpected adornment", (int)0, (int)this.decorator.computeAdornmentFlags(this.webParam));
    }

    private class MyWebServiceProblemsDecorator
    extends WebServiceProblemsDecorator {
        private MyWebServiceProblemsDecorator() {
        }

        public int computeAdornmentFlags(Object obj) {
            return super.computeAdornmentFlags(obj);
        }
    }
}

