/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.tests.navigator;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.DOMAdapterFactoryContentProvider;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.DOMAdapterFactoryLabelProvider;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.testutils.dom.WaitingDomUtil;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProject;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;

public class DOMAdapterFactoryLabelProviderTest
extends TestCase {
    private TestProject testPrj1;
    protected JaxWsWorkspaceResource targetResource;
    protected DOMAdapterFactoryContentProvider adapterFactory;
    protected DOMAdapterFactoryLabelProvider labelProvider;
    private IWebServiceProject wsProject;
    private DomUtil domUtil;

    public void setUp() throws Exception {
        this.domUtil = new WaitingDomUtil();
        IProject ejbProject = TestProjectsUtils.createEjb3Project((String)("DOMLblProvTestProject1" + System.currentTimeMillis()));
        this.testPrj1 = new TestProject(ejbProject.getProject());
        IPackageFragment modelSync1 = this.testPrj1.createPackage("org.eclipse.test.modelsync1");
        this.testPrj1.createType(modelSync1, "Sei1.java", "@javax.jws.WebService(name=\"Sei1Name\") public interface Sei1{\n@javax.jws.WebMethod(name=\"parentMethod\") public void voidMethodWithNoArgsInParent();\n}");
        this.testPrj1.createType(modelSync1, "Sei2.java", "@javax.jws.WebService(name=\"Sei2Name\") public interface Sei2 extends Sei1 {\n@javax.jws.WebMethod(name=\"webMethod\") public void voidMethodWithNoArgsNotInParent();\n}");
        this.testPrj1.createType(modelSync1, "WS1.java", "@javax.jws.WebService(serviceName=\"WS1Name\", endpointInterface=\"org.eclipse.test.modelsync1.Sei2\") public class WS1 {}");
        this.testPrj1.createType(modelSync1, "WS2.java", "@javax.jws.WebService(serviceName=\"WS2Name\", endpointInterface=\"org.eclipse.test.modelsync1.Sei2\") public class WS2 {}");
        this.targetResource = new JaxWsWorkspaceResource(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.targetResource.load(null);
        this.wsProject = this.domUtil.findProjectByName(this.targetResource.getDOM(), this.testPrj1.getProject().getName());
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.wsProject);
        this.labelProvider = new DOMAdapterFactoryLabelProvider();
        this.adapterFactory = new DOMAdapterFactoryContentProvider(){

            protected IWebServiceProject getWsProject(IDOM dom, IProject project) {
                return DOMAdapterFactoryLabelProviderTest.this.wsProject;
            }
        };
    }

    public void testGetImageObject() {
        Object[] children = this.adapterFactory.getChildren((Object)this.testPrj1.getProject());
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getImage(children[0]));
        children = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getImage(children[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getImage(children[1]));
        Object[] sEIs = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getImage(sEIs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getImage(null), (Object)this.labelProvider.getImage(sEIs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getImage((Object)this.testPrj1), (Object)this.labelProvider.getImage(sEIs[0]));
        Object[] wSs = this.adapterFactory.getChildren(children[1]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getImage(wSs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getImage(null), (Object)this.labelProvider.getImage(wSs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getImage((Object)this.testPrj1), (Object)this.labelProvider.getImage(wSs[0]));
        Object[] webMethods = this.adapterFactory.getChildren(sEIs[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getImage(webMethods[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getImage(null), (Object)this.labelProvider.getImage(webMethods[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getImage((Object)this.testPrj1), (Object)this.labelProvider.getImage(webMethods[0]));
    }

    public void testGetTextObject() {
        Object[] children = this.adapterFactory.getChildren((Object)this.testPrj1.getProject());
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getText(children[0]));
        children = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getText(children[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getText(children[1]));
        Object[] sEIs = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getText(sEIs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getText(null), (Object)this.labelProvider.getText(sEIs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getText((Object)this.testPrj1), (Object)this.labelProvider.getText(sEIs[0]));
        Object[] wSs = this.adapterFactory.getChildren(children[1]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getText(wSs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getText(null), (Object)this.labelProvider.getText(wSs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getText((Object)this.testPrj1), (Object)this.labelProvider.getText(wSs[0]));
        Object[] webMethods = this.adapterFactory.getChildren(sEIs[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getText(webMethods[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getText(null), (Object)this.labelProvider.getText(webMethods[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getText((Object)this.testPrj1), (Object)this.labelProvider.getText(webMethods[0]));
    }

    public void testGetDescription() {
        Object[] children = this.adapterFactory.getChildren((Object)this.testPrj1.getProject());
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getDescription(children[0]));
        children = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getDescription(children[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getDescription(children[1]));
        Object[] sEIs = this.adapterFactory.getChildren(children[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getDescription(sEIs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getDescription(null), (Object)this.labelProvider.getDescription(sEIs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getDescription((Object)this.testPrj1), (Object)this.labelProvider.getDescription(sEIs[0]));
        Object[] wSs = this.adapterFactory.getChildren(children[1]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getDescription(wSs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getDescription(null), (Object)this.labelProvider.getDescription(wSs[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getDescription((Object)this.testPrj1), (Object)this.labelProvider.getDescription(wSs[0]));
        Object[] webMethods = this.adapterFactory.getChildren(sEIs[0]);
        DOMAdapterFactoryLabelProviderTest.assertNotNull((Object)this.labelProvider.getDescription(webMethods[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getDescription(null), (Object)this.labelProvider.getDescription(webMethods[0]));
        DOMAdapterFactoryLabelProviderTest.assertNotSame((Object)this.labelProvider.getDescription((Object)this.testPrj1), (Object)this.labelProvider.getDescription(webMethods[0]));
    }
}

