/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.stack;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.stack.StackTests;

public class ArrayStackTests
extends StackTests {
    public ArrayStackTests(String name) {
        super(name);
    }

    @Override
    Stack<String> buildStack() {
        return new ArrayStack();
    }

    public void testCollectionConstructor() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("first");
        c.add("second");
        c.add("third");
        c.add("fourth");
        c.add("fifth");
        c.add("sixth");
        c.add("seventh");
        c.add("eighth");
        c.add("ninth");
        c.add("tenth");
        ArrayStack stack = StackTools.arrayStack(c);
        ArrayStackTests.assertFalse((boolean)stack.isEmpty());
        ArrayStackTests.assertEquals((String)"tenth", (String)((String)stack.peek()));
        stack.push((Object)"eleventh");
        stack.push((Object)"twelfth");
        ArrayStackTests.assertEquals((String)"twelfth", (String)((String)stack.peek()));
        ArrayStackTests.assertEquals((String)"twelfth", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"eleventh", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"tenth", (String)((String)stack.peek()));
        ArrayStackTests.assertEquals((String)"tenth", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"ninth", (String)((String)stack.pop()));
        ArrayStackTests.assertFalse((boolean)stack.isEmpty());
        ArrayStackTests.assertEquals((String)"eighth", (String)((String)stack.peek()));
        ArrayStackTests.assertEquals((String)"eighth", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"seventh", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"sixth", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"fifth", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"fourth", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"third", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"second", (String)((String)stack.pop()));
        ArrayStackTests.assertEquals((String)"first", (String)((String)stack.pop()));
        ArrayStackTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testSerialization_fullArray() throws Exception {
        ArrayStack stack = new ArrayStack(3);
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        this.verifyClone((Stack<String>)stack, (Stack<String>)((Stack)TestTools.serialize(stack)));
    }

    public void testEnsureCapacity() {
        ArrayStack queue = StackTools.arrayStack((int)0);
        queue.ensureCapacity(7);
        ArrayStackTests.assertEquals((int)7, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testTrimToSize() throws Exception {
        ArrayStack stack = new ArrayStack(5);
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        Object[] elements = (Object[])ObjectTools.get((Object)stack, (String)"elements");
        ArrayStackTests.assertEquals((int)5, (int)elements.length);
        stack.trimToSize();
        elements = (Object[])ObjectTools.get((Object)stack, (String)"elements");
        ArrayStackTests.assertEquals((int)3, (int)elements.length);
    }

    public void testTrimToSize_noChange() throws Exception {
        ArrayStack stack = new ArrayStack(3);
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        Object[] elements = (Object[])ObjectTools.get((Object)stack, (String)"elements");
        ArrayStackTests.assertEquals((int)3, (int)elements.length);
        stack.trimToSize();
        elements = (Object[])ObjectTools.get((Object)stack, (String)"elements");
        ArrayStackTests.assertEquals((int)3, (int)elements.length);
    }

    public void testConstructorInt_IAE() throws Exception {
        boolean exCaught = false;
        try {
            ArrayStack stack = StackTools.arrayStack((int)-3);
            ArrayStackTests.fail((String)("bogus stack: " + stack));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayStackTests.assertTrue((boolean)exCaught);
    }

    public void testToString_empty() throws Exception {
        Stack<String> stack = this.buildStack();
        ArrayStackTests.assertEquals((String)"[]", (String)stack.toString());
    }
}

