/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.queue;

import java.util.NoSuchElementException;
import java.util.Random;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.queue.PriorityQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class PriorityQueueTests
extends TestCase {
    public PriorityQueueTests(String name) {
        super(name);
    }

    private Queue<String> buildQueue() {
        return QueueTools.priorityQueue();
    }

    public void testIsEmpty() {
        Queue<String> queue = this.buildQueue();
        PriorityQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)"first");
        PriorityQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)"second");
        PriorityQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        PriorityQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeue();
        PriorityQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueAndDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
    }

    public void testEnqueueAndPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
    }

    public void testEmptyQueueExceptionPeek() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            queue.peek();
            PriorityQueueTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyQueueExceptionDequeue() {
        Queue<String> queue = this.buildQueue();
        String first = "first";
        String second = "second";
        queue.enqueue((Object)first);
        queue.enqueue((Object)second);
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)first, (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.peek()));
        PriorityQueueTests.assertEquals((String)second, (String)((String)queue.dequeue()));
        boolean exCaught = false;
        try {
            queue.dequeue();
            PriorityQueueTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }

    public void testClone() {
        Queue<String> queue = this.buildQueue();
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        Queue clone = (Queue)ObjectTools.execute(queue, (String)"clone");
        this.verifyClone(queue, (Queue<String>)clone);
    }

    public void testSerialization() throws Exception {
        Queue<String> queue = this.buildQueue();
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        this.verifyClone(queue, TestTools.serialize(queue));
    }

    protected void verifyClone(Queue<String> original, Queue<String> clone) {
        PriorityQueueTests.assertNotSame(original, clone);
        PriorityQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        PriorityQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        PriorityQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        PriorityQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        PriorityQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        PriorityQueueTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        PriorityQueueTests.assertEquals((String)((String)original.dequeue()), (String)((String)clone.dequeue()));
        PriorityQueueTests.assertTrue((boolean)original.isEmpty());
        PriorityQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"fourth");
        PriorityQueueTests.assertFalse((boolean)original.isEmpty());
        PriorityQueueTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testToString() throws Exception {
        Queue<String> queue = this.buildQueue();
        PriorityQueueTests.assertEquals((String)"[]", (String)queue.toString());
        queue.enqueue((Object)"first");
        PriorityQueueTests.assertEquals((String)"[first]", (String)queue.toString());
        queue.enqueue((Object)"second");
        PriorityQueueTests.assertEquals((String)"[first, second]", (String)queue.toString());
        queue.enqueue((Object)"third");
        PriorityQueueTests.assertEquals((String)"[first, second, third]", (String)queue.toString());
    }

    public void testArrayCapacityExceeded() {
        PriorityQueue queue = QueueTools.priorityQueue();
        PriorityQueueTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueue((Object)1);
        PriorityQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)2);
        PriorityQueueTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueue((Object)3);
        queue.enqueue((Object)10);
        queue.enqueue((Object)11);
        queue.enqueue((Object)12);
        queue.enqueue((Object)4);
        queue.enqueue((Object)4);
        queue.enqueue((Object)7);
        queue.enqueue((Object)8);
        queue.enqueue((Object)9);
        queue.enqueue((Object)5);
        queue.enqueue((Object)6);
        queue.enqueue((Object)9);
        PriorityQueueTests.assertEquals((Object)1, (Object)queue.dequeue());
        PriorityQueueTests.assertFalse((boolean)queue.isEmpty());
        PriorityQueueTests.assertEquals((Object)2, (Object)queue.dequeue());
        PriorityQueueTests.assertFalse((boolean)queue.isEmpty());
        PriorityQueueTests.assertEquals((Object)3, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)4, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)4, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)5, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)6, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)7, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)8, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)9, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)9, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)10, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)11, (Object)queue.dequeue());
        PriorityQueueTests.assertEquals((Object)12, (Object)queue.dequeue());
        PriorityQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testMultipleSizes() throws Exception {
        int maxSize = 50;
        Random random = new Random();
        int size = 1;
        while (size <= maxSize) {
            PriorityQueue queue = QueueTools.priorityQueue((int)size);
            int i = size;
            while (i-- > 0) {
                queue.enqueue((Object)random.nextInt());
            }
            Integer current = (Integer)queue.dequeue();
            int i2 = 1;
            do {
                if (queue.isEmpty()) continue;
                Integer next = (Integer)queue.dequeue();
                ++i2;
                PriorityQueueTests.assertTrue((current <= next ? 1 : 0) != 0);
                current = next;
            } while (!queue.isEmpty());
            PriorityQueueTests.assertEquals((int)size, (int)i2);
            ++size;
        }
    }

    public void testSomethingBig() throws Exception {
        int size = 500000;
        PriorityQueue queue = QueueTools.priorityQueue((int)size);
        Random random = new Random();
        int i = size;
        while (i-- > 0) {
            queue.enqueue((Object)random.nextInt());
        }
        Integer current = (Integer)queue.dequeue();
        int i2 = 1;
        do {
            if (queue.isEmpty()) continue;
            Integer next = (Integer)queue.dequeue();
            ++i2;
            PriorityQueueTests.assertTrue((current <= next ? 1 : 0) != 0);
            current = next;
        } while (!queue.isEmpty());
        PriorityQueueTests.assertEquals((int)size, (int)i2);
    }

    public void testEnsureCapacity() throws Exception {
        PriorityQueue queue = QueueTools.priorityQueue();
        queue.enqueue((Object)"b");
        queue.enqueue((Object)"c");
        queue.enqueue((Object)"a");
        PriorityQueueTests.assertEquals((int)11, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
        queue.ensureCapacity(420);
        PriorityQueueTests.assertEquals((int)421, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
        PriorityQueueTests.assertEquals((String)"a", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)"b", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)"c", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testTrimToSize() throws Exception {
        PriorityQueue queue = QueueTools.priorityQueue();
        queue.enqueue((Object)"b");
        queue.enqueue((Object)"c");
        queue.enqueue((Object)"a");
        PriorityQueueTests.assertEquals((int)11, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
        queue.trimToSize();
        PriorityQueueTests.assertEquals((int)4, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
        PriorityQueueTests.assertEquals((String)"a", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)"b", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)"c", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testTrimToSize_nop() throws Exception {
        PriorityQueue queue = QueueTools.priorityQueue((int)3);
        queue.enqueue((Object)"b");
        queue.enqueue((Object)"c");
        queue.enqueue((Object)"a");
        PriorityQueueTests.assertEquals((int)4, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
        queue.trimToSize();
        PriorityQueueTests.assertEquals((int)4, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
        PriorityQueueTests.assertEquals((String)"a", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)"b", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertEquals((String)"c", (String)((String)queue.dequeue()));
        PriorityQueueTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testConstructor_nullComparator() throws Exception {
        boolean exCaught = false;
        try {
            PriorityQueue queue = QueueTools.priorityQueue(null, (int)3);
            PriorityQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }

    public void testConstructor_negativeCapacity() throws Exception {
        boolean exCaught = false;
        try {
            PriorityQueue queue = QueueTools.priorityQueue((int)-7);
            PriorityQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }

    public void testSerialization_fullArray() throws Exception {
        PriorityQueue queue = QueueTools.priorityQueue((int)3);
        queue.enqueue((Object)"first");
        queue.enqueue((Object)"second");
        queue.enqueue((Object)"third");
        this.verifyClone((Queue<String>)queue, (Queue<String>)((Queue)TestTools.serialize(queue)));
    }

    public void testSerialization_empty() throws Exception {
        PriorityQueue original = QueueTools.priorityQueue();
        Queue clone = (Queue)TestTools.serialize(original);
        PriorityQueueTests.assertNotSame((Object)original, (Object)clone);
        PriorityQueueTests.assertTrue((boolean)original.isEmpty());
        PriorityQueueTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueue((Object)"foo");
        PriorityQueueTests.assertFalse((boolean)original.isEmpty());
        PriorityQueueTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testConstructorComparatorObjectArrayInt() throws Exception {
        int maxSize = 100;
        Object[] array = new Integer[maxSize + 1];
        Random random = new Random();
        int size = 1;
        while (size <= maxSize) {
            ArrayTools.fill((Object[])array, null);
            int i = size + 1;
            while (i-- > 1) {
                array[i] = random.nextInt();
            }
            PriorityQueue queue = QueueTools.priorityQueue((Comparable[])array, (int)size);
            Integer current = (Integer)queue.dequeue();
            int i2 = 1;
            do {
                if (queue.isEmpty()) continue;
                Integer next = (Integer)queue.dequeue();
                ++i2;
                PriorityQueueTests.assertTrue((current <= next ? 1 : 0) != 0);
                current = next;
            } while (!queue.isEmpty());
            PriorityQueueTests.assertEquals((int)size, (int)i2);
            ++size;
        }
    }

    public void testConstructorComparatorObjectArrayInt_nullComparator() throws Exception {
        Object[] array = new String[5];
        boolean exCaught = false;
        try {
            PriorityQueue queue = QueueTools.priorityQueue(null, (Object[])array, (int)3);
            PriorityQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorComparatorObjectArrayInt_nullArray() throws Exception {
        boolean exCaught = false;
        try {
            PriorityQueue queue = QueueTools.priorityQueue(null, (int)3);
            PriorityQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorComparatorObjectArrayInt_emptyArray() throws Exception {
        boolean exCaught = false;
        try {
            PriorityQueue queue = QueueTools.priorityQueue((Comparable[])StringTools.EMPTY_STRING_ARRAY, (int)3);
            PriorityQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorComparatorObjectArrayInt_negativeSize() throws Exception {
        String[] array = new String[5];
        boolean exCaught = false;
        try {
            PriorityQueue queue = QueueTools.priorityQueue((Comparable[])array, (int)-7);
            PriorityQueueTests.fail((String)("bogus queue: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        PriorityQueueTests.assertTrue((boolean)exCaught);
    }
}

