/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyListIterator;

public class EmptyListIteratorTests
extends TestCase {
    public EmptyListIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        ListIterator stream = EmptyListIterator.instance();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        EmptyListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNext() {
        ListIterator stream = EmptyListIterator.instance();
        while (stream.hasNext()) {
            EmptyListIteratorTests.fail((String)("bogus element: " + stream.next()));
        }
    }

    public void testNextIndex() {
        ListIterator stream = EmptyListIterator.instance();
        EmptyListIteratorTests.assertEquals((int)0, (int)stream.nextIndex());
    }

    public void testHasPrevious() {
        ListIterator stream = EmptyListIterator.instance();
        int i = 0;
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        EmptyListIteratorTests.assertEquals((int)0, (int)i);
        while (stream.hasNext()) {
            stream.next();
        }
        i = 0;
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        EmptyListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testPrevious() {
        ListIterator stream = EmptyListIterator.instance();
        while (stream.hasPrevious()) {
            EmptyListIteratorTests.fail((String)("bogus element: " + stream.previous()));
        }
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            EmptyListIteratorTests.fail((String)("bogus element: " + stream.previous()));
        }
    }

    public void testPreviousIndex() {
        ListIterator stream = EmptyListIterator.instance();
        EmptyListIteratorTests.assertEquals((int)-1, (int)stream.previousIndex());
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator stream = EmptyListIterator.instance();
        Object element = null;
        while (stream.hasNext()) {
            element = stream.next();
        }
        try {
            element = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyListIteratorTests.assertTrue((String)("NoSuchElementException not thrown (next): " + element), (boolean)exCaught);
        while (stream.hasPrevious()) {
            element = stream.previous();
        }
        try {
            element = stream.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyListIteratorTests.assertTrue((String)("NoSuchElementException not thrown (previous): " + element), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        try {
            EmptyListIterator.instance().remove();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown (remove)", (boolean)exCaught);
        try {
            EmptyListIterator.instance().set(new Object());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown (set)", (boolean)exCaught);
        try {
            EmptyListIterator.instance().add(new Object());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown (add)", (boolean)exCaught);
    }
}

