/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.Comparator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.internal.deque.PriorityDeque;
import org.eclipse.jpt.common.utility.tests.internal.deque.AbstractPriorityDequeTests;

public class PriorityDequeTests
extends AbstractPriorityDequeTests {
    public PriorityDequeTests(String name) {
        super(name);
    }

    <E extends Comparable<E>> PriorityDeque<E> buildDeque() {
        return DequeTools.priorityDeque();
    }

    <E extends Comparable<E>> PriorityDeque<E> buildDeque(int capacity) {
        return DequeTools.priorityDeque((int)capacity);
    }

    <E extends Comparable<E>> PriorityDeque<E> buildDeque(Comparator<E> comparator, int capacity) {
        return DequeTools.priorityDeque(comparator, (int)capacity);
    }

    public void testArrayCapacityExceeded() {
        PriorityDeque deque = this.buildDeque();
        PriorityDequeTests.assertTrue((boolean)deque.isEmpty());
        deque.enqueue((Object)1);
        PriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.enqueue((Object)2);
        PriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.enqueue((Object)3);
        deque.enqueue((Object)10);
        deque.enqueue((Object)11);
        deque.enqueue((Object)12);
        deque.enqueue((Object)4);
        deque.enqueue((Object)4);
        deque.enqueue((Object)7);
        deque.enqueue((Object)8);
        deque.enqueue((Object)9);
        deque.enqueue((Object)5);
        deque.enqueue((Object)6);
        deque.enqueue((Object)9);
        PriorityDequeTests.assertEquals((Object)1, (Object)deque.dequeueHead());
        PriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        PriorityDequeTests.assertEquals((Object)2, (Object)deque.dequeueHead());
        PriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        PriorityDequeTests.assertEquals((Object)3, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)4, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)12, (Object)deque.dequeueTail());
        PriorityDequeTests.assertEquals((Object)4, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)5, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)6, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)7, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)11, (Object)deque.dequeueTail());
        PriorityDequeTests.assertEquals((Object)8, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)10, (Object)deque.dequeueTail());
        PriorityDequeTests.assertEquals((Object)9, (Object)deque.dequeueHead());
        PriorityDequeTests.assertEquals((Object)9, (Object)deque.dequeueHead());
        PriorityDequeTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testEnsureCapacity() throws Exception {
        PriorityDeque deque = this.buildDeque();
        deque.enqueue((Object)"b");
        deque.enqueue((Object)"c");
        deque.enqueue((Object)"a");
        PriorityDequeTests.assertEquals((int)11, (int)((Object[])ObjectTools.get(deque, (String)"elements")).length);
        deque.ensureCapacity(420);
        PriorityDequeTests.assertEquals((int)421, (int)((Object[])ObjectTools.get(deque, (String)"elements")).length);
        PriorityDequeTests.assertEquals((String)"a", (String)((String)deque.dequeueHead()));
        PriorityDequeTests.assertEquals((String)"c", (String)((String)deque.dequeueTail()));
        PriorityDequeTests.assertEquals((String)"b", (String)((String)deque.dequeueHead()));
        PriorityDequeTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testTrimToSize() throws Exception {
        PriorityDeque deque = this.buildDeque();
        deque.enqueue((Object)"b");
        deque.enqueue((Object)"c");
        deque.enqueue((Object)"a");
        PriorityDequeTests.assertEquals((int)11, (int)((Object[])ObjectTools.get(deque, (String)"elements")).length);
        deque.trimToSize();
        PriorityDequeTests.assertEquals((int)4, (int)((Object[])ObjectTools.get(deque, (String)"elements")).length);
        PriorityDequeTests.assertEquals((String)"a", (String)((String)deque.dequeueHead()));
        PriorityDequeTests.assertEquals((String)"c", (String)((String)deque.dequeueTail()));
        PriorityDequeTests.assertEquals((String)"b", (String)((String)deque.dequeueHead()));
        PriorityDequeTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testTrimToSize_nop() throws Exception {
        PriorityDeque deque = this.buildDeque(3);
        deque.enqueue((Object)"b");
        deque.enqueue((Object)"c");
        deque.enqueue((Object)"a");
        PriorityDequeTests.assertEquals((int)4, (int)((Object[])ObjectTools.get(deque, (String)"elements")).length);
        deque.trimToSize();
        PriorityDequeTests.assertEquals((int)4, (int)((Object[])ObjectTools.get(deque, (String)"elements")).length);
        PriorityDequeTests.assertEquals((String)"a", (String)((String)deque.dequeueHead()));
        PriorityDequeTests.assertEquals((String)"c", (String)((String)deque.dequeueTail()));
        PriorityDequeTests.assertEquals((String)"b", (String)((String)deque.dequeueHead()));
        PriorityDequeTests.assertTrue((boolean)deque.isEmpty());
    }
}

