/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.model.tests;

import java.util.List;
import java.util.Map;
import org.eclipse.wst.xsl.core.internal.model.StylesheetBuilder;
import org.eclipse.wst.xsl.core.model.Function;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.internal.model.tests.AbstractModelTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStylesheet
extends AbstractModelTest {
    StylesheetBuilder builder = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.builder = StylesheetBuilder.getInstance();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.builder.release();
    }

    @Test
    public void testLoadModel() {
        Stylesheet model = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)model);
    }

    @Test
    public void testgetLocalTemplatesTemplates() {
        Stylesheet model = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)model);
        List templatesList = model.getTemplates();
        Assert.assertEquals((String)"Wrong number of templates returned.", (long)2L, (long)templatesList.size());
    }

    @Test
    public void testGetIncludes() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List includeList = stylesheet.getIncludes();
        Assert.assertEquals((String)"Wrong number of includes returned.", (long)1L, (long)includeList.size());
    }

    @Test
    public void testGetImports() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("style1.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List includeList = stylesheet.getImports();
        Assert.assertEquals((String)"Wrong number of includes returned.", (long)1L, (long)includeList.size());
    }

    @Test
    public void testGetGlobalVariables() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List globalVariablesList = stylesheet.getGlobalVariables();
        Assert.assertEquals((String)"Wrong number of global variables returned.", (long)3L, (long)globalVariablesList.size());
    }

    @Test
    public void testGetLineNumber() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        Assert.assertEquals((String)"Incorrect line number.", (long)12L, (long)stylesheet.getLineNumber());
    }

    @Test
    public void testGetColumnNumber() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        Assert.assertEquals((String)"Incorrect column number.", (long)0L, (long)stylesheet.getColumnNumber());
    }

    @Test
    public void testGetVersion() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        Assert.assertEquals((String)"Wrong version number returned.", (Object)"1.0", (Object)stylesheet.getVersion());
    }

    @Test
    public void testXSLT2GetVersion() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("XSLT20Test.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        Assert.assertEquals((String)"Wrong version number returned.", (Object)"2.0", (Object)stylesheet.getVersion());
    }

    @Test
    public void testGetAttributes() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("globalVariablesTest.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        Map attributeList = stylesheet.getAttributes();
        Assert.assertEquals((String)"Incorrect number of attributes", (long)4L, (long)attributeList.size());
        XSLAttribute attribute = stylesheet.getAttribute("exclude-result-prefixes");
        Assert.assertEquals((String)"Wrong attribute returned:", (Object)"exclude-result-prefixes", (Object)attribute.getName());
    }

    @Test
    public void testGetFunction() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("XSLT20FunctionTest.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List functionList = stylesheet.getFunctions();
        Assert.assertEquals((String)"Wrong number of global variables returned.", (long)2L, (long)functionList.size());
    }

    @Test
    public void testGetFunctionFunc1() {
        Stylesheet stylesheet = this.builder.getStylesheet(this.getFile("XSLT20FunctionTest.xsl"), false);
        Assert.assertNotNull((String)"Model failed to load, returned NULL", (Object)stylesheet);
        List functionList = stylesheet.getFunctions();
        for (Function function : functionList) {
            if (!function.getName().equals("func1")) continue;
            return;
        }
        Assert.fail((String)"Did not find XSL func func1");
    }
}

