/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.format;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.wst.html.core.internal.format.HTMLFormattingUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class TestFormatUtility
extends TestCase {
    public void testInlineDefaults() {
        Object[] defaultElements = HTMLFormattingUtil.getDefaultInlineElements();
        TestFormatUtility.assertNotNull((String)"Default elements cannot be null", (Object)defaultElements);
        TestFormatUtility.assertTrue((String)"Default element list has no elements", (defaultElements.length > 0 ? 1 : 0) != 0);
        Object[] elements = HTMLFormattingUtil.getInlineElements();
        Arrays.sort(elements, Collator.getInstance());
        Arrays.sort(defaultElements, Collator.getInstance());
        TestFormatUtility.assertNotNull((String)"Inline elements cannot be null", (Object)elements);
        TestFormatUtility.assertTrue((String)"Inline elements size does not match the default", (elements.length == defaultElements.length ? 1 : 0) != 0);
        int i = 0;
        while (i < elements.length) {
            TestFormatUtility.assertEquals((String)"Element does not match up with default list", (Object)defaultElements[i], (Object)elements[i]);
            ++i;
        }
    }

    public void testInlineNode() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IDOMDocument document = model.getDocument();
        HTMLFormattingUtil util = new HTMLFormattingUtil();
        TestFormatUtility.assertTrue((String)"Anchor tag must be inline", (boolean)util.isInline((Node)document.createElement("a")));
        TestFormatUtility.assertFalse((String)"Div tag must not be inline", (boolean)util.isInline((Node)document.createElement("div")));
    }

    public void testExportElements() {
        Object[] newElements = new String[]{"foo"};
        HTMLFormattingUtil.exportToPreferences((Object[])newElements);
        Object[] elements = HTMLFormattingUtil.getInlineElements();
        TestFormatUtility.assertNotNull((String)"Inline elements cannot be null", (Object)elements);
        TestFormatUtility.assertEquals((String)"Inline count is wrong", (int)newElements.length, (int)elements.length);
        int i = 0;
        while (i < newElements.length) {
            TestFormatUtility.assertEquals((String)"Element names do not match up", (Object)newElements[i], (Object)elements[i]);
            ++i;
        }
        HTMLFormattingUtil.exportToPreferences((Object[])HTMLFormattingUtil.getDefaultInlineElements());
    }
}

