/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadAttributeRendererTestCase
extends BaseReadTestCase {
    public ReadAttributeRendererTestCase(String name) {
        super(name);
    }

    public void testSingleAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeRendererTestCase.assertNotNull((Object)attribute1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private AttributeType getAttribute1(FacesConfigType facesConfig) {
        RenderKitType renderKit = (RenderKitType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getRenderKit(), "renderKit1");
        ReadAttributeRendererTestCase.assertNotNull((Object)renderKit);
        RendererType renderer = (RendererType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getRenderer(), "renderKit1Renderer");
        ReadAttributeRendererTestCase.assertNotNull((Object)renderer);
        return (AttributeType)FacesConfigModelUtil.findEObjectElementById((List)renderer.getAttribute(), "renderKit1RendererAttribute1");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeRendererTestCase.assertNotNull((Object)attributeType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDescription(), "renderKit1RendererAttribute1Description");
            ReadAttributeRendererTestCase.assertEquals((String)"renderer-attribute-attribute-description", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeRendererTestCase.assertNotNull((Object)attributeType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDisplayName(), "renderKit1RendererAttribute1DisplayName");
            ReadAttributeRendererTestCase.assertEquals((String)"renderer-attribute-display-name", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attrType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeRendererTestCase.assertNotNull((Object)attrType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)attrType.getIcon(), "renderKit1RendererAttribute1Icon");
            ReadAttributeRendererTestCase.assertNotNull((Object)iconType);
            ReadAttributeRendererTestCase.assertEquals((String)"renderer-attribute-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadAttributeRendererTestCase.assertEquals((String)"renderer-attribute-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeNameAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeRendererTestCase.assertNotNull((Object)attribute1);
            ReadAttributeRendererTestCase.assertEquals((String)"renderer attribute name", (String)attribute1.getAttributeName().getTextContent());
            ReadAttributeRendererTestCase.assertEquals((String)"renderer Attribute Class", (String)attribute1.getAttributeClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSuggestedValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeRendererTestCase.assertEquals((String)"renderer attribute suggested value", (String)attributeType.getSuggestedValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeRendererTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeRendererTestCase.assertEquals((String)"renderer attribute default value", (String)attributeType.getDefaultValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            if (edit.getFacesConfig() != null) {
                EList comp = edit.getFacesConfig().getComponent();
                ReadAttributeRendererTestCase.assertTrue((!comp.isEmpty() ? 1 : 0) != 0);
                int i = 0;
                while (i < comp.size()) {
                    ComponentType compType = (ComponentType)comp.get(i);
                    ReadAttributeRendererTestCase.assertTrue((!compType.getAttribute().isEmpty() ? 1 : 0) != 0);
                    EList attr = compType.getAttribute();
                    int k = 0;
                    while (k < attr.size()) {
                        AttributeType attrType = (AttributeType)attr.get(k);
                        EList ext = attrType.getAttributeExtension();
                        ReadAttributeRendererTestCase.assertTrue((ext.size() != 0 ? 1 : 0) != 0);
                        ++k;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

