/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.jface;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jpt.common.ui.internal.jface.ItemTreeStateProviderManager;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TreeContentProviderUiTest
extends ApplicationWindow {
    final Root root = this.buildRoot();
    ModifiablePropertyValueModel<TreeNode> selectedNodeModel = new SimplePropertyValueModel((Object)this.root);
    TreeViewer controlTreeViewer;
    private TreeViewer viewTreeViewer;
    private Text nodeNameText;
    static Transformer<TreeNode, CollectionValueModel<TreeNode>> TREE_NODE_TRANSFORMER = new TreeNodeTransformer();

    public static void main(String[] args) {
        TreeContentProviderUiTest window = new TreeContentProviderUiTest();
        window.setBlockOnOpen(true);
        window.open();
        Display.getCurrent().dispose();
        System.exit(0);
    }

    private TreeContentProviderUiTest() {
        super(null);
    }

    private Root buildRoot() {
        Root r = new Root();
        Parent parent1 = r.addChild("Parent 1");
        parent1.addChild("Foo");
        parent1.addChild("Bar");
        parent1.addChild("Baz");
        Parent parent2 = r.addChild("Parent 2");
        parent2.addChild("Joo");
        parent2.addChild("Jar");
        parent2.addChild("Jaz");
        Parent parent3 = r.addChild("Parent 3");
        parent3.addNestedChild("Too");
        parent3.addNestedChild("Tar");
        parent3.addNestedChild("Taz");
        return r;
    }

    protected Control createContents(Composite parent) {
        ((Shell)parent).setText(((Object)((Object)this)).getClass().getSimpleName());
        parent.setSize(800, 400);
        parent.setLayout((Layout)new GridLayout());
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout());
        this.buildTreePanel(mainPanel);
        this.buildControlPanel(mainPanel);
        return mainPanel;
    }

    private void buildTreePanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setLayout((Layout)new GridLayout(2, true));
        this.buildControlTreePanel(panel);
        this.buildViewTreePanel(panel);
    }

    private void buildControlTreePanel(Composite parent) {
        this.controlTreeViewer = this.buildTreePanel(parent, "Control tree", (ITreeContentProvider)new ItemTreeStateProviderManager((ItemTreeContentProvider.Factory)new ControlItemTreeContentProviderFactory(), JFaceResources.getResources()), new LabelProvider());
        this.controlTreeViewer.addSelectionChangedListener(this.buildTreeSelectionChangedListener());
        this.selectedNodeModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                TreeContentProviderUiTest.this.controlTreeViewer.setSelection((ISelection)new StructuredSelection(event.getNewValue()));
            }
        });
    }

    private void buildViewTreePanel(Composite parent) {
        this.viewTreeViewer = this.buildTreePanel(parent, "View tree", (ITreeContentProvider)new ItemTreeStateProviderManager((ItemTreeContentProvider.Factory)new ViewItemTreeContentProviderFactory(), JFaceResources.getResources()), new LabelProvider());
    }

    private TreeViewer buildTreePanel(Composite parent, String labelText, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setLayout((Layout)new GridLayout());
        Label label = new Label(panel, 16384);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        label.setText(labelText);
        TreeViewer tree = new TreeViewer(panel, 2820);
        tree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        tree.setContentProvider((IContentProvider)contentProvider);
        tree.setLabelProvider((IBaseLabelProvider)labelProvider);
        tree.setInput((Object)this.root);
        return tree;
    }

    private ISelectionChangedListener buildTreeSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeNode selection = (TreeNode)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
                TreeContentProviderUiTest.this.selectedNodeModel.setValue((Object)(selection == null ? TreeContentProviderUiTest.this.root : selection));
            }
        };
    }

    private void buildControlPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(4, 4, true, false));
        panel.setLayout((Layout)new GridLayout(6, false));
        this.buildNodeNameText(panel);
        this.buildAddChildACI().fill(panel);
        this.buildAddNestedChildACI().fill(panel);
        this.buildRemoveACI().fill(panel);
        this.buildClearModelACI().fill(panel);
        this.buildRestoreModelACI().fill(panel);
    }

    private void buildNodeNameText(Composite parent) {
        this.nodeNameText = new Text(parent, 2052);
        this.nodeNameText.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private ActionContributionItem buildAddChildACI() {
        final Action action = new Action("Add child", 1){

            public void run() {
                TreeContentProviderUiTest.this.addChild();
            }
        };
        action.setToolTipText("Add a child with the given name");
        this.selectedNodeModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                action.setEnabled(((TreeNode)((Object)event.getNewValue())).canHaveChildren());
            }
        });
        return new ActionContributionItem((IAction)action);
    }

    private ActionContributionItem buildAddNestedChildACI() {
        final Action action = new Action("Add nested child", 1){

            public void run() {
                TreeContentProviderUiTest.this.addNestedChild();
            }
        };
        action.setToolTipText("Add a nested child with the given name");
        action.setEnabled(false);
        this.selectedNodeModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                action.setEnabled(((TreeNode)((Object)event.getNewValue())).canHaveNestedChildren());
            }
        });
        return new ActionContributionItem((IAction)action);
    }

    private ActionContributionItem buildRemoveACI() {
        final Action action = new Action("Remove", 1){

            public void run() {
                TreeContentProviderUiTest.this.remove();
            }
        };
        action.setToolTipText("Remove the selected node");
        action.setEnabled(false);
        this.selectedNodeModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                action.setEnabled(event.getNewValue() != TreeContentProviderUiTest.this.root);
            }
        });
        return new ActionContributionItem((IAction)action);
    }

    private ActionContributionItem buildClearModelACI() {
        Action action = new Action("Clear model", 1){

            public void run() {
                TreeContentProviderUiTest.this.clearModel();
            }
        };
        action.setToolTipText("Clear the model");
        return new ActionContributionItem((IAction)action);
    }

    private ActionContributionItem buildRestoreModelACI() {
        Action action = new Action("Restore model", 1){

            public void run() {
                TreeContentProviderUiTest.this.restoreModel();
            }
        };
        action.setToolTipText("Restore the model");
        return new ActionContributionItem((IAction)action);
    }

    void addChild() {
        String nodeName = this.nodeNameText.getText();
        if (nodeName.length() != 0) {
            new Thread(new AddChildRunnable(nodeName)).start();
        }
    }

    void addChild_(String name) {
        ((TreeNode)((Object)this.selectedNodeModel.getValue())).addChild(name);
    }

    void addNestedChild() {
        String nodeName = this.nodeNameText.getText();
        if (nodeName.length() != 0) {
            ((TreeNode)((Object)this.selectedNodeModel.getValue())).addNestedChild(nodeName);
        }
    }

    void remove() {
        ((TreeNode)((Object)this.selectedNodeModel.getValue())).remove();
    }

    void clearModel() {
        this.controlTreeViewer.setInput(null);
        this.viewTreeViewer.setInput(null);
    }

    void restoreModel() {
        this.controlTreeViewer.setInput((Object)this.root);
        this.viewTreeViewer.setInput((Object)this.root);
    }

    static CollectionValueModel<TreeNode> buildChildrenModel(TreeNode item) {
        return new ListCollectionValueModelAdapter((ListValueModel)new ListAspectAdapter<TreeNode, TreeNode>("children", item){

            protected ListIterable<TreeNode> getListIterable() {
                return ((TreeNode)((Object)this.subject)).getChildren();
            }
        });
    }

    static CollectionValueModel<TreeNode> buildParentChildrenModel(Parent item) {
        return new CompositeCollectionValueModel(TreeContentProviderUiTest.buildChildrenModel(item), TREE_NODE_TRANSFORMER);
    }

    static abstract class AbstractItemTreeContentProviderFactory
    implements ItemTreeContentProvider.Factory {
        AbstractItemTreeContentProviderFactory() {
        }

        public ItemStructuredContentProvider buildProvider(Object input, ItemStructuredContentProvider.Manager manager) {
            return new ModelItemStructuredContentProvider(input, TreeContentProviderUiTest.buildChildrenModel((Root)((Object)input)), manager);
        }

        public ItemTreeContentProvider buildProvider(Object item, Object parent, ItemTreeContentProvider.Manager manager) {
            return new ModelItemTreeContentProvider(item, parent, TreeContentProviderUiTest.buildChildrenModel((TreeNode)((Object)item)), manager);
        }
    }

    private class AddChildRunnable
    implements Runnable {
        private final String name;

        AddChildRunnable(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            TreeContentProviderUiTest.this.addChild_(this.name);
        }
    }

    static class Child
    extends TreeNode {
        Child(TreeNode parent, String name) {
            super(parent, name);
        }
    }

    static class ControlItemTreeContentProviderFactory
    extends AbstractItemTreeContentProviderFactory {
        ControlItemTreeContentProviderFactory() {
        }
    }

    static class LabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        LabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((TreeNode)((Object)element)).getName();
        }
    }

    static class Nest
    extends TreeNode {
        Nest(TreeNode parent) {
            super(parent, "nest");
        }

        @Override
        public boolean canHaveChildren() {
            return this.children.size() == 0;
        }

        @Override
        public Child addChild(String childName) {
            return this.addChild(new Child(this, childName));
        }

        public Child getChild() {
            return this.children.isEmpty() ? null : (Child)((Object)this.children.get(0));
        }
    }

    static class Parent
    extends TreeNode {
        public static final Transformer<TreeNode, Child> CHILD_TREE_NODE_TRANSFORMER = new ChildTreeNodeTransformer();

        Parent(TreeNode parent, String name) {
            super(parent, name);
        }

        @Override
        public boolean canHaveChildren() {
            return true;
        }

        @Override
        public Child addChild(String childName) {
            return this.addChild(new Child(this, childName));
        }

        @Override
        public boolean canHaveNestedChildren() {
            return true;
        }

        @Override
        public Nest addNestedChild(String childName) {
            Nest nest = new Nest(this);
            this.addChild(nest);
            nest.addChild(childName);
            return nest;
        }

        public Iterable<Child> getNestlessChildren() {
            return IterableTools.transform(this.getChildren(), CHILD_TREE_NODE_TRANSFORMER);
        }

        public static class ChildTreeNodeTransformer
        extends TransformerAdapter<TreeNode, Child> {
            public Child transform(TreeNode node) {
                return node instanceof Nest ? ((Nest)node).getChild() : (Child)node;
            }
        }
    }

    static class Root
    extends TreeNode {
        Root() {
            super(null, null);
        }

        @Override
        public boolean canHaveChildren() {
            return true;
        }

        @Override
        public Parent addChild(String childName) {
            return this.addChild(new Parent(this, childName));
        }
    }

    static abstract class TreeNode
    extends AbstractModel {
        private TreeNode parent;
        protected final ArrayList<TreeNode> children = new ArrayList();
        public static final String CHILDREN_LIST = "children";
        protected String name;
        public static final String NAME_PROPERTY = "name";

        TreeNode(TreeNode parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public TreeNode parent() {
            return this.parent;
        }

        public ListIterable<TreeNode> getChildren() {
            return IterableTools.cloneLive(this.children);
        }

        protected <TN extends TreeNode> TN addChild(TN child) {
            this.addItemToList(child, this.children, CHILDREN_LIST);
            return child;
        }

        public void remove() {
            this.parent.removeChild(this);
        }

        public void removeChild(TreeNode child) {
            this.removeItemFromList((Object)child, this.children, CHILDREN_LIST);
        }

        public void removeChild(int index) {
            this.removeItemFromList(index, this.children, CHILDREN_LIST);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public boolean canHaveChildren() {
            return false;
        }

        public TreeNode addChild(String childName) {
            throw new UnsupportedOperationException();
        }

        public boolean canHaveNestedChildren() {
            return false;
        }

        public TreeNode addNestedChild(String childName) {
            throw new UnsupportedOperationException();
        }

        public void toString(StringBuilder sb) {
            sb.append(this.name);
        }
    }

    static class TreeNodeTransformer
    extends TransformerAdapter<TreeNode, CollectionValueModel<TreeNode>> {
        TreeNodeTransformer() {
        }

        public CollectionValueModel<TreeNode> transform(TreeNode value) {
            return value instanceof Nest ? this.transform((Nest)value) : new StaticCollectionValueModel((Iterable)CollectionTools.hashBag((Object[])new TreeNode[]{value}));
        }

        private CollectionValueModel<TreeNode> transform(Nest nest) {
            return new ListCollectionValueModelAdapter((ListValueModel)new ListAspectAdapter<TreeNode, TreeNode>("children", (TreeNode)nest){

                protected ListIterable<TreeNode> getListIterable() {
                    return ((TreeNode)((Object)this.subject)).getChildren();
                }
            });
        }
    }

    static class ViewItemTreeContentProviderFactory
    extends AbstractItemTreeContentProviderFactory {
        ViewItemTreeContentProviderFactory() {
        }

        @Override
        public ItemTreeContentProvider buildProvider(Object item, Object parent, ItemTreeContentProvider.Manager manager) {
            if (item instanceof Parent) {
                return new ModelItemTreeContentProvider(item, parent, TreeContentProviderUiTest.buildParentChildrenModel((Parent)((Object)item)), manager);
            }
            if (item instanceof Nest) {
                parent = ((TreeNode)((Object)parent)).parent();
            }
            return super.buildProvider(item, parent, manager);
        }
    }
}

