/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java_cup.runtime.Symbol;
import junit.framework.TestCase;
import org.eclipse.wst.xml.xpath2.processor.internal.JFlexError;
import org.eclipse.wst.xml.xpath2.processor.internal.XPathFlex;

public class XPathFlexTest
extends TestCase {
    void assertSymbolEquals(int expectedId, Object expectedValue, Symbol symbol) {
        XPathFlexTest.assertEquals((String)("Expected symbol type for " + symbol.value), (int)expectedId, (int)symbol.sym);
        XPathFlexTest.assertEquals((String)"Expected symbol value for symbol type", (Object)expectedValue, (Object)symbol.value);
    }

    Symbol tokenizeFirst(String source) throws IOException {
        XPathFlex lexer = new XPathFlex((Reader)new StringReader(source));
        return lexer.next_token();
    }

    public void testDigits() throws IOException {
        this.assertSymbolEquals(83, BigInteger.valueOf(1234L), this.tokenizeFirst("1234"));
        this.assertSymbolEquals(85, BigDecimal.valueOf(1234.0), this.tokenizeFirst("1234.0"));
    }

    public void testNCNAME() throws IOException {
        this.assertSymbolEquals(87, "beef", this.tokenizeFirst("beef"));
        this.assertSymbolEquals(87, "_beef", this.tokenizeFirst("_beef"));
    }

    public void testNonAsciiIdentifiers() throws IOException {
        this.assertSymbolEquals(87, "M\u00e8ller", this.tokenizeFirst("M\u00e8ller"));
        this.assertSymbolEquals(87, "\uac20", this.tokenizeFirst("\uac20"));
    }

    public void testSimpleIdentifiersInSpace() throws IOException {
        XPathFlexTest.assertEquals((Object)"myElement", (Object)this.tokenizeFirst((String)" myElement ").value);
    }

    public void testUTF16_SurogatePair_valid() throws IOException {
        XPathFlex lexer = new XPathFlex((Reader)new StringReader(" monkey\ud83d\ude4ame "));
        Symbol symbol = lexer.next_token();
        XPathFlexTest.assertEquals((Object)"monkey\ud83d\ude4ame", (Object)symbol.value);
    }

    public void testUTF16_SurogatePair_invalid() throws IOException {
        try {
            XPathFlex lexer = new XPathFlex((Reader)new StringReader("\ude4a\ud83d"));
            lexer.next_token();
            XPathFlexTest.fail((String)"Should have gotten an exception");
        }
        catch (JFlexError jFlexError) {}
    }
}

