/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingMethodDeclTest
extends ASTRewritingTest {
    private static final Class THIS = ASTRewritingMethodDeclTest.class;

    public ASTRewritingMethodDeclTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingMethodDeclTest.allTests();
    }

    public void testMethodDeclChanges() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p1, int p2, int p3) {}\n");
        buf.append("    public void gee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void hee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void iee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public abstract void kee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "E");
        PrimitiveType newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "gee");
        ASTRewritingMethodDeclTest.assertTrue((String)"Has no return type: gee", (methodDecl.getReturnType() != null ? 1 : 0) != 0);
        Type returnType = methodDecl.getReturnType();
        PrimitiveType newReturnType2 = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.replace((ASTNode)returnType, (ASTNode)newReturnType2, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "hee");
        ASTRewritingMethodDeclTest.assertTrue((String)"Has no return type: hee", (methodDecl.getReturnType() != null ? 1 : 0) != 0);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "iee");
        SimpleName name = methodDecl.getName();
        SimpleName newName = ast.newSimpleName("xii");
        rewrite.replace((ASTNode)name, (ASTNode)newName, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "jee");
        List parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        SingleVariableDeclaration newParam = ASTRewritingMethodDeclTest.createNewParam(ast, "m");
        rewrite.replace((ASTNode)parameters.get(0), (ASTNode)newParam, null);
        List thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 2 thrown exceptions", (thrownExceptions.size() == 2 ? 1 : 0) != 0);
        SimpleName newThrownException = ast.newSimpleName("ArrayStoreException");
        rewrite.replace((ASTNode)thrownExceptions.get(1), (ASTNode)newThrownException, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "kee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        SingleVariableDeclaration newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        SingleVariableDeclaration newParam2 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        rewrite.replace((ASTNode)parameters.get(0), (ASTNode)newParam1, null);
        rewrite.replace((ASTNode)parameters.get(1), (ASTNode)newParam2, null);
        List thrownExceptions2 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 thrown exceptions", (thrownExceptions2.size() == 3 ? 1 : 0) != 0);
        SimpleName newThrownException1 = ast.newSimpleName("ArrayStoreException");
        SimpleName newThrownException2 = ast.newSimpleName("InterruptedException");
        rewrite.replace((ASTNode)thrownExceptions2.get(0), (ASTNode)newThrownException1, null);
        rewrite.replace((ASTNode)thrownExceptions2.get(2), (ASTNode)newThrownException2, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "lee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        newParam2 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        SingleVariableDeclaration newParam3 = ASTRewritingMethodDeclTest.createNewParam(ast, "m3");
        rewrite.replace((ASTNode)parameters.get(0), (ASTNode)newParam1, null);
        rewrite.replace((ASTNode)parameters.get(1), (ASTNode)newParam2, null);
        rewrite.replace((ASTNode)parameters.get(2), (ASTNode)newParam3, null);
        List thrownExceptions3 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 thrown exceptions", (thrownExceptions3.size() == 3 ? 1 : 0) != 0);
        SimpleName newThrownException3 = ast.newSimpleName("ArrayStoreException");
        rewrite.replace((ASTNode)thrownExceptions3.get(1), (ASTNode)newThrownException3, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public float E(int p1, int p2, int p3) {}\n");
        buf.append("    public float gee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public hee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void xii(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(float m, int p2, int p3) throws IllegalArgumentException, ArrayStoreException {}\n");
        buf.append("    public abstract void kee(float m1, float m2, int p3) throws ArrayStoreException, IllegalAccessException, InterruptedException;\n");
        buf.append("    public abstract void lee(float m1, float m2, float m3) throws IllegalArgumentException, ArrayStoreException, SecurityException;\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodReturnTypeChanges() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E() {}\n");
        buf.append("    E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    /* comment */ E(int i, int j) {}\n");
        buf.append("    public void gee1() {}\n");
        buf.append("    void gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    /* comment */ void gee3() {}\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        List list = type.bodyDeclarations();
        FunctionDeclaration methodDecl = (FunctionDeclaration)list.get(0);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)17, null);
        PrimitiveType newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(1);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)16, null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(2);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)16, null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(3);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)17, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(4);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)16, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(5);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)16, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public final float E() {}\n");
        buf.append("    final float E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    final /* comment */ float E(int i, int j) {}\n");
        buf.append("    public final gee1() {}\n");
        buf.append("    final gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    final gee3() {}\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodReturnTypeChanges2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public synchronized E() {}\n");
        buf.append("    public E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public /* comment */ E(int i, int j) {}\n");
        buf.append("    public synchronized void gee1() {}\n");
        buf.append("    public void gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public /* comment */ void gee3() {}\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        List list = type.bodyDeclarations();
        FunctionDeclaration methodDecl = (FunctionDeclaration)list.get(0);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)1, null);
        PrimitiveType newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(1);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)0, null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(2);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)0, null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(3);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)1, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(4);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)0, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(5);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)0, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public float E() {}\n");
        buf.append("    float E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    /* comment */ float E(int i, int j) {}\n");
        buf.append("    public gee1() {}\n");
        buf.append("    gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    gee3() {}\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodReturnTypeChangesAST3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E() {}\n");
        buf.append("    E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    /* comment */ E(int i, int j) {}\n");
        buf.append("    public void gee1() {}\n");
        buf.append("    void gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    /* comment */ void gee3() {}\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        List list = type.bodyDeclarations();
        FunctionDeclaration methodDecl = (FunctionDeclaration)list.get(0);
        ListRewrite modifiers = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        modifiers.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        PrimitiveType newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(1);
        modifiers = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        modifiers.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(2);
        modifiers = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        modifiers.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(3);
        modifiers = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        modifiers.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(4);
        modifiers = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        modifiers.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(5);
        modifiers = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        modifiers.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public final float E() {}\n");
        buf.append("    final float E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    final /* comment */ float E(int i, int j) {}\n");
        buf.append("    public final gee1() {}\n");
        buf.append("    final gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    final gee3() {}\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodReturnTypeChanges2AST3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public synchronized E() {}\n");
        buf.append("    public E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public /* comment */ E(int i, int j) {}\n");
        buf.append("    public synchronized void gee1() {}\n");
        buf.append("    public void gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public /* comment */ void gee3() {}\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        List list = type.bodyDeclarations();
        FunctionDeclaration methodDecl = (FunctionDeclaration)list.get(0);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(1), null);
        PrimitiveType newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(1);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(2);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        newReturnType = astRoot.getAST().newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = (FunctionDeclaration)list.get(3);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(1), null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(4);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        methodDecl = (FunctionDeclaration)list.get(5);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.RETURN_TYPE2_PROPERTY, null, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public float E() {}\n");
        buf.append("    float E(int i) {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    /* comment */ float E(int i, int j) {}\n");
        buf.append("    public gee1() {}\n");
        buf.append("    gee2() {}\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    gee3() {}\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testListRemoves() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p1, int p2, int p3) {}\n");
        buf.append("    public void gee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void hee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void iee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public abstract void kee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "E");
        List parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "gee");
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)0, null);
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(1), null);
        List thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 1 thrown exceptions", (thrownExceptions.size() == 1 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)thrownExceptions.get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "hee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(2), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "iee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        rewrite.remove((ASTNode)parameters.get(1), null);
        thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 2 thrown exceptions", (thrownExceptions.size() == 2 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)thrownExceptions.get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "jee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        rewrite.remove((ASTNode)parameters.get(2), null);
        thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 2 thrown exceptions", (thrownExceptions.size() == 2 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)thrownExceptions.get(1), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "kee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(1), null);
        rewrite.remove((ASTNode)parameters.get(2), null);
        thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 thrown exceptions", (thrownExceptions.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)thrownExceptions.get(1), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "lee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        rewrite.remove((ASTNode)parameters.get(1), null);
        rewrite.remove((ASTNode)parameters.get(2), null);
        thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 thrown exceptions", (thrownExceptions.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)thrownExceptions.get(0), null);
        rewrite.remove((ASTNode)thrownExceptions.get(2), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p2, int p3) {}\n");
        buf.append("    void gee(int p1, int p3) {}\n");
        buf.append("    public void hee(int p1, int p2) throws IllegalArgumentException {}\n");
        buf.append("    public void iee(int p3) throws IllegalAccessException {}\n");
        buf.append("    public void jee(int p2) throws IllegalArgumentException {}\n");
        buf.append("    public abstract void kee(int p1) throws IllegalArgumentException, SecurityException;\n");
        buf.append("    public abstract void lee() throws IllegalAccessException;\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testListRemoves2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void setMyProp(String property1) {}\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = (TypeDeclaration)astRoot.types().get(0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)type.bodyDeclarations().get(0);
        List parameters = methodDecl.parameters();
        rewrite.remove((ASTNode)parameters.get(0), null);
        SingleVariableDeclaration decl = ast.newSingleVariableDeclaration();
        decl.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
        decl.setName(ast.newSimpleName("property11"));
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)decl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void setMyProp(int property11) {}\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testListInserts() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p1, int p2, int p3) {}\n");
        buf.append("    public void gee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void hee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void iee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public abstract void kee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "E");
        List parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        SingleVariableDeclaration newParam = ASTRewritingMethodDeclTest.createNewParam(ast, "m");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertFirst((ASTNode)newParam, null);
        List thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 0 thrown exceptions", (thrownExceptions.size() == 0 ? 1 : 0) != 0);
        SimpleName newThrownException = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertFirst((ASTNode)newThrownException, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "gee");
        int newModifiers = 33;
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        List parameters2 = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters2.size() == 3 ? 1 : 0) != 0);
        ASTNode secondParam = (ASTNode)parameters2.get(1);
        SingleVariableDeclaration newParam2 = ASTRewritingMethodDeclTest.createNewParam(ast, "m");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertBefore((ASTNode)newParam2, secondParam, null);
        List thrownExceptions2 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 1 thrown exceptions", (thrownExceptions2.size() == 1 ? 1 : 0) != 0);
        ASTNode firstException = (ASTNode)thrownExceptions2.get(0);
        SimpleName newThrownException2 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertBefore((ASTNode)newThrownException2, firstException, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "hee");
        newModifiers = 41;
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        parameters2 = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters2.size() == 3 ? 1 : 0) != 0);
        SingleVariableDeclaration newParam3 = ASTRewritingMethodDeclTest.createNewParam(ast, "m");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)newParam3, null);
        List thrownExceptions3 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 1 thrown exceptions", (thrownExceptions3.size() == 1 ? 1 : 0) != 0);
        ASTNode firstException2 = (ASTNode)thrownExceptions3.get(0);
        SimpleName newThrownException3 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertAfter((ASTNode)newThrownException3, firstException2, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "iee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        ASTNode firstParam = (ASTNode)parameters.get(0);
        SingleVariableDeclaration newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        SingleVariableDeclaration newParam22 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY);
        listRewrite.insertBefore((ASTNode)newParam1, firstParam, null);
        listRewrite.insertBefore((ASTNode)newParam22, firstParam, null);
        List thrownExceptions4 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 2 thrown exceptions", (thrownExceptions4.size() == 2 ? 1 : 0) != 0);
        ASTNode firstException3 = (ASTNode)thrownExceptions4.get(0);
        SimpleName newThrownException4 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertAfter((ASTNode)newThrownException4, firstException3, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "jee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        ListRewrite listRewrite2 = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY);
        ASTNode firstParam2 = (ASTNode)parameters.get(0);
        SingleVariableDeclaration newParam12 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        SingleVariableDeclaration newParam23 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        listRewrite2.insertAfter((ASTNode)newParam23, firstParam2, null);
        listRewrite2.insertAfter((ASTNode)newParam12, firstParam2, null);
        thrownExceptions4 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 2 thrown exceptions", (thrownExceptions4.size() == 2 ? 1 : 0) != 0);
        SimpleName newThrownException1 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException1, null);
        SimpleName newThrownException22 = ast.newSimpleName("ArrayStoreException");
        rewrite.replace((ASTNode)thrownExceptions4.get(1), (ASTNode)newThrownException22, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "kee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        listRewrite2 = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY);
        ASTNode lastParam = (ASTNode)parameters.get(2);
        newParam12 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        newParam23 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        listRewrite2.insertAfter((ASTNode)newParam23, lastParam, null);
        listRewrite2.insertAfter((ASTNode)newParam12, lastParam, null);
        thrownExceptions4 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 thrown exceptions", (thrownExceptions4.size() == 3 ? 1 : 0) != 0);
        ASTNode lastException = (ASTNode)thrownExceptions4.get(2);
        rewrite.remove(lastException, null);
        newThrownException4 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertBefore((ASTNode)newThrownException4, lastException, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "lee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        listRewrite2 = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY);
        newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        newParam22 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        listRewrite2.insertFirst((ASTNode)newParam1, null);
        listRewrite2.insertLast((ASTNode)newParam22, null);
        thrownExceptions2 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 thrown exceptions", (thrownExceptions2.size() == 3 ? 1 : 0) != 0);
        ASTNode secondException = (ASTNode)thrownExceptions2.get(1);
        lastException = (ASTNode)thrownExceptions2.get(2);
        rewrite.remove(secondException, null);
        rewrite.remove(lastException, null);
        newThrownException4 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertAfter((ASTNode)newThrownException4, secondException, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(float m, int p1, int p2, int p3) throws InterruptedException {}\n");
        buf.append("    public synchronized void gee(int p1, float m, int p2, int p3) throws InterruptedException, IllegalArgumentException {}\n");
        buf.append("    public static synchronized void hee(int p1, int p2, int p3, float m) throws IllegalArgumentException, InterruptedException {}\n");
        buf.append("    public void iee(float m1, float m2, int p1, int p2, int p3) throws IllegalArgumentException, InterruptedException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, float m1, float m2, int p2, int p3) throws IllegalArgumentException, ArrayStoreException, InterruptedException {}\n");
        buf.append("    public abstract void kee(int p1, int p2, int p3, float m1, float m2) throws IllegalArgumentException, IllegalAccessException, InterruptedException;\n");
        buf.append("    public abstract void lee(float m1, int p1, int p2, int p3, float m2) throws IllegalArgumentException, InterruptedException;\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testListInsert() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "lee");
        List parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY);
        SingleVariableDeclaration newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        SingleVariableDeclaration newParam2 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        listRewrite.insertFirst((ASTNode)newParam1, null);
        listRewrite.insertLast((ASTNode)newParam2, null);
        List thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 thrown exceptions", (thrownExceptions.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)thrownExceptions.get(1), null);
        rewrite.remove((ASTNode)thrownExceptions.get(2), null);
        SimpleName newThrownException = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public abstract void lee(float m1, int p1, int p2, int p3, float m2) throws IllegalArgumentException, InterruptedException;\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testListCombinations() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p1, int p2, int p3) {}\n");
        buf.append("    public void gee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void hee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void iee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public abstract void kee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "E");
        List parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        rewrite.remove((ASTNode)parameters.get(1), null);
        rewrite.remove((ASTNode)parameters.get(2), null);
        SingleVariableDeclaration newParam = ASTRewritingMethodDeclTest.createNewParam(ast, "m");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)newParam, null);
        List thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 0 thrown exceptions", (thrownExceptions.size() == 0 ? 1 : 0) != 0);
        SimpleName newThrownException1 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException1, null);
        SimpleName newThrownException2 = ast.newSimpleName("ArrayStoreException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException2, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "gee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        rewrite.remove((ASTNode)parameters.get(1), null);
        SingleVariableDeclaration newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        rewrite.replace((ASTNode)parameters.get(2), (ASTNode)newParam1, null);
        SingleVariableDeclaration newParam2 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)newParam2, null);
        List thrownExceptions2 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 1 thrown exceptions", (thrownExceptions2.size() == 1 ? 1 : 0) != 0);
        SimpleName modifiedThrownException = ast.newSimpleName("InterruptedException");
        rewrite.replace((ASTNode)thrownExceptions2.get(0), (ASTNode)modifiedThrownException, null);
        SimpleName newThrownException22 = ast.newSimpleName("ArrayStoreException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException22, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "hee");
        parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        rewrite.remove((ASTNode)parameters.get(1), null);
        newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        rewrite.replace((ASTNode)parameters.get(2), (ASTNode)newParam1, null);
        newParam2 = ASTRewritingMethodDeclTest.createNewParam(ast, "m2");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertFirst((ASTNode)newParam2, null);
        thrownExceptions2 = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 1 thrown exceptions", (thrownExceptions2.size() == 1 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)thrownExceptions2.get(0), null);
        newThrownException2 = ast.newSimpleName("ArrayStoreException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(float m) throws InterruptedException, ArrayStoreException {}\n");
        buf.append("    public void gee(float m1, float m2) throws InterruptedException, ArrayStoreException {}\n");
        buf.append("    public void hee(float m2, float m1) throws ArrayStoreException {}\n");
        buf.append("    public void iee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public abstract void kee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testListCombination() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p1, int p2, int p3) {}\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "E");
        List parameters = methodDecl.parameters();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 3 parameters", (parameters.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)parameters.get(0), null);
        rewrite.remove((ASTNode)parameters.get(1), null);
        rewrite.remove((ASTNode)parameters.get(2), null);
        SingleVariableDeclaration newParam = ASTRewritingMethodDeclTest.createNewParam(ast, "m");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)newParam, null);
        List thrownExceptions = methodDecl.thrownExceptions();
        ASTRewritingMethodDeclTest.assertTrue((String)"must be 0 thrown exceptions", (thrownExceptions.size() == 0 ? 1 : 0) != 0);
        SimpleName newThrownException1 = ast.newSimpleName("InterruptedException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException1, null);
        SimpleName newThrownException2 = ast.newSimpleName("ArrayStoreException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(float m) throws InterruptedException, ArrayStoreException {}\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testListCombination2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    void bar() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    void foo2() {\n");
        buf.append("       // user comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration[] methods = type.getMethods();
        Arrays.sort(methods, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((FunctionDeclaration)o1).getName().getIdentifier().compareTo(((FunctionDeclaration)o2).getName().getIdentifier());
            }
        });
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        int i = 0;
        while (i < methods.length) {
            ASTNode copy = rewrite.createMoveTarget((ASTNode)methods[i]);
            listRewrite.insertLast(copy, null);
            ++i;
        }
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    void bar() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    void foo2() {\n");
        buf.append("       // user comment\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodBody() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p1, int p2, int p3) {}\n");
        buf.append("    public void gee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void hee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void iee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public abstract void kee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "E");
        Block body = methodDecl.getBody();
        ASTRewritingMethodDeclTest.assertTrue((String)"No body: E", (body != null ? 1 : 0) != 0);
        Block newBlock = ast.newBlock();
        rewrite.replace((ASTNode)body, (ASTNode)newBlock, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "gee");
        int newModifiers = 1025;
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        Block body2 = methodDecl.getBody();
        ASTRewritingMethodDeclTest.assertTrue((String)"No body: gee", (body2 != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)body2, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "kee");
        newModifiers = 2;
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        body2 = methodDecl.getBody();
        ASTRewritingMethodDeclTest.assertTrue((String)"Has body", (body2 == null ? 1 : 0) != 0);
        Block newBlock2 = ast.newBlock();
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.BODY_PROPERTY, (Object)newBlock2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public E(int p1, int p2, int p3) {\n");
        buf.append("    }\n");
        buf.append("    public abstract void gee(int p1, int p2, int p3) throws IllegalArgumentException;\n");
        buf.append("    public void hee(int p1, int p2, int p3) throws IllegalArgumentException {}\n");
        buf.append("    public void iee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    public void jee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException {}\n");
        buf.append("    private void kee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException {\n");
        buf.append("    }\n");
        buf.append("    public abstract void lee(int p1, int p2, int p3) throws IllegalArgumentException, IllegalAccessException, SecurityException;\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodDeclarationExtraDimensions() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public Object foo1() { return null; }\n");
        buf.append("    public Object foo2() throws IllegalArgumentException { return null; }\n");
        buf.append("    public Object foo3()[][] { return null; }\n");
        buf.append("    public Object foo4()[][] throws IllegalArgumentException { return null; }\n");
        buf.append("    public Object foo5()[][] { return null; }\n");
        buf.append("    public Object foo6(int i)[][] throws IllegalArgumentException { return null; }\n");
        buf.append("    public Object foo7(int i)[][] { return null; }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo1");
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)1, null);
        SimpleName newThrownException2 = ast.newSimpleName("ArrayStoreException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException2, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo2");
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)1, null);
        rewrite.remove((ASTNode)methodDecl.thrownExceptions().get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo3");
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)1, null);
        newThrownException2 = ast.newSimpleName("ArrayStoreException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException2, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo4");
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)1, null);
        rewrite.remove((ASTNode)methodDecl.thrownExceptions().get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo5");
        SingleVariableDeclaration newParam1 = ASTRewritingMethodDeclTest.createNewParam(ast, "m1");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.PARAMETERS_PROPERTY).insertLast((ASTNode)newParam1, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)4, null);
        SimpleName newThrownException22 = ast.newSimpleName("ArrayStoreException");
        rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY).insertLast((ASTNode)newThrownException22, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo6");
        rewrite.remove((ASTNode)methodDecl.parameters().get(0), null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)4, null);
        rewrite.remove((ASTNode)methodDecl.thrownExceptions().get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo7");
        rewrite.remove((ASTNode)methodDecl.getBody(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public Object foo1()[] throws ArrayStoreException { return null; }\n");
        buf.append("    public Object foo2()[] { return null; }\n");
        buf.append("    public Object foo3()[] throws ArrayStoreException { return null; }\n");
        buf.append("    public Object foo4()[] { return null; }\n");
        buf.append("    public Object foo5(float m1)[][][][] throws ArrayStoreException { return null; }\n");
        buf.append("    public Object foo6()[][][][] { return null; }\n");
        buf.append("    public Object foo7(int i)[][];\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testModifiersAST3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public Object foo1() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public Object foo2() { return null; }\n");
        buf.append("    public Object foo3() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public Object foo4() { return null; }\n");
        buf.append("    Object foo5() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public Object foo6() { return null; }\n");
        buf.append("    public Object foo7() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    public static Object foo8() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    Object foo9() { return null; }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo1");
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        listRewrite.insertFirst((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        listRewrite.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo2");
        listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        listRewrite.insertFirst((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        listRewrite.insertFirst((ASTNode)ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo3");
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        listRewrite.insertFirst((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo4");
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        listRewrite.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo5");
        JSdoc javadoc = ast.newJSdoc();
        TextElement textElem = ast.newTextElement();
        textElem.setText("Hello");
        TagElement tagElement = ast.newTagElement();
        tagElement.fragments().add(textElem);
        javadoc.tags().add(tagElement);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
        ListRewrite listRewrite2 = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        listRewrite2.insertFirst((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo6");
        rewrite.remove((ASTNode)methodDecl.getJavadoc(), null);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo7");
        javadoc = ast.newJSdoc();
        textElem = ast.newTextElement();
        textElem.setText("Hello");
        tagElement = ast.newTagElement();
        tagElement.fragments().add(textElem);
        javadoc.tags().add(tagElement);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo8");
        rewrite.remove((ASTNode)methodDecl.modifiers().get(0), null);
        rewrite.remove((ASTNode)methodDecl.modifiers().get(1), null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo9");
        listRewrite = rewrite.getListRewrite((ASTNode)methodDecl, FunctionDeclaration.MODIFIERS2_PROPERTY);
        listRewrite.insertFirst((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    final public synchronized Object foo1() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    static final public Object foo2() { return null; }\n");
        buf.append("    final Object foo3() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    final Object foo4() { return null; }\n");
        buf.append("    /**\n");
        buf.append("     * Hello\n");
        buf.append("     */\n");
        buf.append("    final Object foo5() { return null; }\n");
        buf.append("    Object foo6() { return null; }\n");
        buf.append("    /**\n");
        buf.append("     * Hello\n");
        buf.append("     */\n");
        buf.append("    Object foo7() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    Object foo8() { return null; }\n");
        buf.append("    /** javadoc comment */\n");
        buf.append("    final Object foo9() { return null; }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testFieldDeclaration() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class A {\n");
        buf.append("    int i1= 1;\n");
        buf.append("    int i2= 1, k2= 2, n2= 3;\n");
        buf.append("    static final int i3= 1, k3= 2, n3= 3;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("A.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMethodDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "A");
        FieldDeclaration[] fieldDeclarations = type.getFields();
        ASTRewritingMethodDeclTest.assertTrue((String)"Number of fieldDeclarations not 3", (fieldDeclarations.length == 3 ? 1 : 0) != 0);
        FieldDeclaration decl = fieldDeclarations[0];
        int newModifiers = 16;
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        PrimitiveType newType = ast.newPrimitiveType(PrimitiveType.BOOLEAN);
        rewrite.replace((ASTNode)decl.getType(), (ASTNode)newType, null);
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        frag.setName(ast.newSimpleName("k1"));
        frag.setInitializer(null);
        rewrite.getListRewrite((ASTNode)decl, FieldDeclaration.FRAGMENTS_PROPERTY).insertLast((ASTNode)frag, null);
        decl = fieldDeclarations[1];
        newModifiers = 152;
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        List fragments = decl.fragments();
        ASTRewritingMethodDeclTest.assertTrue((String)"Number of fragments not 3", (fragments.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)fragments.get(0), null);
        rewrite.remove((ASTNode)fragments.get(1), null);
        frag = ast.newVariableDeclarationFragment();
        frag.setName(ast.newSimpleName("k2"));
        frag.setInitializer(null);
        rewrite.replace((ASTNode)fragments.get(2), (ASTNode)frag, null);
        decl = fieldDeclarations[2];
        newModifiers = 0;
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class A {\n");
        buf.append("    final boolean i1= 1, k1;\n");
        buf.append("    static final transient int k2;\n");
        buf.append("    int i3= 1, k3= 2, n3= 3;\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testInitializer() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class A {\n");
        buf.append("    {\n");
        buf.append("        foo();\n");
        buf.append("    }\n");
        buf.append("    static {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("A.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingMethodDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "A");
        List declarations = type.bodyDeclarations();
        ASTRewritingMethodDeclTest.assertTrue((String)"Number of fieldDeclarations not 2", (declarations.size() == 2 ? 1 : 0) != 0);
        Initializer initializer = (Initializer)declarations.get(0);
        int newModifiers = 8;
        rewrite.set((ASTNode)initializer, (StructuralPropertyDescriptor)Initializer.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        Block block = ast.newBlock();
        block.statements().add(ast.newReturnStatement());
        rewrite.replace((ASTNode)initializer.getBody(), (ASTNode)block, null);
        initializer = (Initializer)declarations.get(1);
        newModifiers = 0;
        rewrite.set((ASTNode)initializer, (StructuralPropertyDescriptor)Initializer.MODIFIERS_PROPERTY, (Object)newModifiers, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class A {\n");
        buf.append("    static {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("    {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodDeclarationParamShuffel() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public Object foo1(int i, boolean b) { return null; }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo1");
        List params = methodDecl.parameters();
        SingleVariableDeclaration first = (SingleVariableDeclaration)params.get(0);
        SingleVariableDeclaration second = (SingleVariableDeclaration)params.get(1);
        rewrite.replace((ASTNode)first.getName(), (ASTNode)ast.newSimpleName("x"), null);
        rewrite.replace((ASTNode)second.getName(), (ASTNode)ast.newSimpleName("y"), null);
        ASTNode copy1 = rewrite.createCopyTarget((ASTNode)first);
        ASTNode copy2 = rewrite.createCopyTarget((ASTNode)second);
        rewrite.replace((ASTNode)first, copy2, null);
        rewrite.replace((ASTNode)second, copy1, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public Object foo1(boolean y, int x) { return null; }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodDeclarationParamShuffel1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public Object foo1(int i, boolean b) { return null; }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo1");
        List params = methodDecl.parameters();
        SingleVariableDeclaration first = (SingleVariableDeclaration)params.get(0);
        SingleVariableDeclaration second = (SingleVariableDeclaration)params.get(1);
        ASTNode copy2 = rewrite.createCopyTarget((ASTNode)second);
        rewrite.replace((ASTNode)first, copy2, null);
        rewrite.remove((ASTNode)second, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public abstract class E {\n");
        buf.append("    public Object foo1(boolean b) { return null; }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodDeclaration_bug24916() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    private int DD()[]{\n");
        buf.append("    };\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "DD");
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
        rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)FunctionDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)0, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    private DD(){\n");
        buf.append("    };\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodComments1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    // one line comment\n");
        buf.append("    private void foo(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    /**\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo");
        rewrite.remove((ASTNode)methodDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    /**\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodComments2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    // one line comment\n");
        buf.append("    private void foo(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo2");
        ASTNode node = rewrite.createCopyTarget((ASTNode)methodDecl);
        ASTNode firstDecl = (ASTNode)type.bodyDeclarations().get(0);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertAfter(node, firstDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    // one line comment\n");
        buf.append("    private void foo(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodComments3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    // one line comment\n");
        buf.append("\n");
        buf.append("    private void foo(){\n");
        buf.append("    } // another\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo");
        rewrite.remove((ASTNode)methodDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    // one line comment\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testBUG_38447() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("\n");
        buf.append("    private void foo(){\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo");
        rewrite.remove((ASTNode)methodDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodComments4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    // one line comment\n");
        buf.append("\n");
        buf.append("    private void foo(){\n");
        buf.append("    } // another\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo");
        ASTNode copy = rewrite.createCopyTarget((ASTNode)methodDecl);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast(copy, null);
        FunctionDeclaration newMethodDecl = this.createNewMethod(astRoot.getAST(), "xoo", false);
        rewrite.replace((ASTNode)methodDecl, (ASTNode)newMethodDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    // one line comment\n");
        buf.append("\n");
        buf.append("    private void xoo(String str) {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo2(){\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo(){\n");
        buf.append("    } // another\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testInsertFieldAfter() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    private int fCount1;\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        frag.setName(ast.newSimpleName("fColor"));
        FieldDeclaration newField = ast.newFieldDeclaration(frag);
        newField.setType((Type)ast.newPrimitiveType(PrimitiveType.CHAR));
        newField.setModifiers(2);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)newField, 1, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    private int fCount1;\n");
        buf.append("    private char fColor;\n");
        buf.append("\n");
        buf.append("    /*\n");
        buf.append("     *\n");
        buf.append("     */\n");
        buf.append("    private void foo1(){\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testVarArgs() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    private void foo1(String format, Object... args){\n");
        buf.append("    }\n");
        buf.append("    private void foo2(String format, Object[] args) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("DD.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "DD");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo1");
        SingleVariableDeclaration param = (SingleVariableDeclaration)methodDecl.parameters().get(1);
        rewrite.set((ASTNode)param, (StructuralPropertyDescriptor)SingleVariableDeclaration.VARARGS_PROPERTY, (Object)Boolean.FALSE, null);
        methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo2");
        param = (SingleVariableDeclaration)methodDecl.parameters().get(1);
        rewrite.set((ASTNode)param, (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, (Object)ast.newPrimitiveType(PrimitiveType.INT), null);
        rewrite.set((ASTNode)param, (StructuralPropertyDescriptor)SingleVariableDeclaration.VARARGS_PROPERTY, (Object)Boolean.TRUE, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class DD {\n");
        buf.append("    private void foo1(String format, Object args){\n");
        buf.append("    }\n");
        buf.append("    private void foo2(String format, int... args) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingMethodDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodDeclChangesBug77538() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("// comment\n");
        buf.append("public class A {\n");
        buf.append("\tpublic int foo() {\n");
        buf.append("\t\treturn 0;\n");
        buf.append("\t}\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("A.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingMethodDeclTest.findTypeDeclaration(astRoot, "A");
        FunctionDeclaration methodDecl = ASTRewritingMethodDeclTest.findMethodDeclaration(type, "foo");
        Block body = methodDecl.getBody();
        astRoot.recordModifications();
        Block newBody = ast.newBlock();
        methodDecl.setBody(newBody);
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName("lock"));
        fragment.setInitializer((Expression)ast.newQualifiedName((Name)ast.newSimpleName("OS"), ast.newSimpleName("lock")));
        VariableDeclarationExpression variableDeclarationExpression = ast.newVariableDeclarationExpression(fragment);
        variableDeclarationExpression.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("Lock")));
        ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)variableDeclarationExpression);
        newBody.statements().add(expressionStatement);
        TryStatement tryStatement = ast.newTryStatement();
        FunctionInvocation methodInvocation = ast.newFunctionInvocation();
        methodInvocation.setName(ast.newSimpleName("lock"));
        methodInvocation.setExpression((Expression)ast.newSimpleName("lock"));
        ExpressionStatement expressionStatement2 = ast.newExpressionStatement((Expression)methodInvocation);
        body.statements().add(0, expressionStatement2);
        tryStatement.setBody(body);
        Block finallyBlock = ast.newBlock();
        tryStatement.setFinally(finallyBlock);
        methodInvocation = ast.newFunctionInvocation();
        methodInvocation.setName(ast.newSimpleName("unLock"));
        methodInvocation.setExpression((Expression)ast.newSimpleName("lock"));
        expressionStatement2 = ast.newExpressionStatement((Expression)methodInvocation);
        finallyBlock.statements().add(expressionStatement2);
        newBody.statements().add(tryStatement);
        ASTRewritingMethodDeclTest.assertFalse((String)("Invalid extended length for " + body), (astRoot.getExtendedLength((ASTNode)body) < 0 ? 1 : 0) != 0);
    }
}

