/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.fixups;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class MigrateLicenseSupport {
    private static final String ANY_NONEOL_WHITESPACE = "[ \\t]*";
    private static final String ANY_END = ".*$";
    private static final String ANY = ".*";
    private static final String ONE_PROPERTY_DELIMITER = "[=:]";
    private static final String START_OF_LINE = "^";
    private static final String KEY_WORD = "license";
    private static final String URL_KEY_WORD = "licenseURL";
    private static final String CONTINUATION = "\\\\ *$";
    int CR = 13;
    int LF = 10;
    private static String LICENSE_KEY = "^license[ \\t]*[=:].*$";
    private static String LICENSE_URL = "^licenseURL[ \\t]*[=:].*$";
    private static String LICENSE_FILE_LINE = "^[ \\t]*license.html.*$";
    private static String EPL_FILE_LINE = "^[ \\t]*epl-2.0.html.*$";
    private static String FEATURE_START = "^.*<feature.*$";
    private static String FEATURE_END = "^.*>.*$";
    private static final String PLUGINID = "org.eclipse.wtp.releng.fixups";
    private static final String CONSOLE_NAME = "Releng Console";
    private static boolean DEBUG = false;
    private ArrayList featureProjects = new ArrayList();
    private ArrayList featureSourceProjects = new ArrayList();
    private ArrayList featureProjectsMissingProperties = new ArrayList();
    private ArrayList featureProjectsMissingLicense = new ArrayList();
    private ArrayList featuresModified = new ArrayList();
    private ArrayList featuresOkNotModified = new ArrayList();
    private ArrayList featuresCouldNotBeModified = new ArrayList();
    private int nFeatures;
    private long starttime;

    public Object checkAndMigrate() throws ExecutionException {
        Object returnobject = 0;
        this.starttime = System.currentTimeMillis();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.initCounterArrays();
        int j = 0;
        while (j < projects.length) {
            IProject project = projects[j];
            IFile file = project.getFile("feature.xml");
            if (file != null && file.exists() && !project.getName().equals("org.eclipse.license")) {
                ++this.nFeatures;
                returnobject = this.processProjectDirectory(project);
                IFolder sourceTemplate = project.getFolder("sourceTemplateFeature");
                if (sourceTemplate != null && sourceTemplate.exists()) {
                    ++this.nFeatures;
                    SourceTemplateProject sourceTemplateProject = new SourceTemplateProject(project);
                    returnobject = this.processProjectDirectory(sourceTemplateProject);
                }
            }
            ++j;
        }
        this.reportSummaryOfResults();
        return returnobject;
    }

    private Object processProjectDirectory(IProject project) {
        Integer returnobject = 0;
        String propNamePath = "feature.properties";
        IFile propfile = project.getFile(propNamePath);
        if (propfile != null && propfile.exists()) {
            this.featureProjects.add(project);
            try {
                this.fixup(propfile, project);
            }
            catch (IOException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
            catch (CoreException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
        } else {
            this.featureProjectsMissingProperties.add(project);
        }
        return returnobject;
    }

    private Object processProjectDirectory(SourceTemplateProject project) {
        Integer returnobject = 0;
        String propNamePath = "feature.properties";
        IFile propfile = project.getFile(propNamePath);
        if (propfile != null && propfile.exists()) {
            this.featureSourceProjects.add(project);
            try {
                this.fixup(propfile, project);
            }
            catch (IOException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
            catch (CoreException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
        } else {
            this.featureProjectsMissingProperties.add(project);
        }
        return returnobject;
    }

    private void reportSummaryOfResults() {
        MessageConsole myConsole = this.findConsole(CONSOLE_NAME);
        MessageConsoleStream out = myConsole.newMessageStream();
        myConsole.activate();
        out.println();
        out.println("\tTotal number of features found: " + this.nFeatures);
        out.println("\t\t Total number of primary features found: " + this.featureProjects.size());
        out.println("\t\t Total number of source features found: " + this.featureSourceProjects.size());
        out.println();
        this.report(out, this.featureProjectsMissingProperties, "The following feature(s) contained no feature.properties file");
        this.report(out, this.featureProjectsMissingLicense, "The following feature(s) contained no license property");
        this.report(out, this.featuresOkNotModified, "The following feature(s) were found ok, and not modified");
        this.report(out, this.featuresModified, "The following feature(s) were modified");
        this.report(out, this.featuresCouldNotBeModified, "The following feature(s) needed to be modified, but for some reason could not be. \n\tThis is likely due to a non-standard (but legal) way of writing property keys and values");
        out.println();
        long elapsedTime = System.currentTimeMillis() - this.starttime;
        out.println("\tElapsed processing time : " + elapsedTime + " ms");
        out.println();
    }

    private void initCounterArrays() {
        this.featureProjects.clear();
        this.featureSourceProjects.clear();
        this.featureProjectsMissingProperties.clear();
        this.featureProjectsMissingLicense.clear();
        this.featuresModified.clear();
        this.featuresOkNotModified.clear();
        this.featuresCouldNotBeModified.clear();
    }

    private void fixup(IFile propfile, IProject project) throws IOException, CoreException {
        Properties featureproperties = new Properties();
        featureproperties.load(propfile.getContents());
        String license = featureproperties.getProperty(KEY_WORD);
        if (license == null) {
            this.featuresOkNotModified.add(project);
        } else if (this.rewrite(propfile, project)) {
            this.featuresModified.add(project);
            this.removeLicenseHtml(project);
        } else {
            this.featuresCouldNotBeModified.add(project);
        }
    }

    private String inferEOL(IFile featureProperties) throws CoreException, IOException {
        InputStream contentToPeekForEOL = featureProperties.getContents();
        String likelyEOL = this.computeEOL(contentToPeekForEOL);
        contentToPeekForEOL.close();
        return likelyEOL;
    }

    private String computeEOL(InputStream contentToPeekForEOL) throws IOException {
        int linuxLF = 0;
        int windowsCRLF = 0;
        int macCR = 0;
        int MAX = 1000;
        int count = 0;
        while (contentToPeekForEOL.available() > 0 && count < MAX) {
            int c1;
            int c = contentToPeekForEOL.read();
            if (c == -1) continue;
            ++count;
            if (c == this.LF) {
                ++linuxLF;
                continue;
            }
            if (c != this.CR || (c1 = contentToPeekForEOL.read()) == -1) continue;
            ++count;
            if (c1 == this.LF) {
                ++windowsCRLF;
                continue;
            }
            if (c1 == this.CR) {
                ++macCR;
                ++macCR;
                continue;
            }
            ++macCR;
        }
        if (DEBUG) {
            System.out.println("linuxLF: " + linuxLF);
            System.out.println("windowsCRLF: " + windowsCRLF);
            System.out.println("macCR: " + macCR);
        }
        String result = null;
        result = linuxLF > windowsCRLF ? (linuxLF > macCR ? "" + (char)this.LF : "" + (char)this.CR) : (windowsCRLF > macCR ? "" + (char)this.CR + (char)this.LF : "" + (char)this.CR);
        return result;
    }

    private void closereader(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean removeLicenseHtml(IProject project) {
        IFile license = project.getFile("license.html");
        IFile epl = project.getFile("epl-2.0.html");
        IFile buildProperties = project.getFile("build.properties");
        IFile featureFile = project.getFile("feature.xml");
        boolean result = this.commonRemoveFiles(license, epl, buildProperties, featureFile);
        return result;
    }

    private void report(MessageConsoleStream out, ArrayList tocheck, String message) {
        if (tocheck != null && tocheck.size() > 0) {
            out.println();
            out.println("\t" + message);
            out.println("\t\tCount: " + tocheck.size());
            for (Object object : tocheck) {
                String name = null;
                name = object instanceof IProject ? ((IProject)object).getName() : ((SourceTemplateProject)object).getName();
                out.println("\t\t" + name);
            }
            out.println();
        }
    }

    private MessageConsole findConsole(String name) {
        MessageConsole myConsole = null;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                myConsole = (MessageConsole)existing[i];
            }
            ++i;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(name, null);
            conMan.addConsoles(new IConsole[]{myConsole});
        }
        return myConsole;
    }

    private void fixup(IFile propfile, SourceTemplateProject project) throws IOException, CoreException {
        Properties featureproperties = new Properties();
        featureproperties.load(propfile.getContents());
        String license = featureproperties.getProperty(KEY_WORD);
        if (license == null) {
            this.featuresOkNotModified.add(project);
        } else if (this.rewrite(propfile, project)) {
            this.featuresModified.add(project);
            this.removeLicenseHtml(project);
        } else {
            this.featuresCouldNotBeModified.add(project);
        }
    }

    private boolean rewrite(IFile propfile, IProject project) throws CoreException, IOException {
        IFile featureProperties = project.getFile("feature.properties");
        return this.rewriteFeaturePropertiesCommon(featureProperties);
    }

    /*
     * Exception decompiling
     */
    private boolean rewriteFeaturePropertiesCommon(IFile featureProperties) throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean rewrite(IFile propfile, SourceTemplateProject project) throws CoreException, IOException {
        IFile featureProperties = project.getFile("feature.properties");
        return this.rewriteFeaturePropertiesCommon(featureProperties);
    }

    private boolean removeLicenseHtml(SourceTemplateProject project) {
        IFile license = project.getFile("license.html");
        IFile epl = project.getFile("epl-2.0.html");
        IFile buildProperties = project.getFile("build.properties");
        boolean result = this.commonRemoveFiles(license, epl, buildProperties, null);
        return result;
    }

    private boolean commonRemoveFiles(IFile license, IFile epl, IFile buildProperties, IFile featureFile) {
        boolean result = true;
        try {
            if (license != null && license.exists()) {
                license.delete(true, null);
            }
            if (epl != null && epl.exists()) {
                epl.delete(true, null);
            }
            if (buildProperties != null && buildProperties.exists()) {
                result = this.rewriteBuildProperties(buildProperties);
            }
            if (result && featureFile != null && featureFile.exists()) {
                result = this.rewriteFeatureXML(featureFile);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private boolean rewriteFeatureXML(IFile featureFile) throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String removeChar(String oneline, char c) {
        int pos = oneline.lastIndexOf(c);
        String result = oneline.substring(0, pos);
        result = String.valueOf(result) + oneline.substring(pos + 1);
        return result;
    }

    private String inferrIndent(String oneline) {
        String inferredIndent = "";
        int i = 0;
        while (i < oneline.length()) {
            char wsChar = oneline.charAt(i);
            if (wsChar != ' ' && wsChar != '\t') break;
            inferredIndent = String.valueOf(inferredIndent) + wsChar;
            ++i;
        }
        return inferredIndent;
    }

    /*
     * Exception decompiling
     */
    private boolean rewriteBuildProperties(IFile buildProperties) throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    class SourceTemplateProject {
        public String sourceTemplateDirectory = "sourceTemplateFeature/";
        IProject project;

        public SourceTemplateProject(IProject project) {
            this.project = project;
        }

        public IFile getFile(String filename) {
            return this.project.getFile(String.valueOf(this.sourceTemplateDirectory) + filename);
        }

        public String getName() {
            return String.valueOf(this.project.getName()) + "[sourceTemplateFeature]";
        }
    }
}

