/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.javaee.web;

import org.eclipse.emf.ecore.EFactory;

import org.eclipse.jst.javaee.web.internal.metadata.WebPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.jst.javaee.web.internal.metadata.WebPackage
 * @generated
 */
public interface WebFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	WebFactory eINSTANCE = org.eclipse.jst.javaee.web.internal.impl.WebFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Absolute Ordering Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Absolute Ordering Type</em>'.
	 * @generated
	 */
	AbsoluteOrderingType createAbsoluteOrderingType();

	/**
	 * Returns a new object of class '<em>Auth Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Auth Constraint</em>'.
	 * @generated
	 */
	AuthConstraint createAuthConstraint();

	/**
	 * Returns a new object of class '<em>Cookie Comment Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cookie Comment Type</em>'.
	 * @generated
	 */
	CookieCommentType createCookieCommentType();

	/**
	 * Returns a new object of class '<em>Cookie Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cookie Config Type</em>'.
	 * @generated
	 */
	CookieConfigType createCookieConfigType();

	/**
	 * Returns a new object of class '<em>Cookie Domain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cookie Domain Type</em>'.
	 * @generated
	 */
	CookieDomainType createCookieDomainType();

	/**
	 * Returns a new object of class '<em>Cookie Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cookie Name Type</em>'.
	 * @generated
	 */
	CookieNameType createCookieNameType();

	/**
	 * Returns a new object of class '<em>Cookie Path Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cookie Path Type</em>'.
	 * @generated
	 */
	CookiePathType createCookiePathType();

	/**
	 * Returns a new object of class '<em>Error Page</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Error Page</em>'.
	 * @generated
	 */
	ErrorPage createErrorPage();

	/**
	 * Returns a new object of class '<em>Filter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Filter</em>'.
	 * @generated
	 */
	Filter createFilter();

	/**
	 * Returns a new object of class '<em>Filter Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Filter Mapping</em>'.
	 * @generated
	 */
	FilterMapping createFilterMapping();

	/**
	 * Returns a new object of class '<em>Form Login Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Form Login Config</em>'.
	 * @generated
	 */
	FormLoginConfig createFormLoginConfig();

	/**
	 * Returns a new object of class '<em>Locale Encoding Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Locale Encoding Mapping</em>'.
	 * @generated
	 */
	LocaleEncodingMapping createLocaleEncodingMapping();

	/**
	 * Returns a new object of class '<em>Locale Encoding Mapping List</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Locale Encoding Mapping List</em>'.
	 * @generated
	 */
	LocaleEncodingMappingList createLocaleEncodingMappingList();

	/**
	 * Returns a new object of class '<em>Login Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Login Config</em>'.
	 * @generated
	 */
	LoginConfig createLoginConfig();

	/**
	 * Returns a new object of class '<em>Mime Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mime Mapping</em>'.
	 * @generated
	 */
	MimeMapping createMimeMapping();

	/**
	 * Returns a new object of class '<em>Multipart Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Multipart Config Type</em>'.
	 * @generated
	 */
	MultipartConfigType createMultipartConfigType();

	/**
	 * Returns a new object of class '<em>Ordering Ordering Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ordering Ordering Type</em>'.
	 * @generated
	 */
	OrderingOrderingType createOrderingOrderingType();

	/**
	 * Returns a new object of class '<em>Ordering Others Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ordering Others Type</em>'.
	 * @generated
	 */
	OrderingOthersType createOrderingOthersType();

	/**
	 * Returns a new object of class '<em>Ordering Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ordering Type</em>'.
	 * @generated
	 */
	OrderingType createOrderingType();

	/**
	 * Returns a new object of class '<em>Security Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Security Constraint</em>'.
	 * @generated
	 */
	SecurityConstraint createSecurityConstraint();

	/**
	 * Returns a new object of class '<em>Servlet</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Servlet</em>'.
	 * @generated
	 */
	Servlet createServlet();

	/**
	 * Returns a new object of class '<em>Servlet Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Servlet Mapping</em>'.
	 * @generated
	 */
	ServletMapping createServletMapping();

	/**
	 * Returns a new object of class '<em>Session Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Session Config</em>'.
	 * @generated
	 */
	SessionConfig createSessionConfig();

	/**
	 * Returns a new object of class '<em>User Data Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Data Constraint</em>'.
	 * @generated
	 */
	UserDataConstraint createUserDataConstraint();

	/**
	 * Returns a new object of class '<em>App</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>App</em>'.
	 * @generated
	 */
	WebApp createWebApp();

	/**
	 * Returns a new object of class '<em>App Deployment Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>App Deployment Descriptor</em>'.
	 * @generated
	 */
	WebAppDeploymentDescriptor createWebAppDeploymentDescriptor();

	/**
	 * Returns a new object of class '<em>Fragment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Fragment</em>'.
	 * @generated
	 */
	WebFragment createWebFragment();

	/**
	 * Returns a new object of class '<em>Resource Collection</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Resource Collection</em>'.
	 * @generated
	 */
	WebResourceCollection createWebResourceCollection();

	/**
	 * Returns a new object of class '<em>Welcome File List</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Welcome File List</em>'.
	 * @generated
	 */
	WelcomeFileList createWelcomeFileList();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	WebPackage getWebPackage();

} //WebFactory
