/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.ui.ChromiumDebugUIPlugin;
import org.eclipse.wst.jsdt.chromium.debug.ui.PluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.JsInspectExpression;
import org.eclipse.wst.jsdt.chromium.debug.ui.editors.JavascriptUtil;

public class JsInspectSnippetAction
implements IEditorActionDelegate {
    private static final String ACTION_DEFINITION_ID = "org.eclipse.wst.jsdt.chromium.debug.ui.commands.Inspect";
    private IEditorPart activeEditorPart;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditorPart = targetEditor;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static ISelection getTargetSelection(IWorkbenchPart targetPart) {
        ISelectionProvider provider;
        if (targetPart != null && (provider = targetPart.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void run(IAction action) {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null) {
            return;
        }
        EvaluateContext evaluateContext = (EvaluateContext)context.getAdapter(EvaluateContext.class);
        if (evaluateContext == null) {
            return;
        }
        IEditorPart editorPart = this.activeEditorPart;
        String currentSelectedText = JsInspectSnippetAction.retrieveSelection((IWorkbenchPart)editorPart);
        EvaluateCallbackImpl callback = new EvaluateCallbackImpl(evaluateContext, editorPart, currentSelectedText);
        evaluateContext.getJsEvaluateContext().evaluateAsync(currentSelectedText, null, (JsEvaluateContext.EvaluateCallback)callback, null);
    }

    private static String retrieveSelection(IWorkbenchPart targetPart) {
        ISelection targetSelection = JsInspectSnippetAction.getTargetSelection(targetPart);
        if (targetSelection instanceof ITextSelection) {
            IEditorPart editor;
            ITextSelection ts = (ITextSelection)targetSelection;
            String text = ts.getText();
            if (JsInspectSnippetAction.textHasContent(text)) {
                return text;
            }
            if (targetPart instanceof IEditorPart && (editor = (IEditorPart)targetPart) instanceof ITextEditor) {
                return JsInspectSnippetAction.extractSurroundingWord(ts, (ITextEditor)editor);
            }
        }
        return null;
    }

    private static String extractSurroundingWord(ITextSelection targetSelection, ITextEditor editor) {
        return JavascriptUtil.extractSurroundingJsIdentifier(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()), targetSelection.getOffset());
    }

    private static boolean textHasContent(String text) {
        return text != null && JavascriptUtil.ID_PATTERN.matcher(text).find();
    }

    private static Point getPopupAnchor(StyledText textWidget) {
        if (textWidget != null) {
            Point docRange = textWidget.getSelectionRange();
            int midOffset = docRange.x + docRange.y / 2;
            Point point = textWidget.getLocationAtOffset(midOffset);
            point = textWidget.toDisplay(point);
            point.y += JsInspectSnippetAction.getFontHeight(textWidget);
            return point;
        }
        return null;
    }

    private static int getFontHeight(StyledText textWidget) {
        return PluginUtil.getFontMetrics((Drawable)textWidget, textWidget.getFont()).getHeight();
    }

    private static class EvaluateCallbackImpl
    implements JsEvaluateContext.EvaluateCallback {
        private final EvaluateContext evaluateContext;
        private final IEditorPart editorPart;
        private final String selectedText;

        EvaluateCallbackImpl(EvaluateContext evaluateContext, IEditorPart editorPart, String selectedText) {
            this.evaluateContext = evaluateContext;
            this.editorPart = editorPart;
            this.selectedText = selectedText;
        }

        public void success(JsEvaluateContext.ResultOrException result) {
            if (ChromiumDebugUIPlugin.getDefault() == null) {
                return;
            }
            if (ChromiumDebugUIPlugin.getDisplay().isDisposed()) {
                return;
            }
            result.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<Void>(){

                public Void visitResult(JsValue value) {
                    EvaluateCallbackImpl.this.displayResult(value, null);
                    return null;
                }

                public Void visitException(JsValue exception) {
                    EvaluateCallbackImpl.this.displayResult(null, exception.getValueString());
                    return null;
                }
            });
        }

        public void failure(Exception cause) {
            this.displayResult(null, cause.getMessage());
        }

        private void displayResult(JsValue value, String errorMessage) {
            final StyledText styledText = this.getStyledText((IWorkbenchPart)this.editorPart);
            if (styledText == null) {
                return;
            }
            JsInspectExpression expression = new JsInspectExpression(this.evaluateContext, this.selectedText, value, errorMessage);
            ChromiumDebugUIPlugin.getDisplay().asyncExec(new Runnable((IExpression)expression){
                private final /* synthetic */ IExpression val$expression;
                {
                    this.val$expression = iExpression;
                }

                @Override
                public void run() {
                    EvaluateCallbackImpl.this.showPopup(styledText, this.val$expression);
                }
            });
        }

        private void showPopup(StyledText textWidget, IExpression expression) {
            ISelection originalSelection;
            ITextEditor textEditor;
            IEditorPart part = this.editorPart;
            if (part instanceof ITextEditor) {
                textEditor = (ITextEditor)part;
                originalSelection = JsInspectSnippetAction.getTargetSelection((IWorkbenchPart)this.editorPart);
            } else {
                textEditor = null;
                originalSelection = null;
            }
            Shell shell = this.editorPart.getSite().getShell();
            InspectPopupDialog displayPopup = new InspectPopupDialog(shell, JsInspectSnippetAction.getPopupAnchor(textWidget), JsInspectSnippetAction.ACTION_DEFINITION_ID, expression){

                public boolean close() {
                    boolean returnValue = super.close();
                    if (textEditor != null && originalSelection != null) {
                        textEditor.getSelectionProvider().setSelection(originalSelection);
                    }
                    return returnValue;
                }
            };
            displayPopup.open();
        }

        private StyledText getStyledText(IWorkbenchPart part) {
            ITextViewer viewer = (ITextViewer)part.getAdapter(ITextViewer.class);
            StyledText textWidget = null;
            if (viewer == null) {
                Control control = (Control)part.getAdapter(Control.class);
                if (control instanceof StyledText) {
                    textWidget = (StyledText)control;
                }
            } else {
                textWidget = viewer.getTextWidget();
            }
            return textWidget;
        }
    }
}

