/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="resource-env-refType", propOrder={"descriptions", "resourceEnvRefName", "resourceEnvRefType", "mappedName", "injectionTarget", "lookupName"})
public class ResourceEnvRef
implements JndiReference {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="resource-env-ref-name", required=true)
    protected String resourceEnvRefName;
    @XmlElement(name="resource-env-ref-type")
    protected String resourceEnvRefType;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public ResourceEnvRef() {
    }

    public ResourceEnvRef(String resourceEnvRefName, String resourceEnvRefType) {
        this.resourceEnvRefName = resourceEnvRefName;
        this.resourceEnvRefType = resourceEnvRefType;
    }

    public ResourceEnvRef(String resourceEnvRefName, Class resourceEnvRefType) {
        this(resourceEnvRefName, resourceEnvRefType.getName());
    }

    public ResourceEnvRef name(String resourceEnvRefName) {
        this.resourceEnvRefName = resourceEnvRefName;
        return this;
    }

    public ResourceEnvRef type(String resourceEnvRefType) {
        this.resourceEnvRefType = resourceEnvRefType;
        return this;
    }

    public ResourceEnvRef type(Class<?> resourceEnvRefType) {
        return this.type(resourceEnvRefType.getName());
    }

    public ResourceEnvRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public ResourceEnvRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public ResourceEnvRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.resourceEnvRefName == null) {
            this.resourceEnvRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public ResourceEnvRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.getResourceEnvRefName();
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    @XmlTransient
    public String getType() {
        return this.getResourceEnvRefType();
    }

    @Override
    public void setName(String name) {
        this.setResourceEnvRefName(name);
    }

    @Override
    public void setType(String type) {
        this.setResourceEnvRefType(type);
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getResourceEnvRefName() {
        return this.resourceEnvRefName;
    }

    public void setResourceEnvRefName(String value) {
        this.resourceEnvRefName = value;
    }

    public String getResourceEnvRefType() {
        return this.resourceEnvRefType;
    }

    public void setResourceEnvRefType(String value) {
        this.resourceEnvRefType = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "ResourceEnvRef{name='" + this.resourceEnvRefName + '\'' + ", type='" + this.resourceEnvRefType + '\'' + ", mappedName='" + this.mappedName + '\'' + ", lookupName='" + this.lookupName + '\'' + '}';
    }
}

