/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple.primitive;

import org.eclipse.collections.api.tuple.primitive.DoubleObjectPair;
import org.eclipse.collections.impl.block.factory.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleObjectPairImpl<T>
implements DoubleObjectPair<T> {
    private static final long serialVersionUID = 1L;
    private final double one;
    private final T two;

    DoubleObjectPairImpl(double newOne, T newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    public double getOne() {
        return this.one;
    }

    public T getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleObjectPair)) {
            return false;
        }
        DoubleObjectPair that = (DoubleObjectPair)o;
        return Double.compare(this.one, that.getOne()) == 0 && Comparators.nullSafeEquals(this.two, that.getTwo());
    }

    public int hashCode() {
        return 29 * (int)(Double.doubleToLongBits(this.one) ^ Double.doubleToLongBits(this.one) >>> 32) + (this.two == null ? 0 : this.two.hashCode());
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    public int compareTo(DoubleObjectPair<T> that) {
        int i = Double.compare(this.one, that.getOne());
        if (i != 0) {
            return i;
        }
        return ((Comparable)this.two).compareTo(that.getTwo());
    }
}

