/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.LongStack;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.stack.mutable.primitive.LongArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableLongSingletonStack
implements ImmutableLongStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long element1;

    ImmutableLongSingletonStack(long element) {
        this.element1 = element;
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(LongArrayStack.newStackWith(this.element1).longIterator());
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        procedure.value(this.element1);
    }

    public int count(LongPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public long peek() {
        return this.element1;
    }

    public LongList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new LongArrayList(0);
        }
        if (count == 1) {
            return LongArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    public long peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    public ImmutableLongStack select(LongPredicate predicate) {
        return predicate.accept(this.element1) ? LongStacks.immutable.with(this.element1) : LongStacks.immutable.with();
    }

    public ImmutableLongStack reject(LongPredicate predicate) {
        return predicate.accept(this.element1) ? LongStacks.immutable.with() : LongStacks.immutable.with(this.element1);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    public long sum() {
        return this.element1;
    }

    public long max() {
        return this.element1;
    }

    public long maxIfEmpty(long defaultValue) {
        return this.element1;
    }

    public long min() {
        return this.element1;
    }

    public long minIfEmpty(long defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public long[] toSortedArray() {
        return new long[]{this.element1};
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newListWith(this.element1);
    }

    public long[] toArray() {
        return new long[]{this.element1};
    }

    public boolean contains(long value) {
        return this.element1 == value;
    }

    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableLongList toList() {
        return LongArrayList.newListWith(this.element1);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSetWith(this.element1);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBagWith(this.element1);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public ImmutableLongStack toImmutable() {
        return this;
    }

    public ImmutableLongStack push(long element) {
        return LongStacks.immutable.with(new long[]{this.element1, element});
    }

    public ImmutableLongStack pop() {
        return LongStacks.immutable.with();
    }

    public ImmutableLongStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return LongStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return this.element1 == stack.peek();
    }

    public int hashCode() {
        return 31 + (int)(this.element1 ^ this.element1 >>> 32);
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

