/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.primitive.DoubleLists;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseDoubleIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleSingletonList
implements ImmutableDoubleList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double element1;

    ImmutableDoubleSingletonList(double element) {
        this.element1 = element;
    }

    public double get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public double getFirst() {
        return this.element1;
    }

    public double getLast() {
        return this.element1;
    }

    public int indexOf(double value) {
        return Double.compare(this.element1, value) == 0 ? 0 : -1;
    }

    public int lastIndexOf(double value) {
        return Double.compare(this.element1, value) == 0 ? 0 : -1;
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)DoubleArrayList.newListWith(this.element1).doubleIterator());
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(DoubleIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    public int count(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public ImmutableDoubleList select(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? DoubleArrayList.newListWith(this.element1).toImmutable() : new DoubleArrayList().toImmutable();
    }

    public ImmutableDoubleList reject(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? new DoubleArrayList().toImmutable() : DoubleArrayList.newListWith(this.element1).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(DoubleToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public double sum() {
        return this.element1;
    }

    public double max() {
        return this.element1;
    }

    public double maxIfEmpty(double defaultValue) {
        return this.element1;
    }

    public double min() {
        return this.element1;
    }

    public double minIfEmpty(double defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public double[] toSortedArray() {
        return new double[]{this.element1};
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    public int binarySearch(double value) {
        if (Double.compare(this.element1, value) == 0) {
            return 0;
        }
        if (Double.compare(this.element1, value) < 0) {
            return -2;
        }
        return -1;
    }

    public double dotProduct(DoubleList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return this.element1 * list.getFirst();
    }

    public double[] toArray() {
        return new double[]{this.element1};
    }

    public boolean contains(double value) {
        return Double.compare(this.element1, value) == 0;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public LazyDoubleIterable asReversed() {
        return ReverseDoubleIterable.adapt((DoubleList)this);
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.element1);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.element1);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableDoubleList toImmutable() {
        return this;
    }

    public ImmutableDoubleSingletonList toReversed() {
        return this;
    }

    public ImmutableDoubleList newWith(double element) {
        return DoubleLists.immutable.with(new double[]{this.element1, element});
    }

    public ImmutableDoubleList newWithout(double element) {
        return Double.compare(this.element1, element) == 0 ? DoubleLists.immutable.with() : this;
    }

    public ImmutableDoubleList newWithAll(DoubleIterable elements) {
        DoubleArrayList arrayList = DoubleArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableDoubleList newWithoutAll(DoubleIterable elements) {
        return elements.contains(this.element1) ? DoubleLists.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1, 0);
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof DoubleList)) {
            return false;
        }
        DoubleList list = (DoubleList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return Double.compare(this.element1, list.get(0)) == 0;
    }

    public int hashCode() {
        return 31 + (int)(Double.doubleToLongBits(this.element1) ^ Double.doubleToLongBits(this.element1) >>> 32);
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableDoubleList distinct() {
        return this;
    }

    public ImmutableDoubleList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

