/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.factory.primitive;

import org.eclipse.collections.api.factory.set.primitive.ImmutableBooleanSetFactory;
import org.eclipse.collections.api.factory.set.primitive.MutableBooleanSetFactory;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.primitive.MutableBooleanSetFactoryImpl;

/**
 * BooleanSets is a static utility for creating {@link ImmutableBooleanSetFactory}.
 * This file was automatically generated from template file primitiveSets.stg.
 *
 * @since 3.2.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class BooleanSets
{
    public static final ImmutableBooleanSetFactory immutable = new ImmutableBooleanSetFactoryImpl();
    public static final MutableBooleanSetFactory mutable = new MutableBooleanSetFactoryImpl();

    private BooleanSets()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
