/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.bag.primitive.MutableDoubleBagFactory;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;

/**
 * MutableDoubleBagFactoryImpl is a factory implementation which creates instances of type {@link MutableDoubleBag}.
 * This file was automatically generated from template file mutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableDoubleBagFactoryImpl implements MutableDoubleBagFactory
{
    public MutableDoubleBag empty()
    {
        return new DoubleHashBag();
    }

    public MutableDoubleBag of()
    {
        return this.empty();
    }

    public MutableDoubleBag with()
    {
        return this.empty();
    }

    public MutableDoubleBag of(double... items)
    {
        return this.with(items);
    }

    public MutableDoubleBag with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        return DoubleHashBag.newBagWith(items);
    }

    public MutableDoubleBag ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public MutableDoubleBag withAll(DoubleIterable items)
    {
        return DoubleHashBag.newBag(items);
    }
}
